/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.INameable;

public abstract class TombstoneEnchantment
extends Enchantment
implements INameable {
    protected final String customName;
    private final Component info;

    TombstoneEnchantment(String customName, Enchantment.Rarity rarity, EnchantmentCategory type, EquipmentSlot ... slots) {
        super(rarity, type, slots);
        this.customName = customName;
        this.info = Component.m_237115_((String)(this.m_44704_() + ".desc")).m_6270_(StyleType.TOOLTIP_ENCHANT);
    }

    @Override
    public String getSimpleName() {
        return this.customName;
    }

    public abstract boolean isEnabled();

    public boolean isInBeta() {
        return false;
    }

    public int m_44702_() {
        return 1;
    }

    public int m_6586_() {
        return 10;
    }

    public int m_6183_(int amplifier) {
        return (Math.max(1, amplifier) - 1) * this.getScaledEnchantability() + this.getMinEnchantability();
    }

    public int m_6175_(int amplifier) {
        return this.m_6183_(amplifier + 1) - 1;
    }

    protected int getMinEnchantability() {
        return 1;
    }

    protected int getScaledEnchantability() {
        return 10;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.isEnabled() && this.f_44672_.m_7454_(stack.m_41720_());
    }

    public boolean m_6081_(ItemStack stack) {
        return this.isEnabled() && this.f_44672_.m_7454_(stack.m_41720_());
    }

    public boolean isAllowedOnBooks() {
        return this.isEnabled();
    }

    public List<Component> getTooltipInfos(boolean isEnchantedBook) {
        ArrayList<Component> infos = new ArrayList<Component>();
        if (isEnchantedBook) {
            infos.add(this.info);
        }
        if (this.isInBeta()) {
            infos.add((Component)LangKey.TOOLTIP_BETA.getText(StyleType.MESSAGE_SPELL, new Object[0]));
        }
        if (!this.isEnabled()) {
            infos.add((Component)LangKey.MESSAGE_DISABLED.getText(StyleType.COLOR_OFF, new Object[0]));
        }
        return infos;
    }

    public String m_44704_() {
        return "enchantment.tombstone." + this.customName;
    }

    public Component m_44700_(int level) {
        MutableComponent fullname = Component.m_237115_((String)this.m_44704_()).m_130940_(ChatFormatting.GRAY);
        return level > 1 ? fullname.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)EffectHelper.getPotency(level))) : fullname;
    }
}

