/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.entity.EntityTypeTest;
import ovh.corail.tombstone.command.ISubCommand;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.spawner.CustomVillageSiege;

public final class CommandTBSiege
extends TombstoneCommand {
    @Override
    protected TombstoneCommand.CommandName getCommandName() {
        return TombstoneCommand.CommandName.SIEGE;
    }

    @Override
    LiteralArgumentBuilder<CommandSourceStack> getBuilder(LiteralArgumentBuilder<CommandSourceStack> builder) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.executes(this::showUsage)).then(((LiteralArgumentBuilder)SubCommand.START.literal().executes(c -> this.startSiege((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).m_81377_().m_129783_()))).then(Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).executes(c -> this.startSiege((CommandSourceStack)c.getSource(), DimensionArgument.m_88808_((CommandContext)c, (String)"dim")))))).then(((LiteralArgumentBuilder)SubCommand.STOP.literal().executes(c -> this.stopSiege((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).m_81377_().m_129783_()))).then(Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).executes(c -> this.stopSiege((CommandSourceStack)c.getSource(), DimensionArgument.m_88808_((CommandContext)c, (String)"dim")))));
    }

    private int startSiege(CommandSourceStack sender, ServerLevel level) {
        if (!((Boolean)ConfigTombstone.village_siege.handleVillageSiege.get()).booleanValue()) {
            throw LangKey.MESSAGE_DISABLED_COMMAND.asCommandException(new Object[0]);
        }
        if (level.m_6106_().m_5472_() == Difficulty.PEACEFUL) {
            throw LangKey.MESSAGE_DIFFICULTY_PEACEFUL.asCommandException(new Object[0]);
        }
        CustomVillageSiege villageSiege = this.getVillageSiege(level);
        if (level.m_46461_()) {
            sender.m_81377_().m_129785_().forEach(w -> w.m_8615_(18001L));
        }
        if (!villageSiege.startSiege(100)) {
            throw LangKey.MESSAGE_START_SIEGE_FAILED.asCommandException(new Object[0]);
        }
        this.sendMessage(sender, LangKey.MESSAGE_START_SIEGE_SUCCESS.getText(new Object[0]), false);
        return 1;
    }

    private int stopSiege(CommandSourceStack sender, ServerLevel level) {
        if (!((Boolean)ConfigTombstone.village_siege.handleVillageSiege.get()).booleanValue()) {
            throw LangKey.MESSAGE_DISABLED_COMMAND.asCommandException(new Object[0]);
        }
        CustomVillageSiege villageSiege = this.getVillageSiege(level);
        boolean stopped = villageSiege.stopSiege();
        List entities = level.m_143280_((EntityTypeTest)EntityType.f_20501_, z -> z.getPersistentData().m_128471_("siege"));
        entities.forEach(Entity::m_146870_);
        if (!stopped && entities.size() == 0) {
            throw LangKey.MESSAGE_STOP_SIEGE_FAILED.asCommandException(new Object[0]);
        }
        this.sendMessage(sender, LangKey.MESSAGE_STOP_SIEGE_SUCCESS.getText(new Object[0]), false);
        return 1;
    }

    private CustomVillageSiege getVillageSiege(ServerLevel level) {
        return level.f_8558_.stream().filter(CustomVillageSiege.class::isInstance).map(CustomVillageSiege.class::cast).findFirst().orElseThrow(() -> LangKey.MESSAGE_NO_VILLAGE_SIEGE_SPAWNER.asCommandException(level.m_46472_().m_135782_()));
    }

    private static enum SubCommand implements ISubCommand
    {
        START,
        STOP;

    }
}

