/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part;

import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.MultiblockReprocessor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part.AbstractReprocessorEntity;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.TileCommandDispatcher;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.network.INetworkTileEntitySyncProvider;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.LogicalSide;

public class ReprocessorControllerEntity
extends AbstractReprocessorEntity
implements MenuProvider,
INetworkTileEntitySyncProvider {
    public ReprocessorControllerEntity(BlockPos position, BlockState blockState) {
        super((BlockEntityType)Content.TileEntityTypes.REPROCESSOR_CONTROLLER.get(), position, blockState);
        this.setCommandDispatcher(TileCommandDispatcher.builder().addServerHandler(CommonConstants.COMMAND_ACTIVATE, rce -> rce.setReprocessorActive(true)).addServerHandler(CommonConstants.COMMAND_DEACTIVATE, rce -> rce.setReprocessorActive(false)).addServerHandler(CommonConstants.COMMAND_VOID_FLUID, rce -> rce.voidFluid()).build((AbstractModBlockEntity)this));
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        return (byte)(this.isMachineAssembled() ? (this.isReprocessorActive() ? 1 : 2) : 0);
    }

    @Override
    public void onPostMachineAssembled(MultiblockReprocessor controller) {
        super.onPostMachineAssembled(controller);
        this.listenForControllerDataUpdates();
    }

    @Override
    public void onMachineActivated() {
        super.onMachineActivated();
        this.requestClientRenderUpdate();
    }

    @Override
    public void onMachineDeactivated() {
        super.onMachineDeactivated();
        this.requestClientRenderUpdate();
    }

    @Override
    public boolean isGoodForPosition(PartPosition position, IMultiblockValidator validatorCallback) {
        return position.isVerticalFace() || super.isGoodForPosition(position, validatorCallback);
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        super.getDebugMessages(side, messages);
        this.executeOnController(c -> c.getDebugMessages(side, messages));
    }

    public boolean canOpenGui(Level world, BlockPos position, BlockState state) {
        return this.isMachineAssembled();
    }

    public void enlistForUpdates(ServerPlayer player, boolean updateNow) {
        this.executeOnController(c -> c.enlistForUpdates(player, updateNow));
    }

    public void delistFromUpdates(ServerPlayer player) {
        this.executeOnController(c -> c.delistFromUpdates(player));
    }

    public void sendUpdates() {
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        return ModTileContainer.empty((MenuType)((MenuType)Content.ContainerTypes.REPROCESSOR_CONTROLLER.get()), (int)windowId, (AbstractModBlockEntity)this, (ServerPlayer)((ServerPlayer)player));
    }

    public Component m_5446_() {
        return super.getPartDisplayName();
    }

    private void voidFluid() {
        this.getMultiblockController().filter(AbstractMultiblockController::isAssembled).ifPresent(MultiblockReprocessor::voidFluid);
    }
}

