/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part;

import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.api.IMapping;
import it.zerono.mods.extremereactors.api.reactor.Reactant;
import it.zerono.mods.extremereactors.api.reactor.ReactantMappingsRegistry;
import it.zerono.mods.extremereactors.api.reactor.ReactantType;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IFuelSource;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.ReactantHelper;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.AbstractReactorEntity;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.DebuggableHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.INeighborChangeListener;
import it.zerono.mods.zerocore.lib.block.TileCommandDispatcher;
import it.zerono.mods.zerocore.lib.data.IIoEntity;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.nbt.IConditionallySyncableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.stack.IStackHolder;
import it.zerono.mods.zerocore.lib.fluid.FluidHelper;
import it.zerono.mods.zerocore.lib.fluid.FluidTank;
import it.zerono.mods.zerocore.lib.fluid.handler.FluidHandlerForwarder;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.LogicalSide;

public class ReactorFluidAccessPortEntity
extends AbstractReactorEntity
implements IFuelSource<FluidStack>,
IIoEntity,
INeighborChangeListener,
MenuProvider,
IConditionallySyncableEntity {
    public static int TANK_CAPACITY = 8000;
    private static Capability<IFluidHandler> FLUID_HANDLER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IFluidHandler>(){});
    private static final ResourceLocation SYNC_DATA_ID = ExtremeReactors.newID("injector");
    private final FluidTank _fuelTank;
    private final FluidTank _wasteTank;
    private final LazyOptional<IFluidHandler> _fuelCapability;
    private final LazyOptional<IFluidHandler> _wasteCapability;
    private IoDirection _direction;
    private boolean _shouldSync;

    public ReactorFluidAccessPortEntity(BlockPos position, BlockState blockState) {
        super((BlockEntityType)Content.TileEntityTypes.REACTOR_FLUID_ACCESSPORT.get(), position, blockState);
        this.setIoDirection(IoDirection.Input);
        this._fuelTank = (FluidTank)((FluidTank)new FluidTank(TANK_CAPACITY).setOnLoadListener(this::onTankChanged)).setOnContentsChangedListener(this::onTankChanged);
        this._wasteTank = (FluidTank)((FluidTank)new FluidTank(TANK_CAPACITY).setOnLoadListener(this::onTankChanged)).setOnContentsChangedListener(this::onTankChanged);
        this._fuelCapability = LazyOptional.of(this::createFuelCapability);
        this._wasteCapability = LazyOptional.of(this::createWasteCapability);
        this._shouldSync = false;
        this.setCommandDispatcher(TileCommandDispatcher.builder().addServerHandler(CommonConstants.COMMAND_SET_INPUT, tile -> tile.setIoDirection(IoDirection.Input)).addServerHandler(CommonConstants.COMMAND_SET_OUTPUT, tile -> tile.setIoDirection(IoDirection.Output)).addServerHandler(CommonConstants.COMMAND_DUMP_FUEL, ReactorFluidAccessPortEntity::handleCommandEjectFuel).addServerHandler(CommonConstants.COMMAND_DUMP_WASTE, ReactorFluidAccessPortEntity::handleCommandEjectWaste).build((AbstractModBlockEntity)this));
    }

    public IFluidHandler getFluidStackHandler(ReactantType type) {
        return type.isFuel() ? this._fuelTank : this._wasteTank;
    }

    public void onItemsReceived() {
        this.markChunkDirty();
    }

    public static void itemTooltipBuilder(ItemStack stack, CompoundTag data, @Nullable BlockGetter world, NonNullConsumer<Component> appender, boolean isAdvancedTooltip) {
        FluidTank tank = new FluidTank(TANK_CAPACITY);
        if (data.m_128441_("iodir")) {
            appender.accept((Object)Component.m_237115_((String)(IoDirection.read((CompoundTag)data, (String)"iodir", (IoDirection)IoDirection.Input).isInput() ? "gui.bigreactors.reactor.fluidaccessport.directioninput.line1" : "gui.bigreactors.reactor.fluidaccessport.directionoutput.line1")).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
        }
        if (data.m_128441_("invin")) {
            tank.syncDataFrom(data.m_128469_("invin"), ISyncableEntity.SyncReason.FullSync);
            appender.accept((Object)ReactorFluidAccessPortEntity.getTankTooltip(tank, "gui.bigreactors.generic.fuel.label"));
        }
        if (data.m_128441_("invout")) {
            tank.syncDataFrom(data.m_128469_("invout"), ISyncableEntity.SyncReason.FullSync);
            appender.accept((Object)ReactorFluidAccessPortEntity.getTankTooltip(tank, "gui.bigreactors.generic.waste.label"));
        }
    }

    private static Component getTankTooltip(FluidTank tank, String labelKey) {
        MutableComponent text = tank.isEmpty() ? Component.m_237115_((String)"gui.bigreactors.generic.empty") : Component.m_237110_((String)"gui.bigreactors.reactor.fluidaccessport.item.reactant", (Object[])new Object[]{FluidHelper.getFluidName((FluidStack)tank.getFluid()), tank.getFluidAmount(), TANK_CAPACITY});
        return Component.m_237115_((String)labelKey).m_7220_((Component)text.m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        int connectedOffset = this.isMachineAssembled() && this.getNeighborCapability().isPresent() ? 1 : 0;
        return this.getIoDirection().isInput() ? 2 + connectedOffset : 0 + connectedOffset;
    }

    @Override
    public FluidStack getFuelStack() {
        return this.getStack(ReactantType.Fuel);
    }

    @Override
    public FluidStack consumeFuelSource(FluidStack sourceToConsume) {
        FluidStack sourceStack = this.getStack(ReactantType.Fuel);
        if (sourceStack.isEmpty() || sourceToConsume.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return this._fuelTank.drain(sourceToConsume, IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public int emitReactant(Reactant reactant, int amount) {
        int maxOutputAmount = this._wasteTank.getCapacity();
        if (amount <= 0 || maxOutputAmount <= 0) {
            return 0;
        }
        FluidStack outputStack = this.getStack(ReactantType.Waste);
        if (!outputStack.isEmpty() && outputStack.getAmount() >= maxOutputAmount) {
            return 0;
        }
        if (!outputStack.isEmpty()) {
            IMapping mapping = ReactantMappingsRegistry.getFromFluid(outputStack).orElse(null);
            if (null == mapping || !reactant.equals(mapping.getProduct())) {
                return 0;
            }
            int amountToProduce = Math.min(amount, maxOutputAmount - outputStack.getAmount());
            if (amountToProduce <= 0) {
                return 0;
            }
            int filled = this._wasteTank.fill(FluidHelper.stackFrom((FluidStack)outputStack, (int)amountToProduce), IFluidHandler.FluidAction.EXECUTE);
            this.onItemsReceived();
            return filled;
        }
        IMapping bestMapping = ReactantMappingsRegistry.getToFluid(reactant).filter(list -> !list.isEmpty()).map(list -> (IMapping)list.get(0)).orElse(null);
        if (null == bestMapping) {
            Log.LOGGER.warn(Log.REACTOR, "There are no mapped fluid types for reactant {}. Nothing to emit here.", (Object)reactant);
            return 0;
        }
        outputStack = ReactantMappingsRegistry.getFluidStackFrom(bestMapping, Math.min(amount, maxOutputAmount));
        if (outputStack.isEmpty()) {
            Log.LOGGER.warn(Log.REACTOR, "Can't create a stack from tag {}. Nothing to emit here.", bestMapping.getProduct());
            return 0;
        }
        int filled = this._wasteTank.fill(outputStack, IFluidHandler.FluidAction.EXECUTE);
        this.onItemsReceived();
        return filled;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        return ModTileContainer.empty((MenuType)((MenuType)Content.ContainerTypes.REACTOR_FLUID_ACCESSPORT.get()), (int)windowId, (AbstractModBlockEntity)this, (ServerPlayer)((ServerPlayer)player));
    }

    public Component m_5446_() {
        return super.getPartDisplayName();
    }

    public IoDirection getIoDirection() {
        return this._direction;
    }

    public void setIoDirection(IoDirection direction) {
        if (this.getIoDirection() == direction) {
            return;
        }
        this._direction = direction;
        this.notifyBlockUpdate();
        this.callOnLogicalSide(() -> {
            this.notifyOutwardNeighborsOfStateChange();
            this.m_6596_();
        }, this::markForRenderUpdate);
        this.notifyNeighborsOfTileChange();
    }

    public void onNeighborBlockChanged(BlockState state, BlockPos neighborPosition, boolean isMoving) {
        this.requestClientRenderUpdate();
    }

    public void onNeighborTileChanged(BlockState state, BlockPos neighborPosition) {
        this.requestClientRenderUpdate();
    }

    public void syncDataFrom(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        this.setIoDirection(IoDirection.read((CompoundTag)data, (String)"iodir", (IoDirection)IoDirection.Input));
        this.syncChildDataEntityFrom((ISyncableEntity)this._fuelTank, "invin", data, syncReason);
        this.syncChildDataEntityFrom((ISyncableEntity)this._wasteTank, "invout", data, syncReason);
        if (syncReason.isFullSync()) {
            this._shouldSync = true;
        }
    }

    public CompoundTag syncDataTo(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        IoDirection.write((CompoundTag)data, (String)"iodir", (IoDirection)this.getIoDirection());
        this.syncChildDataEntityTo((ISyncableEntity)this._fuelTank, "invin", data, syncReason);
        this.syncChildDataEntityTo((ISyncableEntity)this._wasteTank, "invout", data, syncReason);
        return data;
    }

    public ResourceLocation getSyncableEntityId() {
        return SYNC_DATA_ID;
    }

    public boolean shouldSyncEntity() {
        boolean result = this._shouldSync;
        this._shouldSync = false;
        return result;
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        super.getDebugMessages(side, messages);
        this.getIoDirection().getDebugMessages(side, messages);
        messages.add((Object)this.getFluidStackHandler(ReactantType.Fuel), DebuggableHelper::getDebugMessagesFor, "Fuel");
        messages.add((Object)this.getFluidStackHandler(ReactantType.Waste), DebuggableHelper::getDebugMessagesFor, "Waste");
    }

    public boolean canOpenGui(Level world, BlockPos position, BlockState state) {
        return true;
    }

    @Override
    public void onPostMachineAssembled(MultiblockReactor controller) {
        super.onPostMachineAssembled(controller);
        this.listenForControllerDataUpdates();
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (!this.m_58901_() && FLUID_HANDLER_CAPABILITY == capability) {
            if (this.getIoDirection().isInput()) {
                return this._fuelCapability.cast();
            }
            return this._wasteCapability.cast();
        }
        return super.getCapability(capability, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this._fuelCapability.invalidate();
        this._wasteCapability.invalidate();
    }

    private FluidStack getStack(ReactantType type) {
        return this.getFluidStackHandler(type).getFluidInTank(0);
    }

    private LazyOptional<IFluidHandler> getNeighborCapability() {
        return CodeHelper.optionalFlatMap((Optional)this.getPartWorld(), (Optional)this.getOutwardDirection(), (world, direction) -> WorldHelper.getTile((Level)world, (BlockPos)this.getWorldPosition().m_121945_(direction)).map(te -> te.getCapability(FLUID_HANDLER_CAPABILITY, direction.m_122424_()))).orElse(LazyOptional.empty());
    }

    @Nonnull
    private IFluidHandler createFuelCapability() {
        return new FluidHandlerForwarder(this.getFluidStackHandler(ReactantType.Fuel)){

            public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
                return this.isFluidValid(0, stack) ? super.fill(stack, action) : 0;
            }

            public boolean isFluidValid(int tank, FluidStack stack) {
                return ReactantHelper.isValidSource(ReactantType.Fuel, stack);
            }
        };
    }

    @Nonnull
    private IFluidHandler createWasteCapability() {
        return new FluidHandlerForwarder(this.getFluidStackHandler(ReactantType.Waste)){

            public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
                return 0;
            }

            public boolean isFluidValid(int tank, FluidStack stack) {
                return false;
            }
        };
    }

    private void onTankChanged(IStackHolder.ChangeType changeType, int slot) {
        this.onTankChanged();
    }

    private void onTankChanged() {
        this.m_6596_();
        this._shouldSync = true;
    }

    private void handleCommandEjectFuel(CompoundTag options) {
        this.getMultiblockController().ifPresent(c -> c.ejectFuel(options.m_128441_("void") && options.m_128471_("void")));
    }

    private void handleCommandEjectWaste(CompoundTag options) {
        this.getMultiblockController().ifPresent(c -> c.ejectWaste(options.m_128441_("void") && options.m_128471_("void")));
    }
}

