/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.datagen.recipes;

import com.google.common.collect.ImmutableSet;
import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.config.conditions.ConfigCondition;
import it.zerono.mods.extremereactors.gamecontent.ContentTags;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.variant.IMultiblockGeneratorVariant;
import it.zerono.mods.zerocore.lib.datagen.provider.recipe.BaseRecipeProvider;
import it.zerono.mods.zerocore.lib.tag.TagsHelper;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.util.NonNullFunction;

public abstract class AbstractRecipeGenerator
extends BaseRecipeProvider {
    protected static final String GROUP_GENERAL = "bigreactors:general";
    protected static final String GROUP_REACTOR = "bigreactors:reactor";
    protected static final String GROUP_TURBINE = "bigreactors:turbine";
    protected static final TagKey<Item> TAG_INGOTS_STEEL = TagsHelper.ITEMS.createKey("forge:ingots/steel");
    protected static final TagKey<Item> TAG_INGOTS_URANIUM = TagsHelper.ITEMS.createKey("forge:ingots/uranium");
    protected static final Set<TagKey<Item>> TAGS_YELLORIUM_INGOTS = ImmutableSet.of(ContentTags.Items.INGOTS_YELLORIUM, TAG_INGOTS_URANIUM);

    protected AbstractRecipeGenerator(DataGenerator generator) {
        super(generator);
    }

    protected void blastingAndSmelting(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> source, float xp, int smeltingTime) {
        this.blasting(consumer, name, ExtremeReactors::newID, result, source, xp, smeltingTime / 2);
        this.smelting(consumer, name, ExtremeReactors::newID, result, source, xp, smeltingTime);
    }

    protected void blastingAndSmelting(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> source, float xp, int smeltingTime, ICondition ... conditions) {
        this.blasting(consumer, name, ExtremeReactors::newID, result, source, xp, smeltingTime / 2, conditions);
        this.smelting(consumer, name, ExtremeReactors::newID, result, source, xp, smeltingTime, conditions);
    }

    protected void blastingAndSmelting(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> source) {
        this.blasting(consumer, name, ExtremeReactors::newID, result, source);
        this.smelting(consumer, name, ExtremeReactors::newID, result, source);
    }

    protected void blastingAndSmelting(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> source, ICondition ... conditions) {
        this.blasting(consumer, name, ExtremeReactors::newID, result, source, conditions);
        this.smelting(consumer, name, ExtremeReactors::newID, result, source, conditions);
    }

    protected void storageBlock3x3(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends ItemLike> component, Supplier<? extends ItemLike> storage) {
        this.storageBlock3x3(consumer, name, ExtremeReactors::newID, GROUP_GENERAL, component, storage);
    }

    protected void nugget(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends ItemLike> ingot, Supplier<? extends ItemLike> nugget) {
        this.nugget(consumer, name, (NonNullFunction<String, ResourceLocation>)((NonNullFunction)ExtremeReactors::newID), GROUP_GENERAL, ingot, nugget);
    }

    protected void nugget(Consumer<FinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, String group, Supplier<? extends ItemLike> ingot, Supplier<? extends ItemLike> nugget) {
        ShapelessRecipeBuilder.m_126189_((ItemLike)ingot.get()).m_126211_(nugget.get(), 9).m_126145_(group).m_126132_(name + "_has_ingot", (CriterionTriggerInstance)AbstractRecipeGenerator.m_125977_((ItemLike)ingot.get())).m_126140_(consumer, (ResourceLocation)nameToIdConverter.apply((Object)(name + "_ingot_to_nugget")));
        ShapelessRecipeBuilder.m_126191_((ItemLike)nugget.get(), (int)9).m_126209_(ingot.get()).m_126145_(group).m_126132_("has_item", (CriterionTriggerInstance)AbstractRecipeGenerator.m_125977_((ItemLike)nugget.get())).m_126140_(consumer, (ResourceLocation)nameToIdConverter.apply((Object)("crafting/" + name + "_nugget_to_ingot")));
    }

    protected <V extends IMultiblockGeneratorVariant> void generatorChargingPort(Consumer<FinishedRecipe> c, V variant, String name, String group, BiFunction<V, String, ResourceLocation> nameProvider, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> powerTap, ItemLike item1, ItemLike item2) {
        ShapedRecipeBuilder.m_126116_((ItemLike)result.get()).m_126127_(Character.valueOf('T'), powerTap.get()).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_126127_(Character.valueOf('1'), item1).m_126127_(Character.valueOf('2'), item2).m_126130_("212").m_126130_("GTG").m_126130_("212").m_126145_(group).m_126132_("has_item", (CriterionTriggerInstance)AbstractRecipeGenerator.m_125977_((ItemLike)powerTap.get())).m_126140_(c, nameProvider.apply(variant, name));
    }

    protected ICondition configCondition(String configName) {
        return new ConfigCondition(configName);
    }
}

