/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.core;

import com.mojang.brigadier.CommandDispatcher;
import fuzs.puzzleslib.core.ModConstructor;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.util.PuzzlesUtilForge;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.logging.log4j.util.Strings;

public class ForgeModConstructor {
    private final ModConstructor constructor;
    private final Object2IntOpenHashMap<Item> fuelBurnTimes = new Object2IntOpenHashMap();

    private ForgeModConstructor(ModConstructor constructor) {
        this.constructor = constructor;
        constructor.onConstructMod();
    }

    @SubscribeEvent
    public void onCommonSetup(FMLCommonSetupEvent evt) {
        this.constructor.onCommonSetup();
        this.constructor.onRegisterSpawnPlacements(SpawnPlacements::m_21754_);
        this.constructor.onRegisterFuelBurnTimes(this::registerFuelItem);
    }

    @SubscribeEvent
    public void onEntityAttributeCreation(EntityAttributeCreationEvent evt) {
        this.constructor.onEntityAttributeCreation((EntityType<? extends LivingEntity> entity, AttributeSupplier.Builder builder) -> evt.put(entity, builder.m_22265_()));
    }

    @SubscribeEvent
    public void onEntityAttributeModification(EntityAttributeModificationEvent evt) {
        this.constructor.onEntityAttributeModification((arg_0, arg_1, arg_2) -> ((EntityAttributeModificationEvent)evt).add(arg_0, arg_1, arg_2));
    }

    private void registerFuelItem(Item item, int burnTime) {
        if (burnTime > 0 && item != null) {
            this.fuelBurnTimes.put((Object)item, burnTime);
        }
    }

    private void onFurnaceFuelBurnTime(FurnaceFuelBurnTimeEvent evt) {
        Item item = evt.getItemStack().m_41720_();
        if (this.fuelBurnTimes.containsKey((Object)item)) {
            evt.setBurnTime(this.fuelBurnTimes.getInt((Object)item));
        }
    }

    private ModConstructor.LootTablesReplaceContext getLootTablesReplaceContext(LootTables lootManager, ResourceLocation id, LootTable lootTable, final Consumer<LootTable> lootTableSetter) {
        return new ModConstructor.LootTablesReplaceContext(lootManager, id, lootTable){

            @Override
            public void setLootTable(LootTable table) {
                lootTableSetter.accept(table);
            }
        };
    }

    private ModConstructor.LootTablesModifyContext getLootTablesModifyContext(LootTables lootManager, ResourceLocation id, final LootTable lootTable) {
        return new ModConstructor.LootTablesModifyContext(lootManager, id){

            @Override
            public void addLootPool(LootPool pool) {
                lootTable.addPool(pool);
            }

            @Override
            public boolean removeLootPool(int index) {
                if (index == 0 && lootTable.removePool("main") != null) {
                    return true;
                }
                return lootTable.removePool("pool" + index) != null;
            }
        };
    }

    public static void construct(String modId, ModConstructor constructor) {
        if (Strings.isBlank((String)modId)) {
            throw new IllegalArgumentException("modId cannot be empty");
        }
        PuzzlesLib.LOGGER.info("Constructing common components for mod {}", (Object)modId);
        ForgeModConstructor forgeModConstructor = new ForgeModConstructor(constructor);
        PuzzlesUtilForge.findModEventBus(modId).register((Object)forgeModConstructor);
        MinecraftForge.EVENT_BUS.addListener(forgeModConstructor::onFurnaceFuelBurnTime);
        MinecraftForge.EVENT_BUS.addListener(evt -> constructor.onRegisterCommands(new ModConstructor.RegisterCommandsContext((CommandDispatcher<CommandSourceStack>)evt.getDispatcher(), evt.getBuildContext(), evt.getCommandSelection())));
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            constructor.onLootTableReplacement(forgeModConstructor.getLootTablesReplaceContext(evt.getLootTableManager(), evt.getName(), evt.getTable(), arg_0 -> ((LootTableLoadEvent)evt).setTable(arg_0)));
            constructor.onLootTableModification(forgeModConstructor.getLootTablesModifyContext(evt.getLootTableManager(), evt.getName(), evt.getTable()));
        });
    }
}

