/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.modules.farmersrespite.content.logistics.block.mechanicalArm;

import com.simibubi.create.content.logistics.block.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmInteractionPointType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createcentralkitchen.modules.farmersdelight.content.contraptions.blazeStove.BlazeStoveBlockEntity;
import plus.dragons.createcentralkitchen.modules.farmersrespite.content.logistics.item.guide.BrewingGuide;
import plus.dragons.createcentralkitchen.modules.farmersrespite.content.logistics.item.guide.BrewingGuideItem;
import umpaz.farmersrespite.common.block.KettleBlock;
import umpaz.farmersrespite.common.block.entity.KettleBlockEntity;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class KettlePoint
extends ArmInteractionPoint {
    public static final int INPUT_SLOT_COUNT = 2;
    public static final int CONTAINER_SLOT = 3;
    public static final int OUTPUT_SLOT = 4;

    public KettlePoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
        super(type, level, pos, state);
    }

    protected Vec3 getInteractionPositionVector() {
        return Vec3.m_82514_((Vec3i)this.pos, (double)0.625);
    }

    @Nullable
    protected IItemHandler getHandler() {
        if (!this.cachedHandler.isPresent()) {
            BlockEntity te = this.level.m_7702_(this.pos);
            if (!(te instanceof KettleBlockEntity)) {
                return null;
            }
            KettleBlockEntity kettle = (KettleBlockEntity)te;
            this.cachedHandler = LazyOptional.of(() -> ((KettleBlockEntity)kettle).getInventory());
        }
        return (IItemHandler)this.cachedHandler.orElse(null);
    }

    public ItemStack insert(ItemStack stack, boolean simulate) {
        BlockEntity blockEntity = this.level.m_7702_(this.pos.m_7495_());
        if (!(blockEntity instanceof BlazeStoveBlockEntity)) {
            return stack;
        }
        BlazeStoveBlockEntity blazeStove = (BlazeStoveBlockEntity)blockEntity;
        ItemStack guideStack = blazeStove.getGuide();
        if (!(guideStack.m_41720_() instanceof BrewingGuideItem)) {
            return stack;
        }
        BrewingGuide guide = BrewingGuide.of(guideStack);
        if (guide.getResult().m_41619_()) {
            return stack;
        }
        IItemHandler inventory = this.getHandler();
        if (inventory == null) {
            return stack;
        }
        if (inventory.getStackInSlot(3).m_41619_() && guide.isContainer(stack)) {
            return inventory.insertItem(3, stack, simulate);
        }
        boolean[] neededSlots = new boolean[2];
        int neededSlotCount = 0;
        for (int slot = 0; slot < 2; ++slot) {
            if (!inventory.getStackInSlot(slot).m_41619_() || !guide.needIngredient(slot) || !guide.isIngredient(slot, stack)) continue;
            neededSlots[slot] = true;
            ++neededSlotCount;
        }
        if (neededSlotCount == 0) {
            if (guide.needWater()) {
                return this.insertWater(guide, inventory, stack, simulate);
            }
            return stack;
        }
        int countPerSlot = stack.m_41613_() / neededSlotCount;
        ItemStack ret = stack.m_41777_();
        for (int slot = 0; slot < 2; ++slot) {
            if (!neededSlots[slot]) continue;
            ItemStack inserted = ret.m_41620_(countPerSlot);
            inventory.insertItem(slot, inserted, simulate);
        }
        return ret;
    }

    private ItemStack insertWater(BrewingGuide guide, IItemHandler inventory, ItemStack stack, boolean simulate) {
        BlockState state = this.level.m_8055_(this.pos);
        int waterLevel = (Integer)state.m_61143_((Property)KettleBlock.WATER_LEVEL);
        if (waterLevel == 3) {
            return stack;
        }
        int waterIncrement = 0;
        ItemStack remainder = stack.m_41777_();
        ItemStack container = ItemStack.f_41583_;
        if (stack.m_150930_(Items.f_42447_)) {
            waterIncrement = 3 - waterLevel;
            remainder.m_41774_(1);
            container = Items.f_42446_.m_7968_();
        } else if (stack.m_150930_(Items.f_42589_) && PotionUtils.m_43579_((ItemStack)stack) == Potions.f_43599_) {
            waterIncrement = Math.max(stack.m_41613_(), 3 - waterLevel);
            remainder.m_41774_(waterIncrement);
            container = new ItemStack((ItemLike)Items.f_42590_, waterIncrement);
        }
        if (waterIncrement > 0 && !simulate) {
            if (guide.isContainer(container)) {
                container = inventory.insertItem(3, container, true);
            }
            if (!container.m_41619_()) {
                Direction direction = ((Direction)state.m_61143_((Property)KettleBlock.FACING)).m_122428_();
                double x = (double)this.pos.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.25;
                double y = (double)this.pos.m_123342_() + 0.7;
                double z = (double)this.pos.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.25;
                ItemUtils.spawnItemEntity((Level)this.level, (ItemStack)container, (double)x, (double)y, (double)z, (double)((double)direction.m_122429_() * 0.08), (double)0.25, (double)((double)direction.m_122431_() * 0.08));
            }
            this.level.m_46597_(this.pos, (BlockState)state.m_61124_((Property)KettleBlock.WATER_LEVEL, (Comparable)Integer.valueOf(waterLevel + waterIncrement)));
        }
        return remainder;
    }

    public ItemStack extract(int slot, int amount, boolean simulate) {
        ItemStack container;
        ItemStack ingredient;
        if (slot == 4) {
            return super.extract(slot, amount, simulate);
        }
        BlockEntity blockEntity = this.level.m_7702_(this.pos.m_7495_());
        if (!(blockEntity instanceof BlazeStoveBlockEntity)) {
            return ItemStack.f_41583_;
        }
        BlazeStoveBlockEntity blazeStove = (BlazeStoveBlockEntity)blockEntity;
        ItemStack guideStack = blazeStove.getGuide();
        if (!(guideStack.m_41720_() instanceof BrewingGuideItem)) {
            return ItemStack.f_41583_;
        }
        BrewingGuide guide = BrewingGuide.of(guideStack);
        if (guide.getResult().m_41619_()) {
            return ItemStack.f_41583_;
        }
        IItemHandler inventory = this.getHandler();
        if (inventory == null) {
            return ItemStack.f_41583_;
        }
        if (slot < 2 ? !(ingredient = inventory.getStackInSlot(slot)).m_41619_() && !guide.isIngredient(slot, ingredient) : slot == 3 && !(container = inventory.getStackInSlot(slot)).m_41619_() && !guide.isContainer(container)) {
            return inventory.extractItem(slot, amount, simulate);
        }
        return ItemStack.f_41583_;
    }

    public static class Type
    extends ArmInteractionPointType {
        public Type(ResourceLocation id) {
            super(id);
        }

        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return level.m_7702_(pos) instanceof KettleBlockEntity && level.m_7702_(pos.m_7495_()) instanceof BlazeStoveBlockEntity;
        }

        @Nullable
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new KettlePoint(this, level, pos, state);
        }
    }
}

