/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.modules.farmersdelight.entry;

import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.fluids.VirtualFluid;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.MissingMappingsEvent;
import net.minecraftforge.registries.RegistryObject;
import plus.dragons.createcentralkitchen.CentralKitchen;
import plus.dragons.createcentralkitchen.core.fluid.SimpleTintedFluidType;
import plus.dragons.createcentralkitchen.data.recipe.RecipeGen;
import plus.dragons.createcentralkitchen.modules.farmersdelight.FarmersDelightModule;
import vectorwing.farmersdelight.common.registry.ModItems;

public class FdFluids {
    public static final FluidEntry<VirtualFluid> APPLE_CIDER = FdFluids.wateryDrink("apple_cider", 13011527, (RegistryObject<? extends ItemLike>)ModItems.APPLE_CIDER).register();
    public static final FluidEntry<VirtualFluid> HOT_COCOA = FdFluids.thickDrink("hot_cocoa", 11496524, (RegistryObject<? extends ItemLike>)ModItems.HOT_COCOA).register();
    public static final FluidEntry<VirtualFluid> MELON_JUICE = FdFluids.wateryDrink("melon_juice", 14828340, (RegistryObject<? extends ItemLike>)ModItems.MELON_JUICE).register();
    public static final FluidEntry<VirtualFluid> TOMATO_SAUCE = FdFluids.customDrink("tomato_sauce", (RegistryObject<? extends ItemLike>)ModItems.TOMATO_SAUCE).register();
    private static final Map<ResourceLocation, FluidEntry<?>> REMAP = new HashMap();

    private static FluidBuilder<VirtualFluid, CreateRegistrate> wateryDrink(String name, int color, RegistryObject<? extends ItemLike> drink) {
        return (FluidBuilder)CentralKitchen.REGISTRATE.virtualFluid(name, new ResourceLocation("forge", "block/milk_still"), new ResourceLocation("forge", "block/milk_flowing"), SimpleTintedFluidType.factory(0xFF000000 | color), VirtualFluid::new).defaultLang().transform(RecipeGen.fluidHandling(drink, 250));
    }

    private static FluidBuilder<VirtualFluid, CreateRegistrate> thickDrink(String name, int color, RegistryObject<? extends ItemLike> drink) {
        return (FluidBuilder)CentralKitchen.REGISTRATE.virtualFluid(name, Create.asResource((String)"fluid/milk_still"), Create.asResource((String)"fluid/milk_flow"), SimpleTintedFluidType.factory(0xFF000000 | color), VirtualFluid::new).defaultLang().transform(RecipeGen.fluidHandling(drink, 250));
    }

    private static FluidBuilder<VirtualFluid, CreateRegistrate> customDrink(String name, RegistryObject<? extends ItemLike> drink) {
        return (FluidBuilder)CentralKitchen.REGISTRATE.virtualFluid(name, CentralKitchen.genRL("fluid/" + name + "_still"), CentralKitchen.genRL("fluid/" + name + "_flow")).defaultLang().transform(RecipeGen.fluidHandling(drink, 250));
    }

    public static void remap(MissingMappingsEvent event) {
        for (MissingMappingsEvent.Mapping mapping : event.getMappings(Registry.f_122899_, "farmersdelight")) {
            if (!REMAP.containsKey(mapping.getKey())) continue;
            FluidEntry<?> entry = REMAP.get(mapping.getKey());
            mapping.remap((Object)((Fluid)entry.get()));
            FarmersDelightModule.LOGGER.warn("Remapping fluid '{}' to '{}'...", (Object)mapping.getKey(), (Object)entry.getId());
        }
    }

    public static void register() {
    }

    static {
        REMAP.put(FarmersDelightModule.genRL("apple_cider"), APPLE_CIDER);
        REMAP.put(FarmersDelightModule.genRL("hot_cocoa"), HOT_COCOA);
        REMAP.put(FarmersDelightModule.genRL("melon_juice"), MELON_JUICE);
        REMAP.put(FarmersDelightModule.genRL("tomato_sauce"), TOMATO_SAUCE);
    }
}

