/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.modules.farmersdelight.content.contraptions.blazeStove;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.items.ItemStackHandler;
import plus.dragons.createcentralkitchen.modules.farmersdelight.content.contraptions.blazeStove.BlazeStoveBlockEntity;
import plus.dragons.createcentralkitchen.modules.farmersdelight.entry.FdBlockPartials;
import vectorwing.farmersdelight.common.block.StoveBlock;

public class BlazeStoveRenderer
extends SafeTileEntityRenderer<BlazeStoveBlockEntity> {
    public BlazeStoveRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(BlazeStoveBlockEntity stove, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        BlazeStoveRenderer.renderItem(stove, poseStack, buffer);
        BlazeBurnerBlock.HeatLevel heatLevel = stove.getHeatLevelFromBlock();
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        BlazeStoveRenderer.renderBlaze(stove, partialTicks, poseStack, buffer);
    }

    protected static void renderItem(BlazeStoveBlockEntity stove, PoseStack poseStack, MultiBufferSource buffer) {
        ItemStackHandler inventory = stove.getInventory();
        Direction direction = ((Direction)stove.m_58900_().m_61143_((Property)StoveBlock.FACING)).m_122424_();
        int directionIndex = direction.m_122416_();
        Vec2[] offsets = directionIndex % 2 == 0 ? BlazeStoveBlockEntity.ITEM_OFFSET_NS : BlazeStoveBlockEntity.ITEM_OFFSET_WE;
        int seed = (int)stove.m_58899_().m_121878_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.0125, 0.5);
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack stack = inventory.getStackInSlot(slot);
            if (stack.m_41619_()) continue;
            poseStack.m_85836_();
            float directionRot = -direction.m_122435_();
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(directionRot));
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            poseStack.m_85837_((double)offsets[slot].f_82470_, (double)offsets[slot].f_82471_, 0.0);
            poseStack.m_85841_(0.3125f, 0.3125f, 0.3125f);
            Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.FIXED, 0xF000F0, OverlayTexture.f_118083_, poseStack, buffer, seed + slot);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    protected static void renderBlaze(BlazeStoveBlockEntity stove, float partialTicks, PoseStack poseStack, MultiBufferSource buffer) {
        Level level = stove.m_58904_();
        BlockState blockState = stove.m_58900_();
        BlazeBurnerBlock.HeatLevel heatLevel = BlazeBurnerBlock.getHeatLevelOf((BlockState)blockState);
        int hashCode = ((Object)((Object)stove)).hashCode();
        float horizontalAngle = AngleHelper.rad((double)stove.getHeadAngle().getValue(partialTicks));
        float animation = stove.getHeadAnimation().getValue(partialTicks) * 0.175f;
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)level);
        float renderTick = time + (float)(hashCode % 13) * 16.0f;
        float offsetMult = heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) ? 64.0f : 16.0f;
        float offset = Mth.m_14031_((float)((float)((double)(renderTick / 16.0f) % (Math.PI * 2)))) / offsetMult;
        float offset1 = Mth.m_14031_((float)((float)(((double)(renderTick / 16.0f) + Math.PI) % (Math.PI * 2)))) / offsetMult;
        float offset2 = Mth.m_14031_((float)((float)(((double)(renderTick / 16.0f) + 1.5707963267948966) % (Math.PI * 2)))) / offsetMult;
        boolean blockAbove = animation > 0.125f;
        VertexConsumer solid = buffer.m_6299_(RenderType.m_110451_());
        VertexConsumer cutout = buffer.m_6299_(RenderType.m_110457_());
        poseStack.m_85836_();
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) && blockAbove) {
            SpriteShiftEntry spriteShift = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllSpriteShifts.SUPER_BURNER_FLAME : AllSpriteShifts.BURNER_FLAME;
            float spriteWidth = spriteShift.getTarget().m_118410_() - spriteShift.getTarget().m_118409_();
            float spriteHeight = spriteShift.getTarget().m_118412_() - spriteShift.getTarget().m_118411_();
            float speed = 0.03125f + 0.015625f * (float)heatLevel.ordinal();
            double vScroll = speed * time;
            vScroll -= Math.floor(vScroll);
            vScroll = vScroll * (double)spriteHeight / 2.0;
            double uScroll = speed * time / 2.0f;
            uScroll -= Math.floor(uScroll);
            uScroll = uScroll * (double)spriteWidth / 2.0;
            BlazeStoveRenderer.draw(CachedBufferer.partial((PartialModel)AllBlockPartials.BLAZE_BURNER_FLAME, (BlockState)blockState).shiftUVScrolling(spriteShift, (float)uScroll, (float)vScroll), horizontalAngle, poseStack, cutout);
        }
        PartialModel blazeModel = AllBlockPartials.BLAZE_INERT;
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING)) {
            blazeModel = blockAbove ? AllBlockPartials.BLAZE_SUPER_ACTIVE : AllBlockPartials.BLAZE_SUPER;
        } else if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            blazeModel = blockAbove && heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.KINDLED) ? AllBlockPartials.BLAZE_ACTIVE : AllBlockPartials.BLAZE_IDLE;
        }
        float headY = offset - animation * 0.75f;
        BlazeStoveRenderer.draw(CachedBufferer.partial((PartialModel)blazeModel, (BlockState)blockState).translate(0.0, (double)headY, 0.0), horizontalAngle, poseStack, solid);
        SuperByteBuffer partial = CachedBufferer.partial((PartialModel)FdBlockPartials.BLAZE_STOVE_HAT, (BlockState)blockState).translate(0.0, (double)headY, 0.0);
        if (blazeModel == AllBlockPartials.BLAZE_INERT) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)partial.translateY(0.5)).centre()).scale(0.75f)).unCentre();
        } else {
            partial.translateY(0.71875);
        }
        partial.rotateCentered(Direction.UP, horizontalAngle + (float)Math.PI).translate(0.5, 0.0, 0.5).light(0xF000F0).renderInto(poseStack, solid);
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            PartialModel rods = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllBlockPartials.BLAZE_BURNER_SUPER_RODS : AllBlockPartials.BLAZE_BURNER_RODS;
            PartialModel rods2 = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllBlockPartials.BLAZE_BURNER_SUPER_RODS_2 : AllBlockPartials.BLAZE_BURNER_RODS_2;
            BlazeStoveRenderer.draw(CachedBufferer.partial((PartialModel)rods, (BlockState)blockState).translate(0.0, (double)(offset1 + animation + 0.125f), 0.0), 0.0f, poseStack, solid);
            BlazeStoveRenderer.draw(CachedBufferer.partial((PartialModel)rods2, (BlockState)blockState).translate(0.0, (double)(offset2 + animation - 0.1875f), 0.0), 0.0f, poseStack, solid);
        }
        poseStack.m_85849_();
    }

    private static void draw(SuperByteBuffer blazeBuffer, float horizontalAngle, PoseStack ms, VertexConsumer vb) {
        blazeBuffer.rotateCentered(Direction.UP, horizontalAngle).light(0xF000F0).renderInto(ms, vb);
    }
}

