/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.modules.farmersdelight.content.contraptions.blazeStove;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class BlazeStoveGuide
implements ICapabilitySerializable<CompoundTag> {
    protected final ItemStack owner;
    protected final int ingredientSize;
    protected final ItemStackHandler inventory;
    protected ItemStack container = ItemStack.f_41583_;
    protected RecipeWrapper recipeWrapper;

    public BlazeStoveGuide(ItemStack owner, int ingredientSize) {
        this.owner = owner;
        this.ingredientSize = ingredientSize;
        this.inventory = new ItemStackHandler(ingredientSize + 1);
        this.recipeWrapper = new RecipeWrapper((IItemHandlerModifiable)this.inventory);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag ingredientsTag = new ListTag();
        for (byte i = 0; i < this.ingredientSize; i = (byte)((byte)(i + 1))) {
            ItemStack itemstack = this.inventory.getStackInSlot((int)i);
            if (itemstack.m_41619_()) continue;
            CompoundTag ingredientTag = new CompoundTag();
            ingredientTag.m_128344_("Slot", i);
            itemstack.m_41739_(ingredientTag);
            ingredientsTag.add((Object)ingredientTag);
        }
        if (!ingredientsTag.isEmpty()) {
            tag.m_128365_("Ingredients", (Tag)ingredientsTag);
        }
        if (!this.inventory.getStackInSlot(this.ingredientSize).m_41619_()) {
            tag.m_128365_("Result", (Tag)this.inventory.getStackInSlot(this.ingredientSize).serializeNBT());
        }
        if (!this.container.m_41619_()) {
            tag.m_128365_("Container", (Tag)this.container.serializeNBT());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        int i;
        ListTag ingredientsTag = tag.m_128437_("Ingredients", 10);
        for (i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
        for (i = 0; i < ingredientsTag.size(); ++i) {
            CompoundTag ingredientTag = ingredientsTag.m_128728_(i);
            int slot = ingredientTag.m_128445_("Slot") & 0xFF;
            if (slot >= this.ingredientSize) continue;
            this.inventory.setStackInSlot(slot, ItemStack.m_41712_((CompoundTag)ingredientTag));
        }
        this.inventory.setStackInSlot(this.ingredientSize, tag.m_128425_("Result", 10) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("Result")) : ItemStack.f_41583_);
        this.container = tag.m_128425_("Container", 10) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("Container")) : ItemStack.f_41583_;
    }

    public final int getIngredientSize() {
        return this.ingredientSize;
    }

    public boolean needIngredient(int slot) {
        return !this.inventory.getStackInSlot(slot).m_41619_();
    }

    public boolean isIngredient(int slot, ItemStack stack) {
        return stack.m_41656_(this.inventory.getStackInSlot(slot));
    }

    public boolean isContainer(ItemStack stack) {
        return stack.m_41656_(this.container);
    }

    public ItemStack getResult() {
        return this.inventory.getStackInSlot(this.ingredientSize).m_41777_();
    }

    public ItemStack getOwner() {
        return this.owner;
    }

    public abstract void updateRecipe(Level var1);
}

