/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.mixin.common.farmersrespite;

import com.simibubi.create.content.contraptions.components.actors.HarvesterMovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.BlockHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import umpaz.farmersrespite.common.block.CoffeeDoubleStemBlock;
import umpaz.farmersrespite.common.block.CoffeeMiddleStemBlock;
import umpaz.farmersrespite.common.block.CoffeeStemBlock;
import umpaz.farmersrespite.common.block.TeaBushBlock;
import umpaz.farmersrespite.common.registry.FRBlocks;
import umpaz.farmersrespite.common.registry.FRItems;

@Mixin(value={HarvesterMovementBehaviour.class}, remap=false)
public abstract class HarvesterMovementBehaviorMixin
implements MovementBehaviour {
    @Inject(method={"visitNewPosition"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/contraptions/components/actors/HarvesterMovementBehaviour;isValidCrop(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z")}, cancellable=true)
    private void farmersrespite$visitNewPosition(MovementContext context, BlockPos pos, CallbackInfo ci) {
        Level level = context.world;
        BlockState state = level.m_8055_(pos);
        boolean harvestPartial = (Boolean)AllConfigs.SERVER.kinetics.harvestPartiallyGrown.get();
        boolean replant = (Boolean)AllConfigs.SERVER.kinetics.harvesterReplants.get();
        boolean handled = true;
        if (state.m_60734_() instanceof TeaBushBlock) {
            this.farmersrespite$handleTeaBush(context, pos, state, replant);
        } else if (state.m_60734_() instanceof CoffeeStemBlock) {
            this.farmersrespite$handleCoffeeStem(context, pos, state, replant);
        } else if (state.m_60734_() instanceof CoffeeMiddleStemBlock) {
            if (replant) {
                this.farmersrespite$handleCoffeeStem(context, pos, state, true);
            } else {
                BlockPos posBelow = pos.m_7495_();
                BlockState stateBelow = level.m_8055_(posBelow);
                if (stateBelow.m_60734_() instanceof CoffeeDoubleStemBlock) {
                    this.farmersrespite$destroyCoffeeStems(context, posBelow, stateBelow, pos, state, harvestPartial);
                }
            }
        } else if (state.m_60734_() instanceof CoffeeDoubleStemBlock) {
            if (replant) {
                this.farmersrespite$replantCoffeeDoubleStem(context, pos, state);
            } else {
                BlockPos posAbove = pos.m_7494_();
                BlockState stateAbove = level.m_8055_(posAbove);
                if (stateAbove.m_60734_() instanceof CoffeeMiddleStemBlock) {
                    this.farmersrespite$destroyCoffeeStems(context, pos, state, posAbove, stateAbove, harvestPartial);
                }
            }
        } else {
            handled = false;
        }
        if (handled) {
            ci.cancel();
        }
    }

    private void farmersrespite$handleTeaBush(MovementContext context, BlockPos pos, BlockState state, boolean replant) {
        Level level = context.world;
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)TeaBushBlock.HALF);
        if (replant && half == DoubleBlockHalf.UPPER) {
            switch ((Integer)state.m_61143_((Property)TeaBushBlock.AGE)) {
                case 0: {
                    this.dropItem(context, new ItemStack((ItemLike)FRItems.GREEN_TEA_LEAVES.get(), 2 + level.f_46441_.m_188503_(2)));
                    break;
                }
                case 1: {
                    this.dropItem(context, new ItemStack((ItemLike)FRItems.YELLOW_TEA_LEAVES.get(), 2 + level.f_46441_.m_188503_(2)));
                    break;
                }
                case 2: {
                    this.dropItem(context, new ItemStack((ItemLike)FRItems.YELLOW_TEA_LEAVES.get(), 1 + level.f_46441_.m_188503_(2)));
                    this.dropItem(context, new ItemStack((ItemLike)FRItems.BLACK_TEA_LEAVES.get(), 1 + level.f_46441_.m_188503_(2)));
                    break;
                }
                case 3: {
                    this.dropItem(context, new ItemStack((ItemLike)FRItems.BLACK_TEA_LEAVES.get(), 2 + level.f_46441_.m_188503_(2)));
                }
            }
            this.dropItem(context, new ItemStack((ItemLike)Items.f_42398_, 2 + level.f_46441_.m_188503_(2)));
            level.m_46597_(pos.m_7495_(), ((Block)FRBlocks.SMALL_TEA_BUSH.get()).m_49966_());
        } else {
            BlockPos destroyPos = half == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos;
            BlockHelper.destroyBlockAs((Level)level, (BlockPos)destroyPos, null, (ItemStack)ItemStack.f_41583_, (float)1.0f, stack -> this.dropItem(context, (ItemStack)stack));
        }
    }

    private void farmersrespite$handleCoffeeStem(MovementContext context, BlockPos pos, BlockState state, boolean replant) {
        if ((Integer)state.m_61143_((Property)BlockStateProperties.f_61406_) < 2) {
            return;
        }
        Level level = context.world;
        if (replant) {
            this.dropItem(context, new ItemStack((ItemLike)FRItems.COFFEE_BERRIES.get(), 1));
            level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61406_, (Comparable)Integer.valueOf(0)), 2);
        } else {
            BlockHelper.destroyBlockAs((Level)level, (BlockPos)pos, null, (ItemStack)ItemStack.f_41583_, (float)1.0f, stack -> this.dropItem(context, (ItemStack)stack));
        }
    }

    private void farmersrespite$replantCoffeeDoubleStem(MovementContext context, BlockPos pos, BlockState state) {
        int flag0 = 0;
        int flag1 = 0;
        if ((Integer)state.m_61143_((Property)CoffeeDoubleStemBlock.AGE) == 2) {
            flag0 = 1;
        }
        if ((Integer)state.m_61143_((Property)CoffeeDoubleStemBlock.AGE1) == 2) {
            flag1 = 1;
        }
        if (flag0 + flag1 == 0) {
            return;
        }
        Level level = context.world;
        this.dropItem(context, new ItemStack((ItemLike)FRItems.COFFEE_BERRIES.get(), flag0 + flag1));
        if (flag0 == 1) {
            state = (BlockState)state.m_61124_((Property)CoffeeDoubleStemBlock.AGE, (Comparable)Integer.valueOf(0));
        }
        if (flag1 == 1) {
            state = (BlockState)state.m_61124_((Property)CoffeeDoubleStemBlock.AGE1, (Comparable)Integer.valueOf(0));
        }
        level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
        level.m_7731_(pos, state, 2);
    }

    private void farmersrespite$destroyCoffeeStems(MovementContext context, BlockPos rootPos, BlockState rootState, BlockPos middlePos, BlockState middleState, boolean harvestPartial) {
        Level level = context.world;
        int rootAge0 = (Integer)rootState.m_61143_((Property)CoffeeDoubleStemBlock.AGE);
        int rootAge1 = (Integer)rootState.m_61143_((Property)CoffeeDoubleStemBlock.AGE1);
        int middleAge = (Integer)middleState.m_61143_((Property)CoffeeMiddleStemBlock.AGE);
        if (harvestPartial ? rootAge0 < 2 && rootAge1 < 2 && middleAge < 2 : rootAge0 < 2 || rootAge1 < 2 || middleAge < 2) {
            return;
        }
        BlockHelper.destroyBlockAs((Level)level, (BlockPos)middlePos, null, (ItemStack)ItemStack.f_41583_, (float)1.0f, stack -> this.dropItem(context, (ItemStack)stack));
        BlockHelper.destroyBlockAs((Level)level, (BlockPos)rootPos, null, (ItemStack)ItemStack.f_41583_, (float)1.0f, stack -> this.dropItem(context, (ItemStack)stack));
    }
}

