/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.core.ponder;

import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderStoryBoardEntry;
import com.simibubi.create.foundation.ponder.PonderTag;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.Validate;
import plus.dragons.createcentralkitchen.core.ponder.PonderDeferredRegister;

public final class PonderRegistryObject {
    private final PonderDeferredRegister owner;
    private final ResourceLocation schematic;
    private final PonderStoryBoardEntry.PonderStoryBoard storyBoard;
    private final List<ResourceLocation> components = new ArrayList<ResourceLocation>();
    private final List<PonderTag> tags = new ArrayList<PonderTag>();

    public PonderRegistryObject(PonderDeferredRegister owner, ResourceLocation schematic, PonderStoryBoardEntry.PonderStoryBoard storyBoard) {
        this.owner = owner;
        this.schematic = schematic;
        this.storyBoard = storyBoard;
    }

    public void register() {
        for (ResourceLocation component : this.components) {
            PonderStoryBoardEntry entry = new PonderStoryBoardEntry(this.storyBoard, this.owner.namespace, this.schematic, component);
            entry.highlightTags((PonderTag[])this.tags.toArray(PonderTag[]::new));
            PonderRegistry.addStoryBoard((PonderStoryBoardEntry)entry);
        }
    }

    public PonderRegistryObject addComponent(ResourceLocation ... components) {
        Validate.isTrue((!this.owner.registered ? 1 : 0) != 0, (String)"Cannot assign new components to registered PonderRegistryObject", (Object[])new Object[0]);
        Collections.addAll(this.components, components);
        return this;
    }

    @SafeVarargs
    public final PonderRegistryObject addComponent(RegistryObject<? extends Item> ... components) {
        Validate.isTrue((!this.owner.registered ? 1 : 0) != 0, (String)"Cannot assign new components to registered PonderRegistryObject", (Object[])new Object[0]);
        Arrays.stream(components).map(RegistryObject::getId).forEach(this.components::add);
        return this;
    }

    public PonderRegistryObject addComponent(ItemProviderEntry<?> ... components) {
        Validate.isTrue((!this.owner.registered ? 1 : 0) != 0, (String)"Cannot assign new components to registered PonderRegistryObject", (Object[])new Object[0]);
        Arrays.stream(components).map(RegistryEntry::getId).forEach(this.components::add);
        return this;
    }

    public PonderRegistryObject addTag(PonderTag ... tags) {
        Validate.isTrue((!this.owner.registered ? 1 : 0) != 0, (String)"Cannot assign new tags to registered PonderRegistryObject", (Object[])new Object[0]);
        Collections.addAll(this.tags, tags);
        return this;
    }
}

