/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.core.modules;

import com.mojang.logging.LogUtils;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.ModLoadingStage;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import plus.dragons.createcentralkitchen.core.modules.ModModule;

public class ModModuleLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Type MOD_MODULE = Type.getType(ModModule.class);

    public static void loadModules() {
        ModContainer modContainer = ModLoadingContext.get().getActiveContainer();
        if (modContainer.getCurrentState() != ModLoadingStage.CONSTRUCT) {
            LOGGER.error("ModModuleLoader.loadModules() should be called in mod's constructor");
            return;
        }
        String modid = modContainer.getModId();
        modContainer.getModInfo().getOwningFile().getFile().getScanResult().getAnnotations().stream().filter(data -> data.targetType() == ElementType.TYPE && data.annotationType().equals((Object)MOD_MODULE)).map(data -> new ModModuleData(modid, (String)data.annotationData().get("id"), data.annotationData().getOrDefault("dependencies", new ArrayList()), data.annotationData().getOrDefault("priority", 0), data.clazz().getClassName())).filter(ModModuleData::enabled).sorted().forEach(ModModuleData::load);
    }

    private record ModModuleData(String modId, String moduleId, List<String> dependencies, int priority, String mainClass) implements Comparable<ModModuleData>
    {
        public boolean enabled() {
            ModList modList = ModList.get();
            for (String modid : this.dependencies) {
                if (modList.isLoaded(modid)) continue;
                return false;
            }
            return true;
        }

        public void load() {
            try {
                Class.forName(this.mainClass).getConstructor(new Class[0]).newInstance(new Object[0]);
                LOGGER.info("Successfully loaded module [%s] for mod [%s]".formatted(this.moduleId, this.modId));
            }
            catch (Throwable t) {
                LOGGER.error("Failed to load module [%s] for mod [%s]".formatted(this.moduleId, this.modId), t);
            }
        }

        @Override
        public int compareTo(@NotNull ModModuleData other) {
            if (this.priority != other.priority) {
                return Integer.compare(this.priority, other.priority);
            }
            return this.moduleId.compareTo(other.moduleId);
        }
    }
}

