/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.core.integration.jei;

import com.simibubi.create.compat.jei.CreateJEI;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.CRecipes;
import com.simibubi.create.foundation.config.ConfigBase;
import com.simibubi.create.foundation.utility.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import plus.dragons.createcentralkitchen.CentralKitchen;

public class RecipeCategoryBuilder<T extends Recipe<?>> {
    private final String modid;
    private final Class<? extends T> recipeClass;
    private Predicate<CRecipes> predicate = cRecipes -> true;
    private IDrawable background;
    private IDrawable icon;
    private final List<Consumer<List<T>>> recipeListConsumers = new ArrayList<Consumer<List<T>>>();
    private final List<Supplier<? extends ItemStack>> catalysts = new ArrayList<Supplier<? extends ItemStack>>();

    public RecipeCategoryBuilder(String modid, Class<? extends T> recipeClass) {
        this.modid = modid;
        this.recipeClass = recipeClass;
    }

    public RecipeCategoryBuilder<T> enableIf(Predicate<CRecipes> predicate) {
        this.predicate = predicate;
        return this;
    }

    public RecipeCategoryBuilder<T> enableWhen(Function<CRecipes, ConfigBase.ConfigBool> configValue) {
        this.predicate = c -> (Boolean)((ConfigBase.ConfigBool)configValue.apply((CRecipes)c)).get();
        return this;
    }

    public RecipeCategoryBuilder<T> addRecipeListConsumer(Consumer<List<T>> consumer) {
        this.recipeListConsumers.add(consumer);
        return this;
    }

    public RecipeCategoryBuilder<T> addRecipes(Supplier<Collection<? extends T>> collection) {
        return this.addRecipeListConsumer(recipes -> recipes.addAll((Collection)collection.get()));
    }

    public RecipeCategoryBuilder<T> addAllRecipesIf(Predicate<Recipe<?>> pred) {
        return this.addRecipeListConsumer(recipes -> CreateJEI.consumeAllRecipes(recipe -> {
            if (pred.test((Recipe<?>)recipe)) {
                recipes.add(recipe);
            }
        }));
    }

    public RecipeCategoryBuilder<T> addAllRecipesIf(Predicate<Recipe<?>> pred, Function<Recipe<?>, T> converter) {
        return this.addRecipeListConsumer(recipes -> CreateJEI.consumeAllRecipes(recipe -> {
            if (pred.test((Recipe<?>)recipe)) {
                recipes.add((Recipe)converter.apply((Recipe<?>)recipe));
            }
        }));
    }

    public <O extends Recipe<?>> RecipeCategoryBuilder<T> addTransformedRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<O>> recipeType, Function<O, T> converter) {
        return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipe -> recipes.add((Recipe)converter.apply(recipe)), (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
    }

    public RecipeCategoryBuilder<T> addTypedRecipes(IRecipeTypeInfo recipeTypeEntry) {
        return this.addTypedRecipes(() -> ((IRecipeTypeInfo)recipeTypeEntry).getType());
    }

    public RecipeCategoryBuilder<T> addTypedRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType) {
        return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipes::add, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
    }

    public RecipeCategoryBuilder<T> addTypedRecipesIf(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Predicate<Recipe<?>> pred) {
        return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipe -> {
            if (pred.test((Recipe<?>)recipe)) {
                recipes.add(recipe);
            }
        }, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
    }

    public RecipeCategoryBuilder<T> addTypedRecipesExcluding(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> excluded) {
        return this.addRecipeListConsumer(recipes -> {
            List excludedRecipes = CreateJEI.getTypedRecipes((net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)excluded.get()));
            CreateJEI.consumeTypedRecipes(recipe -> {
                for (Recipe excludedRecipe : excludedRecipes) {
                    if (!CreateJEI.doInputsMatch((Recipe)recipe, (Recipe)excludedRecipe)) continue;
                    return;
                }
                recipes.add(recipe);
            }, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get()));
        });
    }

    public RecipeCategoryBuilder<T> removeRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType) {
        return this.addRecipeListConsumer(recipes -> {
            List excludedRecipes = CreateJEI.getTypedRecipes((net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get()));
            recipes.removeIf(recipe -> {
                for (Recipe excludedRecipe : excludedRecipes) {
                    if (!CreateJEI.doInputsMatch((Recipe)recipe, (Recipe)excludedRecipe)) continue;
                    return true;
                }
                return false;
            });
        });
    }

    public RecipeCategoryBuilder<T> catalystStack(Supplier<ItemStack> supplier) {
        this.catalysts.add(supplier);
        return this;
    }

    public RecipeCategoryBuilder<T> catalyst(Supplier<ItemLike> supplier) {
        return this.catalystStack(() -> new ItemStack((ItemLike)((ItemLike)supplier.get()).m_5456_()));
    }

    public RecipeCategoryBuilder<T> icon(IDrawable icon) {
        this.icon = icon;
        return this;
    }

    public RecipeCategoryBuilder<T> itemIcon(ItemLike item) {
        this.icon((IDrawable)new ItemIcon(() -> new ItemStack(item)));
        return this;
    }

    public RecipeCategoryBuilder<T> doubleItemIcon(ItemLike item1, ItemLike item2) {
        this.icon((IDrawable)new DoubleItemIcon(() -> new ItemStack(item1), () -> new ItemStack(item2)));
        return this;
    }

    public RecipeCategoryBuilder<T> background(IDrawable background) {
        this.background = background;
        return this;
    }

    public RecipeCategoryBuilder<T> emptyBackground(int width, int height) {
        this.background((IDrawable)new EmptyBackground(width, height));
        return this;
    }

    public CreateRecipeCategory<T> build(String name, CreateRecipeCategory.Factory<T> factory) {
        Supplier<List> recipesSupplier = this.predicate.test(AllConfigs.SERVER.recipes) ? () -> {
            ArrayList recipes = new ArrayList();
            for (Consumer consumer : this.recipeListConsumers) {
                consumer.accept(recipes);
            }
            return recipes;
        } : Collections::emptyList;
        ResourceLocation id = new ResourceLocation(this.modid, name);
        CreateRecipeCategory.Info info = new CreateRecipeCategory.Info(new RecipeType(id, this.recipeClass), (Component)CentralKitchen.LANG.fromRL("recipe", id, new Object[0]).component(), this.background, this.icon, recipesSupplier, this.catalysts);
        return factory.create(info);
    }
}

