/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.entropy;

import appeng.recipes.entropy.EntropyMode;
import appeng.recipes.entropy.EntropyRecipe;
import appeng.recipes.entropy.EntropyRecipeBuilder;
import appeng.recipes.entropy.MultipleValuesMatcher;
import appeng.recipes.entropy.RangeValueMatcher;
import appeng.recipes.entropy.SingleValueMatcher;
import appeng.recipes.entropy.StateApplier;
import appeng.recipes.entropy.StateMatcher;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class EntropyRecipeSerializer
implements RecipeSerializer<EntropyRecipe> {
    public static final EntropyRecipeSerializer INSTANCE = new EntropyRecipeSerializer();

    private EntropyRecipeSerializer() {
    }

    public EntropyRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        JsonObject outputFluidObject;
        String outputFluidId;
        JsonObject outputJson;
        JsonObject outputBlockObject;
        String outputBlockId;
        JsonObject inputFluidObject;
        String inputFluidId;
        EntropyRecipeBuilder builder = new EntropyRecipeBuilder();
        builder.setId(recipeId);
        builder.setMode(EntropyMode.valueOf(GsonHelper.m_13906_((JsonObject)json, (String)"mode").toUpperCase(Locale.ROOT)));
        JsonObject inputJson = GsonHelper.m_13930_((JsonObject)json, (String)"input");
        JsonObject inputBlockObject = GsonHelper.m_13841_((JsonObject)inputJson, (String)"block", (JsonObject)new JsonObject());
        String inputBlockId = GsonHelper.m_13851_((JsonObject)inputBlockObject, (String)"id", null);
        if (inputBlockId != null) {
            Block block = (Block)EntropyRecipeSerializer.getRequiredEntry(ForgeRegistries.BLOCKS, inputBlockId);
            builder.setInputBlock(block);
            EntropyRecipeSerializer.parseStateMatchers(block.m_49965_(), inputBlockObject, builder::addBlockStateMatcher);
        }
        if ((inputFluidId = GsonHelper.m_13851_((JsonObject)(inputFluidObject = GsonHelper.m_13841_((JsonObject)inputJson, (String)"fluid", (JsonObject)new JsonObject())), (String)"id", null)) != null) {
            Fluid fluid = (Fluid)EntropyRecipeSerializer.getRequiredEntry(ForgeRegistries.FLUIDS, inputFluidId);
            builder.setInputFluid(fluid);
            EntropyRecipeSerializer.parseStateMatchers(fluid.m_76144_(), inputFluidObject, builder::addFluidStateMatcher);
        }
        if ((outputBlockId = GsonHelper.m_13851_((JsonObject)(outputBlockObject = GsonHelper.m_13841_((JsonObject)(outputJson = GsonHelper.m_13930_((JsonObject)json, (String)"output")), (String)"block", (JsonObject)new JsonObject())), (String)"id", null)) != null) {
            Block block = (Block)EntropyRecipeSerializer.getRequiredEntry(ForgeRegistries.BLOCKS, outputBlockId);
            builder.setOutputBlock(block);
            boolean outputBlockKeep = GsonHelper.m_13855_((JsonObject)outputBlockObject, (String)"keep", (boolean)false);
            builder.setOutputBlockKeep(outputBlockKeep);
            EntropyRecipeSerializer.parseStateAppliers(block.m_49965_(), outputBlockObject, builder::addBlockStateAppliers);
        }
        if ((outputFluidId = GsonHelper.m_13851_((JsonObject)(outputFluidObject = GsonHelper.m_13841_((JsonObject)outputJson, (String)"fluid", (JsonObject)new JsonObject())), (String)"id", null)) != null) {
            Fluid fluid = (Fluid)EntropyRecipeSerializer.getRequiredEntry(ForgeRegistries.FLUIDS, outputFluidId);
            builder.setOutputFluid(fluid);
            boolean outputFluidKeep = GsonHelper.m_13855_((JsonObject)outputFluidObject, (String)"keep", (boolean)false);
            builder.setOutputFluidKeep(outputFluidKeep);
            EntropyRecipeSerializer.parseStateAppliers(fluid.m_76144_(), outputFluidObject, builder::addFluidStateAppliers);
        }
        if (outputJson.has("drops")) {
            JsonArray dropList = GsonHelper.m_13933_((JsonObject)outputJson, (String)"drops");
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>(dropList.size());
            for (JsonElement jsonElement : dropList) {
                JsonObject object = jsonElement.getAsJsonObject();
                String itemid = GsonHelper.m_13906_((JsonObject)object, (String)"item");
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemid));
                int count = GsonHelper.m_13824_((JsonObject)object, (String)"count", (int)1);
                drops.add(new ItemStack((ItemLike)item, count));
            }
            builder.setDrops(drops);
        }
        return builder.build();
    }

    private static <T> T getRequiredEntry(IForgeRegistry<T> registry, String id) {
        Object entry = registry.getValue(new ResourceLocation(id));
        if (entry == null) {
            throw new IllegalArgumentException("Unknown id " + id + " for " + registry.getRegistryName());
        }
        return (T)entry;
    }

    @Nullable
    public EntropyRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int dropSize;
        int appliersSize;
        Fluid fluid;
        int i;
        int matcherSize;
        EntropyRecipeBuilder builder = new EntropyRecipeBuilder();
        builder.setId(recipeId);
        builder.setMode((EntropyMode)buffer.m_130066_(EntropyMode.class));
        if (buffer.readBoolean()) {
            Block inputBlock = (Block)buffer.readRegistryIdUnsafe(ForgeRegistries.BLOCKS);
            builder.setInputBlock(inputBlock);
            matcherSize = buffer.readInt();
            for (i = 0; i < matcherSize; ++i) {
                builder.addBlockStateMatcher(StateMatcher.read(inputBlock.m_49965_(), buffer));
            }
        }
        if (buffer.readBoolean()) {
            fluid = (Fluid)buffer.readRegistryIdUnsafe(ForgeRegistries.FLUIDS);
            builder.setInputFluid(fluid);
            matcherSize = buffer.readInt();
            for (i = 0; i < matcherSize; ++i) {
                builder.addFluidStateMatcher(StateMatcher.read(fluid.m_76144_(), buffer));
            }
        }
        if (buffer.readBoolean()) {
            Block block = (Block)buffer.readRegistryIdUnsafe(ForgeRegistries.BLOCKS);
            builder.setOutputBlock(block);
            builder.setOutputBlockKeep(buffer.readBoolean());
            appliersSize = buffer.readInt();
            for (i = 0; i < appliersSize; ++i) {
                builder.addBlockStateAppliers(StateApplier.readFromPacket(block.m_49965_(), buffer));
            }
        }
        if (buffer.readBoolean()) {
            fluid = (Fluid)buffer.readRegistryIdUnsafe(ForgeRegistries.FLUIDS);
            builder.setOutputFluid(fluid);
            builder.setOutputFluidKeep(buffer.readBoolean());
            appliersSize = buffer.readInt();
            for (i = 0; i < appliersSize; ++i) {
                builder.addFluidStateAppliers(StateApplier.readFromPacket(fluid.m_76144_(), buffer));
            }
        }
        if ((dropSize = buffer.readInt()) > 0) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>(dropSize);
            for (i = 0; i < dropSize; ++i) {
                drops.add(buffer.m_130267_());
            }
            builder.setDrops(drops);
        }
        return builder.build();
    }

    public void toNetwork(FriendlyByteBuf buffer, EntropyRecipe recipe) {
        List<StateApplier<?>> appliers;
        buffer.m_130068_((Enum)recipe.getMode());
        buffer.writeBoolean(recipe.getInputBlock() != null);
        if (recipe.getInputBlock() != null) {
            buffer.writeRegistryIdUnsafe(ForgeRegistries.BLOCKS, (Object)recipe.getInputBlock());
            List<StateMatcher> inputBlockMatchers = recipe.getInputBlockMatchers();
            buffer.writeInt(inputBlockMatchers.size());
            for (StateMatcher stateMatcher : inputBlockMatchers) {
                stateMatcher.writeToPacket(buffer);
            }
        }
        buffer.writeBoolean(recipe.getInputFluid() != null);
        if (recipe.getInputFluid() != null) {
            buffer.writeRegistryIdUnsafe(ForgeRegistries.FLUIDS, (Object)recipe.getInputFluid());
            List<StateMatcher> inputFluidMatchers = recipe.getInputFluidMatchers();
            buffer.writeInt(inputFluidMatchers.size());
            for (StateMatcher stateMatcher : inputFluidMatchers) {
                stateMatcher.writeToPacket(buffer);
            }
        }
        buffer.writeBoolean(recipe.getOutputBlock() != null);
        if (recipe.getOutputBlock() != null) {
            buffer.writeRegistryIdUnsafe(ForgeRegistries.BLOCKS, (Object)recipe.getOutputBlock());
            buffer.writeBoolean(recipe.getOutputBlockKeep());
            appliers = recipe.getOutputBlockStateAppliers();
            buffer.writeInt(appliers.size());
            for (StateApplier stateApplier : appliers) {
                stateApplier.writeToPacket(buffer);
            }
        }
        buffer.writeBoolean(recipe.getOutputFluid() != null);
        if (recipe.getOutputFluid() != null) {
            buffer.writeRegistryIdUnsafe(ForgeRegistries.FLUIDS, (Object)recipe.getOutputFluid());
            buffer.writeBoolean(recipe.getOutputFluidKeep());
            appliers = recipe.getOutputFluidStateAppliers();
            buffer.writeInt(appliers.size());
            for (StateApplier stateApplier : appliers) {
                stateApplier.writeToPacket(buffer);
            }
        }
        buffer.writeInt(recipe.getDrops().size());
        for (ItemStack itemStack : recipe.getDrops()) {
            buffer.m_130055_(itemStack);
        }
    }

    private static void parseStateMatchers(StateDefinition<?, ?> stateDefinition, JsonObject propertiesContainer, Consumer<StateMatcher> consumer) {
        JsonObject properties = GsonHelper.m_13841_((JsonObject)propertiesContainer, (String)"properties", (JsonObject)new JsonObject());
        properties.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (value == null) {
                return;
            }
            if (value.isJsonPrimitive()) {
                consumer.accept(SingleValueMatcher.create(stateDefinition, key, value.getAsString()));
            } else if (value.isJsonArray()) {
                JsonArray array = value.getAsJsonArray();
                ArrayList<String> list = new ArrayList<String>();
                for (JsonElement e : array) {
                    list.add(e.getAsString());
                }
                consumer.accept(MultipleValuesMatcher.create(stateDefinition, key, list));
            } else if (value.isJsonObject() && value.getAsJsonObject().has("min") && value.getAsJsonObject().has("max")) {
                String min = value.getAsJsonObject().get("min").getAsString();
                String max = value.getAsJsonObject().get("max").getAsString();
                consumer.accept(RangeValueMatcher.create(stateDefinition, key, min, max));
            } else {
                throw new IllegalArgumentException("Invalid matcher: " + value);
            }
        });
    }

    private static void parseStateAppliers(StateDefinition<?, ?> stateDefinition, JsonObject propertiesContainer, Consumer<StateApplier<?>> consumer) {
        JsonObject properties = GsonHelper.m_13841_((JsonObject)propertiesContainer, (String)"properties", (JsonObject)new JsonObject());
        properties.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            consumer.accept(StateApplier.create(stateDefinition, key, value));
        });
    }

    public void toJson(EntropyRecipe recipe, JsonObject json) {
        json.addProperty("mode", recipe.getMode().name().toLowerCase(Locale.ROOT));
        json.add("input", (JsonElement)this.serializeInput(recipe));
        json.add("output", this.serializeOutput(recipe));
    }

    private JsonObject serializeInput(EntropyRecipe recipe) {
        JsonObject input = new JsonObject();
        if (recipe.getInputBlock() != null) {
            JsonObject jsonBlock = new JsonObject();
            jsonBlock.addProperty("id", Registry.f_122824_.m_7981_((Object)recipe.getInputBlock()).toString());
            this.serializeStateMatchers(recipe.getInputBlockMatchers(), jsonBlock);
            input.add("block", (JsonElement)jsonBlock);
        }
        if (recipe.getInputFluid() != null) {
            JsonObject jsonFluid = new JsonObject();
            jsonFluid.addProperty("id", Registry.f_122822_.m_7981_((Object)recipe.getInputFluid()).toString());
            this.serializeStateMatchers(recipe.getInputFluidMatchers(), jsonFluid);
            input.add("fluid", (JsonElement)jsonFluid);
        }
        return input;
    }

    private JsonElement serializeOutput(EntropyRecipe recipe) {
        JsonObject output = new JsonObject();
        if (recipe.getOutputBlock() != null) {
            JsonObject jsonBlock = new JsonObject();
            jsonBlock.addProperty("id", Registry.f_122824_.m_7981_((Object)recipe.getOutputBlock()).toString());
            if (recipe.getOutputBlockKeep()) {
                jsonBlock.addProperty("keep", Boolean.valueOf(true));
            }
            this.serializeStateAppliers(recipe.getOutputBlockStateAppliers(), jsonBlock);
            output.add("block", (JsonElement)jsonBlock);
        }
        if (recipe.getOutputFluid() != null) {
            JsonObject jsonFluid = new JsonObject();
            jsonFluid.addProperty("id", Registry.f_122822_.m_7981_((Object)recipe.getOutputFluid()).toString());
            if (recipe.getOutputFluidKeep()) {
                jsonFluid.addProperty("keep", Boolean.valueOf(true));
            }
            this.serializeStateAppliers(recipe.getOutputFluidStateAppliers(), jsonFluid);
            output.add("fluid", (JsonElement)jsonFluid);
        }
        if (!recipe.getDrops().isEmpty()) {
            JsonArray jsonDrops = new JsonArray();
            for (ItemStack drop : recipe.getDrops()) {
                JsonObject jsonDrop = new JsonObject();
                jsonDrop.addProperty("item", Registry.f_122827_.m_7981_((Object)drop.m_41720_()).toString());
                if (drop.m_41613_() > 1) {
                    jsonDrop.addProperty("count", (Number)drop.m_41613_());
                }
                jsonDrops.add((JsonElement)jsonDrop);
            }
            output.add("drops", (JsonElement)jsonDrops);
        }
        return output;
    }

    private void serializeStateMatchers(List<StateMatcher> matchers, JsonObject json) {
        if (matchers.isEmpty()) {
            return;
        }
        JsonObject properties = new JsonObject();
        for (StateMatcher matcher : matchers) {
            JsonPrimitive serializedMatcher;
            if (matcher instanceof SingleValueMatcher) {
                SingleValueMatcher singleMatcher = (SingleValueMatcher)matcher;
                serializedMatcher = new JsonPrimitive(singleMatcher.getValueName());
            } else if (matcher instanceof MultipleValuesMatcher) {
                MultipleValuesMatcher multiMatcher = (MultipleValuesMatcher)matcher;
                JsonArray values = new JsonArray();
                for (String valueName : multiMatcher.getValueNames()) {
                    values.add(valueName);
                }
                serializedMatcher = values;
            } else if (matcher instanceof RangeValueMatcher) {
                RangeValueMatcher rangeMatcher = (RangeValueMatcher)matcher;
                JsonObject range = new JsonObject();
                range.addProperty("min", rangeMatcher.getMinValueName());
                range.addProperty("max", rangeMatcher.getMaxValueName());
                serializedMatcher = range;
            } else {
                throw new IllegalStateException("Don't know how to serialize state matcher " + matcher);
            }
            String propertyName = matcher.getProperty().m_61708_();
            properties.add(propertyName, (JsonElement)serializedMatcher);
        }
        json.add("properties", (JsonElement)properties);
    }

    private void serializeStateAppliers(List<StateApplier<?>> appliers, JsonObject json) {
        if (appliers.isEmpty()) {
            return;
        }
        JsonObject properties = new JsonObject();
        for (StateApplier<?> applier : appliers) {
            Property<?> property = applier.getProperty();
            properties.addProperty(property.m_61708_(), applier.getValueName());
        }
        json.add("properties", (JsonElement)properties);
    }
}

