/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.workbench;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.misc.SlotContainer;
import com.yogpc.qp.machines.workbench.TileWorkbench;
import com.yogpc.qp.machines.workbench.WorkbenchRecipe;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerWorkbench
extends AbstractContainerMenu {
    final TileWorkbench tile;
    private static final int sourceSlot = 27;
    private static final int recipeSlot = 18;
    private static final int playerSlot = 36;
    final DataSlot progress = this.m_38895_(DataSlot.m_39401_());
    final DataSlot isWorking = this.m_38895_(DataSlot.m_39401_());
    final DataSlot workContinue = this.m_38895_(DataSlot.m_39401_());
    final DataSlot recipeIndex = this.m_38895_(DataSlot.m_39401_());

    public ContainerWorkbench(int id, Player player, BlockPos pos) {
        super(Holder.WORKBENCH_MENU_TYPE, id);
        int col;
        int row;
        this.tile = Objects.requireNonNull((TileWorkbench)player.f_19853_.m_7702_(pos));
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new SlotContainer(this.tile, col + row * 9, 8 + col * 18, 18 + row * 18));
            }
        }
        for (row = 0; row < 2; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new SlotContainer(this.tile, col + row * 9 + 27, 8 + col * 18, 90 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)player.m_150109_(), col + row * 9 + 9, 8 + col * 18, 140 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)player.m_150109_(), col, 8 + col * 18, 198));
        }
        if (!player.f_19853_.f_46443_) {
            this.setTrackValues();
            this.tile.m_5856_(player);
        }
    }

    private void setTrackValues() {
        this.progress.m_6422_(this.tile.getProgressScaled(160));
        this.isWorking.m_6422_(this.tile.getRecipe().hasContent() ? 1 : 0);
        this.workContinue.m_6422_(this.tile.workContinue ? 1 : 0);
        this.recipeIndex.m_6422_(this.tile.recipesList.indexOf(this.tile.getRecipe()));
    }

    public boolean m_6875_(Player playerIn) {
        return this.tile.m_6542_(playerIn);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        if (27 <= index && index < 45) {
            return ItemStack.f_41583_;
        }
        ItemStack src = ItemStack.f_41583_;
        Slot slot = this.m_38853_(index);
        if (slot.m_6657_()) {
            ItemStack remain = slot.m_7993_();
            src = remain.m_41777_();
            if (index < 27) {
                if (src.m_41753_()) {
                    if (!this.m_38903_(remain, 45, 81, true)) {
                        return ItemStack.f_41583_;
                    }
                } else {
                    for (int i = 80; i >= 45 && !remain.m_41619_(); --i) {
                        int maxSize;
                        Slot destinationSlot = this.m_38853_(i);
                        if (!destinationSlot.m_6657_()) {
                            int maxSize2 = Math.min(slot.m_6641_(), remain.m_41741_());
                            destinationSlot.m_5852_(remain.m_41620_(maxSize2));
                            continue;
                        }
                        ItemStack dest = destinationSlot.m_7993_();
                        if (!ItemStack.m_150942_((ItemStack)dest, (ItemStack)remain)) continue;
                        int newSize = dest.m_41613_() + remain.m_41613_();
                        if (newSize <= (maxSize = Math.min(slot.m_6641_(), remain.m_41741_()))) {
                            remain.m_41764_(0);
                            dest.m_41764_(newSize);
                            slot.m_6654_();
                            continue;
                        }
                        if (dest.m_41613_() >= maxSize) continue;
                        remain.m_41774_(maxSize - dest.m_41613_());
                        dest.m_41764_(maxSize);
                        slot.m_6654_();
                    }
                    if (!remain.m_41619_()) {
                        slot.m_6654_();
                        return ItemStack.f_41583_;
                    }
                }
            } else if (!this.n_moveItemStackTo(remain)) {
                return ItemStack.f_41583_;
            }
            if (remain.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (remain.m_41613_() == src.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, remain);
        }
        return src;
    }

    public void m_38946_() {
        if (this.tile != null) {
            this.setTrackValues();
        }
        super.m_38946_();
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (27 <= slotId && slotId < 45 && clickTypeIn == ClickType.PICKUP) {
            int index = slotId - 27;
            if (index < this.tile.recipesList.size()) {
                if (dragType == 0) {
                    ResourceLocation newRecipeId = this.tile.recipesList.get(index).m_6423_();
                    if (newRecipeId.equals((Object)this.tile.getRecipe().m_6423_())) {
                        this.tile.workContinue = !this.tile.workContinue;
                    } else {
                        this.tile.setCurrentRecipe(newRecipeId);
                    }
                } else if (dragType == 1) {
                    this.tile.setCurrentRecipe(WorkbenchRecipe.dummyRecipe().m_6423_());
                }
            }
        } else if (0 <= slotId && slotId < 27 && clickTypeIn == ClickType.PICKUP) {
            Slot slot = this.m_38853_(slotId);
            ItemStack slotStack = slot.m_7993_();
            ItemStack carrying = this.m_142621_();
            if (slotStack.m_41619_()) {
                if (!carrying.m_41619_() && slot.m_5857_(carrying)) {
                    int l2;
                    int n = l2 = dragType == 0 ? carrying.m_41613_() : 1;
                    if (l2 > slot.m_5866_(carrying)) {
                        l2 = slot.m_5866_(carrying);
                    }
                    slot.m_5852_(carrying.m_41620_(l2));
                }
            } else if (carrying.m_41619_()) {
                int k2 = dragType == 0 ? Math.min(slotStack.m_41613_(), slotStack.m_41741_()) : Math.min((slotStack.m_41613_() + 1) / 2, slotStack.m_41741_());
                this.m_142503_(slot.m_6201_(k2));
                if (slotStack.m_41619_()) {
                    slot.m_5852_(ItemStack.f_41583_);
                }
                slot.m_142406_(player, this.m_142621_());
            } else if (ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)carrying)) {
                int j2 = dragType == 0 ? carrying.m_41613_() : 1;
                carrying.m_41774_(j2);
                slotStack.m_41769_(j2);
            }
            slot.m_6654_();
        } else if (clickTypeIn != ClickType.SWAP) {
            super.m_150399_(slotId, dragType, clickTypeIn, player);
        }
    }

    protected boolean n_moveItemStackTo(ItemStack stack) {
        int i;
        boolean flag = false;
        for (i = 0; i < 27 && !stack.m_41619_(); ++i) {
            int maxSize;
            Slot slot = this.m_38853_(i);
            ItemStack itemstack = slot.m_7993_();
            if (itemstack.m_41619_() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemstack)) continue;
            int j = itemstack.m_41613_() + stack.m_41613_();
            if (j <= (maxSize = slot.m_6641_())) {
                stack.m_41764_(0);
                itemstack.m_41764_(j);
                slot.m_6654_();
                flag = true;
                continue;
            }
            if (itemstack.m_41613_() >= maxSize) continue;
            if (QuarryPlus.config.debug()) {
                QuarryPlus.LOGGER.info("ContainerWorkbench#mergeItemStack itemStack.getCount() < maxSize");
            }
            stack.m_41774_(maxSize - itemstack.m_41613_());
            itemstack.m_41764_(maxSize);
            slot.m_6654_();
            flag = true;
        }
        if (!stack.m_41619_()) {
            for (i = 0; i < 27; ++i) {
                Slot slot1 = this.m_38853_(i);
                ItemStack itemStack1 = slot1.m_7993_();
                if (!itemStack1.m_41619_() || !slot1.m_5857_(stack)) continue;
                slot1.m_5852_(stack.m_41620_(stack.m_41613_()));
                slot1.m_6654_();
                flag = true;
                break;
            }
        }
        return flag;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.tile.m_5785_(playerIn);
    }
}

