/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.easier_sleeping.config;

import de.geheimagentnr1.easier_sleeping.config.DimensionListType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerConfig {
    private static final Logger LOGGER = LogManager.getLogger(ServerConfig.class);
    private static final String MOD_NAME = ModLoadingContext.get().getActiveContainer().getModInfo().getDisplayName();
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec CONFIG;
    private static final ForgeConfigSpec.IntValue SLEEP_PERCENT;
    private static final ForgeConfigSpec.ConfigValue<String> SLEEP_MESSAGE;
    private static final ForgeConfigSpec.ConfigValue<String> WAKE_MESSAGE;
    private static final ForgeConfigSpec.ConfigValue<String> MORNING_MESSAGE;
    private static final ForgeConfigSpec.BooleanValue ALL_PLAYERS_REST;
    private static final ForgeConfigSpec.ConfigValue<List<String>> DIMENSIONS;
    private static final ForgeConfigSpec.EnumValue<DimensionListType> DIMENSION_LIST_TYPE;
    private static final ForgeConfigSpec.ConfigValue<List<String>> BLOCK_BLACKLIST;
    private static final TreeSet<ResourceKey<Level>> dimensions;
    private static final TreeSet<ResourceLocation> blockBlacklist;

    private static void printConfig() {
        LOGGER.info("{} = {}", (Object)SLEEP_PERCENT.getPath(), SLEEP_PERCENT.get());
        LOGGER.info("{} = {}", (Object)SLEEP_MESSAGE.getPath(), SLEEP_MESSAGE.get());
        LOGGER.info("{} = {}", (Object)WAKE_MESSAGE.getPath(), WAKE_MESSAGE.get());
        LOGGER.info("{} = {}", (Object)MORNING_MESSAGE.getPath(), MORNING_MESSAGE.get());
        LOGGER.info("{} = {}", (Object)DIMENSIONS.getPath(), DIMENSIONS.get());
        LOGGER.info("{} = {}", (Object)DIMENSION_LIST_TYPE.getPath(), DIMENSION_LIST_TYPE.get());
    }

    public static void printLoadedConfig() {
        LOGGER.info("Loading \"{}\" Server Config", (Object)MOD_NAME);
        ServerConfig.printConfig();
        LOGGER.info("\"{}\" Server Config loaded", (Object)MOD_NAME);
    }

    public static synchronized void checkAndPrintConfig() {
        boolean areDimensionCorrected = ServerConfig.checkCorrectAndReadDimensions();
        boolean areBlocksOfBlacklistCorrected = ServerConfig.checkCorrectAndReadBlockBlacklist();
        if (areDimensionCorrected || areBlocksOfBlacklistCorrected) {
            LOGGER.info("\"{}\" Server Config corrected", (Object)MOD_NAME);
            ServerConfig.printConfig();
        }
    }

    private static synchronized boolean checkCorrectAndReadDimensions() {
        ArrayList read_dimensions = new ArrayList((Collection)DIMENSIONS.get());
        dimensions.clear();
        for (String read_dimension : read_dimensions) {
            ResourceLocation registry_name = ResourceLocation.m_135820_((String)read_dimension);
            if (registry_name != null) {
                ResourceKey registrykey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)registry_name);
                ServerLevel serverLevel = ServerLifecycleHooks.getCurrentServer().m_129880_(registrykey);
                if (serverLevel == null) {
                    LOGGER.warn("Removed unknown dimension: {}", (Object)read_dimension);
                    continue;
                }
                dimensions.add((ResourceKey<Level>)registrykey);
                continue;
            }
            LOGGER.warn("Removed invalid dimension registry name {}", (Object)read_dimension);
        }
        if (((List)DIMENSIONS.get()).size() != dimensions.size()) {
            DIMENSIONS.set(ServerConfig.dimensionsToRegistryNameList());
            return true;
        }
        return false;
    }

    private static synchronized ArrayList<String> dimensionsToRegistryNameList() {
        ArrayList<String> registryNames = new ArrayList<String>();
        for (ResourceKey<Level> dimension : dimensions) {
            registryNames.add(Objects.requireNonNull(dimension.m_135782_()).toString());
        }
        return registryNames;
    }

    public static synchronized void invertDimensions() {
        ArrayList<String> newDimensionRegistryNames = new ArrayList<String>();
        for (ServerLevel serverLevel : ServerLifecycleHooks.getCurrentServer().m_129785_()) {
            ResourceKey registrykey = serverLevel.m_46472_();
            if (dimensions.contains(registrykey)) continue;
            newDimensionRegistryNames.add(Objects.requireNonNull(registrykey.m_135782_()).toString());
        }
        newDimensionRegistryNames.sort(String::compareTo);
        DIMENSIONS.set(newDimensionRegistryNames);
        ServerConfig.checkAndPrintConfig();
    }

    private static synchronized boolean checkCorrectAndReadBlockBlacklist() {
        ArrayList block_blacklist = new ArrayList((Collection)BLOCK_BLACKLIST.get());
        blockBlacklist.clear();
        for (String block : block_blacklist) {
            ResourceLocation registry_name = ResourceLocation.m_135820_((String)block);
            if (registry_name != null) {
                if (Registry.f_122824_.m_6612_(registry_name).isPresent()) {
                    blockBlacklist.add(registry_name);
                    continue;
                }
                LOGGER.warn("Removed unknown block: {}", (Object)block);
                continue;
            }
            LOGGER.warn("Removed invalid block registry name {}", (Object)block);
        }
        if (((List)BLOCK_BLACKLIST.get()).size() != blockBlacklist.size()) {
            BLOCK_BLACKLIST.set(ServerConfig.blockBlacklistToRegistryNameList());
            return true;
        }
        return false;
    }

    private static synchronized ArrayList<String> blockBlacklistToRegistryNameList() {
        ArrayList<String> registryNames = new ArrayList<String>();
        for (ResourceLocation block : blockBlacklist) {
            registryNames.add(Objects.requireNonNull(block).toString());
        }
        return registryNames;
    }

    public static int getSleepPercent() {
        return (Integer)SLEEP_PERCENT.get();
    }

    public static void setSleepPercent(int sleep_percent) {
        SLEEP_PERCENT.set((Object)sleep_percent);
    }

    public static String getSleepMessage() {
        return (String)SLEEP_MESSAGE.get();
    }

    public static void setSleepMessage(String message) {
        SLEEP_MESSAGE.set((Object)message);
    }

    public static String getWakeMessage() {
        return (String)WAKE_MESSAGE.get();
    }

    public static void setWakeMessage(String message) {
        WAKE_MESSAGE.set((Object)message);
    }

    public static String getMorningMessage() {
        return (String)MORNING_MESSAGE.get();
    }

    public static void setMorningMessage(String message) {
        MORNING_MESSAGE.set((Object)message);
    }

    public static boolean getAllPlayersRest() {
        return (Boolean)ALL_PLAYERS_REST.get();
    }

    public static void setAllPlayersRest(boolean all_player_rest) {
        ALL_PLAYERS_REST.set((Object)all_player_rest);
    }

    public static TreeSet<ResourceKey<Level>> getDimensions() {
        return dimensions;
    }

    public static synchronized void addDimension(ResourceKey<Level> dimension) {
        if (!dimensions.contains(dimension)) {
            dimensions.add(dimension);
            DIMENSIONS.set(ServerConfig.dimensionsToRegistryNameList());
        }
    }

    public static synchronized void removeDimension(ResourceKey<Level> dimension) {
        if (dimensions.contains(dimension)) {
            dimensions.remove(dimension);
            DIMENSIONS.set(ServerConfig.dimensionsToRegistryNameList());
        }
    }

    public static DimensionListType getDimensionListType() {
        return (DimensionListType)((Object)DIMENSION_LIST_TYPE.get());
    }

    public static void setDimensionListType(DimensionListType dimensionListType) {
        DIMENSION_LIST_TYPE.set((Object)dimensionListType);
    }

    public static TreeSet<ResourceLocation> getIgnoredBedBlocks() {
        return blockBlacklist;
    }

    static {
        dimensions = new TreeSet<ResourceKey>(Comparator.comparing(ResourceKey::m_135782_));
        blockBlacklist = new TreeSet();
        SLEEP_PERCENT = BUILDER.comment("Percentage of players required to skip the night.").defineInRange("sleep_percent", 50, 0, 100);
        SLEEP_MESSAGE = BUILDER.comment("Message shown, if a player goes to bed").define("sleep_message", (Object)"is now in bed.");
        WAKE_MESSAGE = BUILDER.comment("Message shown, if a player leaves his bed").define("wake_message", (Object)"stood up.");
        MORNING_MESSAGE = BUILDER.comment("Message shown, if the night was skipped").define("morning_message", (Object)"Good Morning");
        ALL_PLAYERS_REST = BUILDER.comment("If true, the time since last rest is reset for all players, if enough other players are successfully sleeping. So not every player has to sleep to prevent phantom spawning for him.").define("all_players_rest", false);
        DIMENSIONS = BUILDER.comment(new String[]{"If dimension_list_type is set to SLEEP_ACTIVE, the list is the list of dimensions in which the sleep voting is active.", "If dimension_list_type is set to SLEEP_INACTIVE, the list is the list of dimensions in which the sleep voting is inactive."}).define("dimensions", Collections.singletonList(Objects.requireNonNull(Level.f_46428_.m_135782_()).toString()), o -> {
            if (o instanceof List) {
                List list = (List)o;
                return list.isEmpty() || list.get(0) instanceof String;
            }
            return false;
        });
        DIMENSION_LIST_TYPE = BUILDER.comment(new String[]{"If dimension_list_type is set to SLEEP_ACTIVE, the dimension list is the list of dimensions in which the sleep voting is active.", "If dimension_list_type is set to SLEEP_INACTIVE, the dimension list is the list of dimensions in which the sleep voting is inactive."}).defineEnum("dimension_list_type", (Enum)DimensionListType.SLEEP_ACTIVE);
        BLOCK_BLACKLIST = BUILDER.comment("Block names of beds being ignored for sleep percentage.").define("block_blacklist", List.of(), o -> {
            if (o instanceof List) {
                List list = (List)o;
                return list.isEmpty() || list.get(0) instanceof String;
            }
            return false;
        });
        CONFIG = BUILDER.build();
    }
}

