/*
 * Decompiled with CFR 0.152.
 */
package chiefarug.mods.systeams;

import net.minecraftforge.common.ForgeConfigSpec;

public class SysteamsConfig {
    public static final ForgeConfigSpec.ConfigValue<Double> STEAM_RATIO_STIRLING;
    public static final ForgeConfigSpec.ConfigValue<Double> STEAM_RATIO_MAGMATIC;
    public static final ForgeConfigSpec.ConfigValue<Double> STEAM_RATIO_COMPRESSION;
    public static final ForgeConfigSpec.ConfigValue<Double> STEAM_RATIO_NUMISMATIC;
    public static final ForgeConfigSpec.ConfigValue<Double> STEAM_RATIO_LAPIDARY;
    public static final ForgeConfigSpec.ConfigValue<Double> STEAM_RATIO_DISENCHANTMENT;
    public static final ForgeConfigSpec.ConfigValue<Double> STEAM_RATIO_GOURMAND;
    public static final ForgeConfigSpec.ConfigValue<Double> SPEED_STIRLING;
    public static final ForgeConfigSpec.ConfigValue<Double> SPEED_MAGMATIC;
    public static final ForgeConfigSpec.ConfigValue<Double> SPEED_COMPRESSION;
    public static final ForgeConfigSpec.ConfigValue<Double> SPEED_NUMISMATIC;
    public static final ForgeConfigSpec.ConfigValue<Double> SPEED_LAPIDARY;
    public static final ForgeConfigSpec.ConfigValue<Double> SPEED_DISENCHANTMENT;
    public static final ForgeConfigSpec.ConfigValue<Double> SPEED_GOURMAND;
    public static final ForgeConfigSpec.ConfigValue<Double> WATER_TO_STEAM_RATIO;
    public static final ForgeConfigSpec.ConfigValue<Double> STEAM_DYNAMO_MULTIPLIER;
    static final ForgeConfigSpec spec;
    private static final double steamRatioDefaultValue = 0.5;
    private static final double steamRatioMin = 0.05;
    private static final double steamRatioMax = 100.0;
    private static final double speedDefaultValue = 2.0;
    private static final double speedMin = 0.05;
    private static final double speedMax = 20.0;

    private static ForgeConfigSpec.ConfigValue<Double> steamRatio(ForgeConfigSpec.Builder builder, String name) {
        return builder.defineInRange(name, 0.5, 0.05, 100.0);
    }

    private static ForgeConfigSpec.ConfigValue<Double> speed(ForgeConfigSpec.Builder builder, String name) {
        return builder.defineInRange(name, 2.0, 0.05, 20.0);
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment(new String[]{"Systeams Config", "---------------"});
        builder.comment("The amount of steam 1mb of water makes.");
        WATER_TO_STEAM_RATIO = builder.defineInRange("water_to_steam_ratio", 2.0, 0.1, 10.0);
        builder.comment("The multiplier on the steam dynamo's RF/t");
        STEAM_DYNAMO_MULTIPLIER = builder.defineInRange("steam_dynamo_output_multiplier", 2.0, 0.05, 10.0);
        builder.push("Steam Values");
        builder.comment(new String[]{"The number of mb of steam produced per RF of energy usually produced by the same fuel in a dynamo", "Note that this does not affect the steam dynamo's rates. That needs to be adjusted with a datapack"});
        STEAM_RATIO_STIRLING = SysteamsConfig.steamRatio(builder, "stirling");
        STEAM_RATIO_MAGMATIC = SysteamsConfig.steamRatio(builder, "magmatic");
        STEAM_RATIO_COMPRESSION = SysteamsConfig.steamRatio(builder, "compression");
        STEAM_RATIO_NUMISMATIC = SysteamsConfig.steamRatio(builder, "numismatic");
        STEAM_RATIO_LAPIDARY = SysteamsConfig.steamRatio(builder, "lapidary");
        STEAM_RATIO_DISENCHANTMENT = SysteamsConfig.steamRatio(builder, "disenchantment");
        STEAM_RATIO_GOURMAND = SysteamsConfig.steamRatio(builder, "gourmand");
        builder.pop();
        builder.push("Boiler Speed Multipliers");
        builder.comment("The speed multiplier on each boiler's mB/t");
        SPEED_STIRLING = SysteamsConfig.speed(builder, "stirling");
        SPEED_MAGMATIC = SysteamsConfig.speed(builder, "magmatic");
        SPEED_COMPRESSION = SysteamsConfig.speed(builder, "compression");
        SPEED_NUMISMATIC = SysteamsConfig.speed(builder, "numismatic");
        SPEED_LAPIDARY = SysteamsConfig.speed(builder, "lapidary");
        SPEED_DISENCHANTMENT = SysteamsConfig.speed(builder, "disenchantment");
        SPEED_GOURMAND = SysteamsConfig.speed(builder, "gourmand");
        spec = builder.build();
    }
}

