/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.displaystate.math;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.SerializerEnum;

public enum AxisAlignedRotation {
    X_0(RotationAxis.X, 0),
    X_90(RotationAxis.X, 1),
    X_180(RotationAxis.X, 2),
    X_270(RotationAxis.X, 3),
    Y_0(RotationAxis.Y, 0),
    Y_90(RotationAxis.Y, 1),
    Y_180(RotationAxis.Y, 2),
    Y_270(RotationAxis.Y, 3),
    Z_0(RotationAxis.Z, 0),
    Z_90(RotationAxis.Z, 1),
    Z_180(RotationAxis.Z, 2),
    Z_270(RotationAxis.Z, 3);

    public static final ISerializer<AxisAlignedRotation> SERIALIZER;
    public final Quaternion rotation;
    public final Vector3f offset;

    private AxisAlignedRotation(RotationAxis axis, int amount) {
        if (amount < 0 || amount > 3) {
            throw new IllegalArgumentException("Rotation amount " + amount + " is out of bounds. Must be 0-3. 0 = 0 degrees. 1 = 90 degrees. 2 = 180 degrees. 3 = 270 degrees.");
        }
        this.rotation = axis.quaternions[amount];
        this.offset = axis.offsets[amount];
    }

    static {
        SERIALIZER = new SerializerEnum(AxisAlignedRotation.class);
    }

    public static enum RotationAxis {
        X(Vector3f.f_122223_, Vector3f.f_176763_, new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(0.0f, -1.0f, -1.0f), new Vector3f(0.0f, -1.0f, 0.0f)),
        Y(Vector3f.f_122225_, Vector3f.f_176763_, new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(-1.0f, 0.0f, -1.0f), new Vector3f(0.0f, 0.0f, -1.0f)),
        Z(Vector3f.f_122227_, Vector3f.f_176763_, new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 0.0f));

        private final Quaternion[] quaternions;
        private final Vector3f[] offsets;

        private RotationAxis(Vector3f axisVect, Vector3f offsetA, Vector3f offsetB, Vector3f offsetC, Vector3f offsetD) {
            this.quaternions = new Quaternion[]{axisVect.m_122240_(0.0f), axisVect.m_122240_(90.0f), axisVect.m_122240_(180.0f), axisVect.m_122240_(270.0f)};
            this.offsets = new Vector3f[]{offsetA, offsetB, offsetC, offsetD};
        }
    }
}

