/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.event;

import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.api.item.IElementalArmor;
import alexthw.ars_elemental.api.item.ISchoolBangle;
import alexthw.ars_elemental.api.item.ISchoolFocus;
import alexthw.ars_elemental.common.entity.FirenandoEntity;
import alexthw.ars_elemental.registry.ModPotions;
import com.hollingsworth.arsnouveau.api.event.SpellDamageEvent;
import com.hollingsworth.arsnouveau.api.spell.IFilter;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.common.capability.CapabilityRegistry;
import java.util.HashMap;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ars_elemental")
public class DamageEvents {
    @SubscribeEvent
    public static void betterFilters(SpellDamageEvent.Pre event) {
        IFilter filter;
        Object e;
        if (event.context != null && event.context.getCurrentIndex() > 0 && (e = event.context.getSpell().recipe.get(event.context.getCurrentIndex() - 1)) instanceof IFilter && !(filter = (IFilter)e).shouldResolveOnEntity(event.target)) {
            event.setCanceled(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent
    public static void bypassRes(LivingAttackEvent event) {
        Entity focus;
        LivingEntity living = event.getEntity();
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (living != null) {
                focus = ISchoolFocus.hasFocus(event.getEntity().f_19853_, (Entity)player);
                if (focus == null) return;
                switch (focus.getId()) {
                    case "fire": {
                        if (!event.getSource().m_19384_()) return;
                        if (!living.m_5825_()) return;
                        event.setCanceled(true);
                        DamageSource newDamage = new EntityDamageSource("hellflare", (Entity)player).m_19389_();
                        if (event.getSource().m_19376_()) {
                            newDamage.m_19380_();
                        }
                        if (event.getSource().m_19379_()) {
                            newDamage.m_19382_();
                        }
                        living.m_6469_(newDamage, event.getAmount());
                        return;
                    }
                    case "water": {
                        if (!event.getSource().m_19385_().equals("drown")) return;
                        if (living.m_6336_() != MobType.f_21644_) return;
                        event.setCanceled(true);
                        DamageSource newDamage = DamageSource.m_19344_((Player)player).m_19389_();
                        if (event.getSource().m_19376_()) {
                            newDamage.m_19380_();
                        }
                        if (event.getSource().m_19379_()) {
                            newDamage.m_19382_();
                        }
                        living.m_6469_(newDamage, event.getAmount());
                        return;
                    }
                    case "air": {
                        if (living.f_19802_ <= 0) return;
                        if (!event.getSource().m_146707_()) return;
                        living.f_19802_ = 0;
                        return;
                    }
                }
                return;
            }
        }
        if (!((focus = event.getSource().m_7639_()) instanceof FirenandoEntity)) return;
        FirenandoEntity FE = (FirenandoEntity)focus;
        if (living instanceof Monster) {
            Monster mob = (Monster)living;
            if (!mob.m_5825_()) return;
            if (!event.getSource().m_19384_()) return;
            event.setCanceled(true);
            mob.m_6469_(DamageSource.m_19370_((LivingEntity)FE).m_19389_().m_19380_(), event.getAmount());
            return;
        }
        event.setCanceled(true);
        living.m_20095_();
    }

    @SubscribeEvent
    public static void banglesSpecials(LivingAttackEvent event) {
        Player player;
        LivingEntity living = event.getEntity();
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            SpellSchool bangle;
            player = (Player)entity;
            if (living != null && living != player && (bangle = ISchoolBangle.hasBangle(event.getEntity().f_19853_, (Entity)player)) != null) {
                switch (bangle.getId()) {
                    case "fire": {
                        living.m_20254_(5);
                        break;
                    }
                    case "water": {
                        living.m_146917_(living.m_146888_() + 100);
                        break;
                    }
                    case "earth": {
                        living.m_7292_(new MobEffectInstance((MobEffect)com.hollingsworth.arsnouveau.common.potions.ModPotions.SNARE_EFFECT.get(), 60));
                    }
                }
            }
        }
        if (living instanceof Player) {
            player = (Player)living;
            if ((event.getSource() == DamageSource.f_19314_ || event.getSource() == DamageSource.f_19325_) && ISchoolBangle.hasBangle(event.getEntity().f_19853_, (Entity)player) == SpellSchools.ELEMENTAL_EARTH) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void handleHealing(LivingHealEvent event) {
        Player player;
        LivingEntity livingEntity;
        if (((Boolean)ConfigHandler.COMMON.EnableGlyphEmpowering.get()).booleanValue() || (livingEntity = event.getEntity()) instanceof Player && ISchoolFocus.hasFocus((player = (Player)livingEntity).m_9236_(), (Entity)player) == SpellSchools.ELEMENTAL_EARTH) {
            event.setAmount(event.getAmount() * 1.5f);
        }
        if (event.getEntity().m_21023_((MobEffect)ModPotions.HELLFIRE.get())) {
            MobEffectInstance inst = event.getEntity().m_21124_((MobEffect)ModPotions.HELLFIRE.get());
            if (inst == null) {
                return;
            }
            int amplifier = Math.min(9, inst.m_19564_());
            event.setAmount(event.getAmount() * (float)(10 - amplifier) / 10.0f);
            event.getEntity().f_19802_ = 0;
        }
    }

    @SubscribeEvent
    public static void damageReduction(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getSource() == DamageSource.f_19316_ && ISchoolFocus.hasFocus(event.getEntity().f_19853_, (Entity)player) == SpellSchools.ELEMENTAL_AIR) {
                event.setAmount(event.getAmount() * 0.1f);
            }
            HashMap<SpellSchool, Integer> bonusMap = new HashMap<SpellSchool, Integer>();
            int bonusReduction = 0;
            for (ItemStack stack : player.m_6168_()) {
                IElementalArmor armor;
                Item item = stack.m_41720_();
                if (!(item instanceof IElementalArmor) || !(armor = (IElementalArmor)item).doAbsorb(event.getSource())) continue;
                ++bonusReduction;
                if (bonusMap.containsKey(armor.getSchool())) {
                    bonusMap.put(armor.getSchool(), (Integer)bonusMap.get(armor.getSchool()) + 1);
                    continue;
                }
                bonusMap.put(armor.getSchool(), 1);
            }
            if (bonusMap.getOrDefault(SpellSchools.ELEMENTAL_FIRE, 0) == 4 && event.getSource().m_19384_() || event.getSource().f_19326_.equals("hellflare")) {
                player.m_20095_();
            }
            if (bonusMap.getOrDefault(SpellSchools.ELEMENTAL_WATER, 0) == 4 && event.getSource() == DamageSource.f_19312_) {
                player.m_20301_(player.m_6062_());
                bonusReduction += 5;
            }
            if (bonusMap.getOrDefault(SpellSchools.ELEMENTAL_EARTH, 0) == 4 && player.m_146892_().m_7098_() < 20.0 && player.m_36324_().m_38702_() < 2) {
                player.m_36324_().m_38705_(20);
            }
            if (bonusMap.getOrDefault(SpellSchools.ELEMENTAL_AIR, 0) == 4 && event.getSource().m_146707_()) {
                bonusReduction += 5;
            }
            if (bonusReduction > 0) {
                int finalBonusReduction = bonusReduction;
                CapabilityRegistry.getMana((LivingEntity)player).ifPresent(mana -> {
                    if (finalBonusReduction > 3) {
                        mana.addMana((double)(event.getAmount() * 5.0f));
                    }
                    event.getEntity().m_7292_(new MobEffectInstance((MobEffect)com.hollingsworth.arsnouveau.common.potions.ModPotions.MANA_REGEN_EFFECT.get(), 200, finalBonusReduction / 2));
                });
                event.setAmount(event.getAmount() * (1.0f - (float)bonusReduction / 10.0f));
            }
        }
    }
}

