/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.mob_effects;

import alexthw.ars_elemental.util.EntityCarryMEI;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;

public class EnthrallEffect
extends MobEffect {
    public EnthrallEffect() {
        super(MobEffectCategory.NEUTRAL, 0);
        MinecraftForge.EVENT_BUS.addListener(this::onTarget);
    }

    public void onTarget(LivingChangeTargetEvent event) {
        Mob thrall;
        LivingEntity livingEntity = event.getNewTarget();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        LivingEntity livingEntity2 = event.getEntity();
        if (livingEntity2 instanceof Mob && this.isEnthralledBy((LivingEntity)(thrall = (Mob)livingEntity2), player)) {
            if (player.m_21214_() != null && player.m_21214_() != thrall) {
                event.setNewTarget(player.m_21214_());
                if (thrall instanceof NeutralMob) {
                    angry = (NeutralMob)thrall;
                    angry.m_6925_(player.m_21214_().m_20148_());
                }
            } else if (player.m_21188_() != null && player.m_21188_() != thrall) {
                event.setNewTarget(player.m_21188_());
                if (thrall instanceof NeutralMob) {
                    angry = (NeutralMob)thrall;
                    angry.m_6925_(player.m_21188_().m_20148_());
                }
            } else {
                event.setNewTarget(null);
                if (thrall instanceof NeutralMob) {
                    angry = (NeutralMob)thrall;
                    angry.m_7870_(0);
                }
            }
        }
    }

    private boolean isEnthralledBy(LivingEntity entity, Player player) {
        MobEffectInstance instance;
        if (entity.m_21023_((MobEffect)this) && (instance = entity.m_21124_((MobEffect)this)) instanceof EntityCarryMEI) {
            EntityCarryMEI mei = (EntityCarryMEI)instance;
            return mei.getOwner() == player;
        }
        return false;
    }

    public List<ItemStack> getCurativeItems() {
        return new ArrayList<ItemStack>();
    }
}

