/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.AlmostUnifiedRuntime;
import com.almostreliable.unified.api.StoneStrataHandler;
import com.almostreliable.unified.config.UnifyConfig;
import com.almostreliable.unified.utils.ReplacementMap;
import com.almostreliable.unified.utils.TagMap;
import com.almostreliable.unified.utils.UnifyTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class HideHelper {
    public static Collection<ItemStack> createHidingList(AlmostUnifiedRuntime runtime) {
        ReplacementMap repMap = runtime.getReplacementMap().orElse(null);
        TagMap filteredTagMap = runtime.getFilteredTagMap().orElse(null);
        if (repMap == null || filteredTagMap == null) {
            return new ArrayList<ItemStack>();
        }
        return filteredTagMap.getTags().stream().map(unifyTag -> {
            Collection<ResourceLocation> itemsByTag = filteredTagMap.getItems((UnifyTag<Item>)unifyTag);
            long namespaces = itemsByTag.stream().map(ResourceLocation::m_135827_).distinct().count();
            if (namespaces <= 1L) {
                return new ArrayList();
            }
            Set replacements = itemsByTag.stream().map(repMap::getReplacementForItem).filter(Objects::nonNull).collect(Collectors.toSet());
            List<ResourceLocation> toHide = itemsByTag.stream().filter(rl -> !replacements.contains(rl)).toList();
            if (!toHide.isEmpty()) {
                AlmostUnified.LOG.info("Hiding {}/{} items for tag {} -> {}", (Object)toHide.size(), (Object)itemsByTag.size(), (Object)unifyTag.location(), toHide);
            }
            return toHide.stream().flatMap(rl -> Registry.f_122827_.m_6612_(rl).stream()).map(ItemStack::new).toList();
        }).flatMap(Collection::stream).toList();
    }

    private static StoneStrataHandler getStoneStrataHandler(UnifyConfig config) {
        Set<UnifyTag<Item>> stoneStrataTags = AlmostUnifiedPlatform.INSTANCE.getStoneStrataTags(config.getStoneStrata());
        TagMap stoneStrataTagMap = TagMap.create(stoneStrataTags);
        return StoneStrataHandler.create(config.getStoneStrata(), stoneStrataTags, stoneStrataTagMap);
    }
}

