/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.config.UnifyConfig;
import com.almostreliable.unified.utils.UnifyTag;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.script.BindingsEvent;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AlmostKube
extends KubeJSPlugin {
    public void registerBindings(BindingsEvent event) {
        if (event.getType().isServer()) {
            event.add("AlmostUnified", UnifyWrapper.class);
        }
    }

    public static class UnifyWrapper {
        @Nullable
        public static String getPreferredTagForItem(ItemStack stack) {
            UnifyTag<Item> tag = AlmostUnified.getRuntime().getReplacementMap().orElseThrow(UnifyWrapper::notLoadedException).getPreferredTagForItem(UnifyWrapper.getId(stack));
            return tag == null ? null : tag.location().toString();
        }

        public static ItemStack getReplacementForItem(ItemStack stack) {
            ResourceLocation replacement = AlmostUnified.getRuntime().getReplacementMap().orElseThrow(UnifyWrapper::notLoadedException).getReplacementForItem(UnifyWrapper.getId(stack));
            return ItemStackJS.of((Object)replacement);
        }

        public static ItemStack getPreferredItemForTag(ResourceLocation tag) {
            UnifyTag<Item> asUnifyTag = UnifyTag.item(tag);
            ResourceLocation item = AlmostUnified.getRuntime().getReplacementMap().orElseThrow(UnifyWrapper::notLoadedException).getPreferredItemForTag(asUnifyTag, $ -> true);
            return ItemStackJS.of((Object)item);
        }

        public static Set<String> getTags() {
            return AlmostUnified.getRuntime().getFilteredTagMap().orElseThrow(UnifyWrapper::notLoadedException).getTags().stream().map(tag -> tag.location().toString()).collect(Collectors.toSet());
        }

        public static Set<String> getItemIds(ResourceLocation tag) {
            UnifyTag<Item> asUnifyTag = UnifyTag.item(tag);
            return AlmostUnified.getRuntime().getFilteredTagMap().orElseThrow(UnifyWrapper::notLoadedException).getItems(asUnifyTag).stream().map(ResourceLocation::toString).collect(Collectors.toSet());
        }

        public static UnifyConfig getUnifyConfig() {
            return AlmostUnified.getRuntime().getUnifyConfig().orElseThrow(UnifyWrapper::notLoadedException);
        }

        private static ResourceLocation getId(ItemStack stack) {
            return Registry.f_122827_.m_7854_((Object)stack.m_41720_()).map(ResourceKey::m_135782_).orElseThrow(() -> new IllegalArgumentException("Item not found in registry"));
        }

        private static IllegalStateException notLoadedException() {
            return new IllegalStateException("AlmostUnified runtime is not available in KubeJS! Possible reasons: calling runtime too early, not in a server environment");
        }
    }
}

