/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified;

import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.AlmostUnifiedRuntime;
import com.almostreliable.unified.api.StoneStrataHandler;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.config.UnifyConfig;
import com.almostreliable.unified.utils.ReplacementMap;
import com.almostreliable.unified.utils.TagMap;
import com.almostreliable.unified.utils.UnifyTag;
import com.google.gson.JsonElement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class AlmostUnifiedFallbackRuntime
implements AlmostUnifiedRuntime {
    @Nullable
    private static AlmostUnifiedFallbackRuntime INSTANCE;
    @Nullable
    private UnifyConfig config;
    @Nullable
    private ReplacementMap replacementMap;
    @Nullable
    private TagMap filteredTagMap;

    public static AlmostUnifiedFallbackRuntime getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AlmostUnifiedFallbackRuntime();
            INSTANCE.reload();
        }
        return INSTANCE;
    }

    public void reload() {
        this.config = null;
        this.replacementMap = null;
        this.filteredTagMap = null;
        this.build();
    }

    private UnifyConfig getConfig() {
        if (this.config == null) {
            this.config = Config.load("unify", new UnifyConfig.Serializer());
        }
        return this.config;
    }

    public void build() {
        UnifyConfig config = this.getConfig();
        List<UnifyTag<Item>> unifyTags = config.bakeTags();
        this.filteredTagMap = TagMap.create(unifyTags).filtered($ -> true, config::includeItem);
        StoneStrataHandler stoneStrataHandler = AlmostUnifiedFallbackRuntime.getStoneStrataHandler(config);
        this.replacementMap = new ReplacementMap(Objects.requireNonNull(this.filteredTagMap), stoneStrataHandler, config);
    }

    private static StoneStrataHandler getStoneStrataHandler(UnifyConfig config) {
        Set<UnifyTag<Item>> stoneStrataTags = AlmostUnifiedPlatform.INSTANCE.getStoneStrataTags(config.getStoneStrata());
        TagMap stoneStrataTagMap = TagMap.create(stoneStrataTags);
        return StoneStrataHandler.create(config.getStoneStrata(), stoneStrataTags, stoneStrataTagMap);
    }

    @Override
    public void run(Map<ResourceLocation, JsonElement> recipes, boolean skipClientTracking) {
    }

    @Override
    public Optional<TagMap> getFilteredTagMap() {
        return Optional.ofNullable(this.filteredTagMap);
    }

    @Override
    public Optional<ReplacementMap> getReplacementMap() {
        return Optional.ofNullable(this.replacementMap);
    }

    @Override
    public Optional<UnifyConfig> getUnifyConfig() {
        return Optional.ofNullable(this.config);
    }
}

