/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item;

import com.stal111.forbidden_arcanus.core.init.ModItems;
import com.stal111.forbidden_arcanus.util.ModTags;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.valhelsia.valhelsia_core.common.util.ItemStackUtils;

public class QuantumCatcherItem
extends Item {
    public QuantumCatcherItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        if (this.getEntity(stack, level) != null) {
            Entity entity = this.getEntity(stack, level);
            if (!level.m_8055_(pos).m_60629_(new BlockPlaceContext(context))) {
                pos = pos.m_121945_(context.m_43719_());
            }
            if (entity == null || !level.m_8055_(pos).m_60629_(new BlockPlaceContext(context))) {
                return InteractionResult.FAIL;
            }
            if (!level.m_5776_()) {
                entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                if (context.m_43723_() != null) {
                    entity.m_7618_(EntityAnchorArgument.Anchor.EYES, context.m_43723_().m_20182_());
                }
                level.m_7967_(entity);
            }
            this.clearEntity(stack);
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6225_(context);
    }

    public InteractionResult onEntityInteract(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        Level level = player.m_20193_();
        if (target instanceof Player || target.m_6095_().m_204039_(ModTags.EntityTypes.QUANTUM_CATCHER_BLACKLISTED)) {
            return InteractionResult.PASS;
        }
        if (this.getEntity(stack, level) == null && target.m_6084_()) {
            if (stack.m_41613_() != 1) {
                ItemStackUtils.shrinkStack((Player)player, (ItemStack)stack);
                ItemStack newStack = new ItemStack((ItemLike)ModItems.QUANTUM_CATCHER.get());
                this.setEntity((Entity)target, newStack);
                if (!player.m_36356_(newStack)) {
                    player.m_36176_(newStack, false);
                }
            } else {
                this.setEntity((Entity)target, stack);
            }
            target.m_146870_();
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6880_(stack, player, target, hand);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        if (level != null && this.getEntity(stack, level) != null) {
            Entity entity = this.getEntity(stack, level);
            if (entity == null) {
                return;
            }
            MutableComponent textComponent = Component.m_237115_((String)"tooltip.forbidden_arcanus.entity").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_())).toString()));
            if (this.getEntityName(stack) != null) {
                textComponent.m_130946_(" (").m_7220_(Objects.requireNonNull(this.getEntityName(stack))).m_130946_(")");
            }
            textComponent.m_130940_(ChatFormatting.GRAY);
            tooltip.add((Component)textComponent);
        }
    }

    private void setEntity(Entity entity, ItemStack stack) {
        entity.m_8127_();
        entity.m_20153_();
        CompoundTag entityTag = new CompoundTag();
        ResourceLocation name = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (name == null) {
            return;
        }
        entityTag.m_128359_("entity", name.toString());
        if (entity.m_8077_()) {
            entityTag.m_128359_("name", Objects.requireNonNull(entity.m_7770_()).getString());
        }
        entity.m_20223_(entityTag);
        CompoundTag itemNBT = stack.m_41784_();
        itemNBT.m_128365_("entity", (Tag)entityTag);
    }

    private Entity getEntity(ItemStack stack, Level level) {
        CompoundTag itemTag = stack.m_41783_();
        if (itemTag == null) {
            return null;
        }
        CompoundTag entityTag = itemTag.m_128469_("entity");
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(entityTag.m_128461_("entity")));
        if (entityType == null) {
            return null;
        }
        Entity entity = entityType.m_20615_(level);
        if (level instanceof ServerLevel && entity != null) {
            entity.m_20258_(entityTag);
        }
        return entity;
    }

    private Component getEntityName(ItemStack stack) {
        CompoundTag entityTag;
        CompoundTag itemTag = stack.m_41783_();
        if (itemTag == null) {
            return null;
        }
        if (itemTag.m_128441_("entity") && (entityTag = itemTag.m_128469_("entity")).m_128441_("name")) {
            return Component.m_237113_((String)entityTag.m_128461_("name"));
        }
        return null;
    }

    private void clearEntity(ItemStack stack) {
        stack.m_41751_(null);
    }
}

