/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item;

import com.google.common.collect.ImmutableList;
import com.stal111.forbidden_arcanus.client.renderer.item.ObsidianSkullItemRenderer;
import com.stal111.forbidden_arcanus.common.item.counter.ObsidianSkullCounter;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockSource;
import net.minecraft.core.NonNullList;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.NonNullLazy;
import net.valhelsia.valhelsia_core.common.capability.counter.CounterCapability;
import net.valhelsia.valhelsia_core.common.capability.counter.CounterCreator;
import net.valhelsia.valhelsia_core.common.capability.counter.CounterImpl;
import net.valhelsia.valhelsia_core.common.capability.counter.CounterProvider;
import net.valhelsia.valhelsia_core.common.capability.counter.SimpleCounter;

public class ObsidianSkullItem
extends StandingAndWallBlockItem {
    public static final int OBSIDIAN_SKULL_PROTECTION_TIME = 600;
    private static final ResourceLocation COUNTER = new ResourceLocation("forbidden_arcanus", "tick_counter");
    public static final List<DamageSource> DAMAGE_SOURCES = ImmutableList.of((Object)DamageSource.f_19308_, (Object)DamageSource.f_19305_, (Object)DamageSource.f_19307_, (Object)DamageSource.f_19309_);
    private final boolean eternal;

    public ObsidianSkullItem(Block floorBlock, Block wallBlock, boolean eternal, Item.Properties properties) {
        super(floorBlock, wallBlock, properties);
        this.eternal = eternal;
    }

    public static DispenseItemBehavior getDispenseBehavior() {
        return new OptionalDispenseItemBehavior(){

            @Nonnull
            protected ItemStack m_7498_(@Nonnull BlockSource source, @Nonnull ItemStack stack) {
                this.m_123573_(ArmorItem.m_40398_((BlockSource)source, (ItemStack)stack));
                return stack;
            }
        };
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }

    public void m_6883_(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!this.eternal) {
                stack.getCapability(CounterProvider.CAPABILITY).ifPresent(counterCapability -> {
                    CompoundTag tag = new CompoundTag();
                    if (livingEntity.m_21225_() != null) {
                        tag.m_128359_("DamageSource", livingEntity.m_21225_().m_19385_());
                    }
                    this.getCounter((CounterCapability)counterCapability).tick(tag);
                });
            }
        }
        super.m_6883_(stack, level, entity, itemSlot, isSelected);
    }

    public static boolean shouldProtectFromDamage(DamageSource damageSource, Inventory inventory) {
        if (!DAMAGE_SOURCES.contains(damageSource)) {
            return false;
        }
        if (inventory.m_36063_(ModItems.Stacks.ETERNAL_OBSIDIAN_SKULL)) {
            return true;
        }
        ItemStack stack = ObsidianSkullItem.getSkullWithLowestCounter(inventory);
        if (stack.m_41619_()) {
            return false;
        }
        return ObsidianSkullItem.getCounterValue(stack) < 600;
    }

    public static ItemStack getSkullWithLowestCounter(Inventory inventory) {
        ItemStack skull = ItemStack.f_41583_;
        for (NonNullList nonNullList : inventory.f_35979_) {
            for (ItemStack stack : nonNullList) {
                if (stack.m_41619_() || !stack.m_150930_((Item)ModItems.OBSIDIAN_SKULL.get()) || !skull.m_41619_() && ObsidianSkullItem.getCounterValue(skull) <= ObsidianSkullItem.getCounterValue(stack)) continue;
                skull = stack;
            }
        }
        return skull;
    }

    public static int getCounterValue(ItemStack stack) {
        return ((CounterCapability)stack.getCapability(CounterProvider.CAPABILITY).orElse((Object)new CounterImpl())).getCounter(COUNTER).getValue();
    }

    public void m_7373_(@Nonnull ItemStack stack, Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)("tooltip.forbidden_arcanus" + (this.eternal ? ".eternal_" : ".") + "obsidian_skull")).m_130940_(ChatFormatting.GRAY));
    }

    public void initializeClient(@Nonnull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private final NonNullLazy<BlockEntityWithoutLevelRenderer> renderer = NonNullLazy.of(() -> new ObsidianSkullItemRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.renderer.get();
            }
        });
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag tag) {
        if (!this.eternal) {
            return new CounterProvider(CounterCreator.of(ObsidianSkullCounter::new, (ResourceLocation)COUNTER));
        }
        return null;
    }

    private SimpleCounter getCounter(CounterCapability counterCapability) {
        return counterCapability.getCounter(COUNTER);
    }
}

