/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.integration;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.Ritual;
import com.stal111.forbidden_arcanus.common.integration.ForbiddenArcanusJEIPlugin;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class HephaestusSmithingCategory
implements IRecipeCategory<Ritual> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("forbidden_arcanus", "textures/gui/container/hephaestus_forge_jei.png");
    private static final List<Pair<Integer, Integer>> INPUT_POSITIONS = List.of(new Pair((Object)63, (Object)12), new Pair((Object)85, (Object)24), new Pair((Object)85, (Object)48), new Pair((Object)63, (Object)58), new Pair((Object)41, (Object)48), new Pair((Object)41, (Object)24));
    private static final Pair<Integer, Integer> FORGE_ITEM_POSITION = new Pair((Object)63, (Object)35);
    private static final Pair<Integer, Integer> OUTPUT_POSITION = new Pair((Object)121, (Object)36);
    private static final Pair<Integer, Integer> PEDESTAL_TYPE_POSITION = new Pair((Object)123, (Object)85);
    private final IDrawable background;
    private final IDrawable icon;
    private final List<EssenceInfo> essences;

    public HephaestusSmithingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 147, 107);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.HEPHAESTUS_FORGE.get()));
        this.essences = List.of(new EssenceInfo(guiHelper.createDrawable(TEXTURE, 161, 1, 10, 10), "Aureal", 42, 79), new EssenceInfo(guiHelper.createDrawable(TEXTURE, 173, 1, 10, 10), "Souls", 58, 79), new EssenceInfo(guiHelper.createDrawable(TEXTURE, 185, 1, 10, 10), "Blood", 74, 79), new EssenceInfo(guiHelper.createDrawable(TEXTURE, 197, 1, 10, 10), "Experience", 90, 79));
    }

    @Nonnull
    public RecipeType<Ritual> getRecipeType() {
        return ForbiddenArcanusJEIPlugin.HEPHAESTUS_SMITHING;
    }

    @Nonnull
    public Component getTitle() {
        return Component.m_237115_((String)"jei.forbidden_arcanus.category.hephaestusSmithing");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull Ritual recipe, @Nonnull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, ((Integer)FORGE_ITEM_POSITION.getFirst()).intValue(), ((Integer)FORGE_ITEM_POSITION.getSecond()).intValue()).addItemStack(recipe.getHephaestusForgeItem());
        for (int i = 0; i < 6; ++i) {
            Ingredient ingredient = recipe.getInput(i);
            if (ingredient == null) continue;
            builder.addSlot(RecipeIngredientRole.INPUT, ((Integer)INPUT_POSITIONS.get(i).getFirst()).intValue(), ((Integer)INPUT_POSITIONS.get(i).getSecond()).intValue()).addIngredients(ingredient);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, ((Integer)OUTPUT_POSITION.getFirst()).intValue(), ((Integer)OUTPUT_POSITION.getSecond()).intValue()).addItemStack(recipe.getResult());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, ((Integer)PEDESTAL_TYPE_POSITION.getFirst()).intValue(), ((Integer)PEDESTAL_TYPE_POSITION.getSecond()).intValue()).addItemStack(new ItemStack((ItemLike)recipe.getPedestalType().getBlock()))).addTooltipCallback((recipeSlotView, tooltip) -> {
            tooltip.clear();
            tooltip.add(Component.m_237115_((String)"jei.forbidden_arcanus.hephaestusSmithing.requiredPedestal").m_130946_(": ").m_7220_((Component)recipe.getPedestalType().getBlock().m_49954_()));
            tooltip.add(Component.m_237115_((String)"jei.forbidden_arcanus.hephaestusSmithing.requiredLevel").m_130946_(": 1"));
        });
    }

    public void draw(@Nonnull Ritual recipe, @Nonnull IRecipeSlotsView slotsView, @Nonnull PoseStack poseStack, double mouseX, double mouseY) {
        this.essences.forEach(essenceInfo -> essenceInfo.drawable().draw(poseStack, essenceInfo.posX(), essenceInfo.posY()));
    }

    @Nonnull
    public List<Component> getTooltipStrings(@Nonnull Ritual recipe, @Nonnull IRecipeSlotsView slotsView, double mouseX, double mouseY) {
        for (EssenceInfo essenceInfo : this.essences) {
            int posX = essenceInfo.posX();
            int posY = essenceInfo.posY();
            if (!(mouseX >= (double)posX) || !(mouseY >= (double)posY) || !(mouseX <= (double)(posX + 10)) || !(mouseY <= (double)(posY + 10))) continue;
            return Collections.singletonList(Component.m_237115_((String)("jei.forbidden_arcanus.hephaestusSmithing.required" + essenceInfo.name())).m_130946_(": " + recipe.getEssences().getFromName(essenceInfo.name())));
        }
        return Collections.emptyList();
    }

    private record EssenceInfo(IDrawableStatic drawable, String name, int posX, int posY) {
    }
}

