/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.entity.projectile;

import com.stal111.forbidden_arcanus.common.aureal.AurealHelper;
import com.stal111.forbidden_arcanus.common.entity.lostsoul.LostSoul;
import com.stal111.forbidden_arcanus.common.network.NetworkHandler;
import com.stal111.forbidden_arcanus.common.network.clientbound.AddThrownAurealBottleParticle;
import com.stal111.forbidden_arcanus.core.init.ModEntities;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;

public class ThrownAurealBottle
extends ThrowableItemProjectile {
    public ThrownAurealBottle(EntityType<? extends ThrownAurealBottle> entityType, Level level) {
        super(entityType, level);
    }

    public ThrownAurealBottle(Level level, LivingEntity shooter) {
        super((EntityType)ModEntities.AUREAL_BOTTLE.get(), shooter, level);
    }

    protected float m_7139_() {
        return 0.055f;
    }

    @Nonnull
    protected Item m_7881_() {
        return (Item)ModItems.SPLASH_AUREAL_BOTTLE.get();
    }

    protected void m_6532_(@Nonnull HitResult result) {
        super.m_6532_(result);
        if (!this.f_19853_.m_5776_()) {
            this.applySplash();
            NetworkHandler.sentToTrackingChunk(this.f_19853_.m_46745_(this.m_20183_()), new AddThrownAurealBottleParticle(this.m_20185_(), this.m_20186_(), this.m_20189_()));
            this.m_146870_();
        }
    }

    private void applySplash() {
        AABB aabb = this.m_20191_().m_82377_(4.0, 2.0, 4.0);
        List list = this.f_19853_.m_45976_(LivingEntity.class, aabb);
        if (list.isEmpty()) {
            return;
        }
        for (LivingEntity entity : list) {
            double distance = this.m_20280_((Entity)entity);
            if (!(distance < 16.0)) continue;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                AurealHelper.increaseAureal(player, 30);
            }
            if (AurealHelper.canEntityBeAureal(entity) && !entity.getPersistentData().m_128471_("aureal")) {
                entity.getPersistentData().m_128379_("aureal", true);
            }
            if (!(entity instanceof LostSoul)) continue;
            LostSoul lostSoul = (LostSoul)entity;
            LostSoul.Variant variant = lostSoul.getVariant();
            if (variant == LostSoul.Variant.CORRUPT_LOST_SOUL) {
                lostSoul.setVariant(LostSoul.Variant.LOST_SOUL);
                continue;
            }
            lostSoul.setVariant(LostSoul.Variant.ENCHANTED_LOST_SOUL);
        }
    }
}

