/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge.ritual;

import com.stal111.forbidden_arcanus.common.block.entity.forge.HephaestusForgeBlockEntity;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.RitualEssences;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;

public class Ritual {
    private final ResourceLocation name;
    private final Map<Integer, Ingredient> inputs;
    private final ItemStack hephaestusForgeItem;
    private final ItemStack result;
    private final RitualEssences essences;
    private final ResourceLocation outerTexture;
    private final ResourceLocation innerTexture;
    private final PedestalType pedestalType;
    private final int time;

    public Ritual(ResourceLocation name, Map<Integer, Ingredient> inputs, ItemStack hephaestusForgeItem, ItemStack result, RitualEssences essences, ResourceLocation outerTexture, ResourceLocation innerTexture, int time) {
        this.name = name;
        this.inputs = inputs;
        this.hephaestusForgeItem = hephaestusForgeItem;
        this.result = result;
        this.essences = essences;
        this.outerTexture = outerTexture;
        this.innerTexture = innerTexture;
        this.pedestalType = PedestalType.DARKSTONE_PEDESTAL;
        this.time = time;
    }

    public boolean canStart(List<ItemStack> inputs, HephaestusForgeBlockEntity blockEntity) {
        if (!this.getEssences().checkEssences(blockEntity)) {
            return false;
        }
        return this.checkIngredients(inputs, blockEntity);
    }

    public boolean checkIngredients(List<ItemStack> list, HephaestusForgeBlockEntity blockEntity) {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>(list);
        for (Ingredient ingredient : this.getInputs()) {
            boolean foundStack = false;
            for (ItemStack input : ingredients) {
                if (!ingredient.test(input)) continue;
                ingredients.remove(input);
                foundStack = true;
                break;
            }
            if (foundStack) continue;
            return false;
        }
        ItemStack stack = blockEntity.m_8020_(4);
        if (!ingredients.isEmpty()) {
            return false;
        }
        return this.getHephaestusForgeItem().m_41619_() ? stack.m_41619_() : this.getHephaestusForgeItem().equals(stack, false);
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public Ingredient getInput(int slot) {
        return this.inputs.get(slot);
    }

    public List<Ingredient> getInputs() {
        return new ArrayList<Ingredient>(this.inputs.values());
    }

    public ItemStack getHephaestusForgeItem() {
        return this.hephaestusForgeItem;
    }

    public ItemStack getResult() {
        return this.result.m_41777_();
    }

    public RitualEssences getEssences() {
        return this.essences;
    }

    public ResourceLocation getOuterTexture() {
        return this.outerTexture;
    }

    public ResourceLocation getInnerTexture() {
        return this.innerTexture;
    }

    public PedestalType getPedestalType() {
        return this.pedestalType;
    }

    public int getTime() {
        return this.time;
    }

    public void serializeToNetwork(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.name);
        buffer.m_236831_(this.inputs, FriendlyByteBuf::m_130130_, (friendlyByteBuf, ingredient) -> ingredient.m_43923_(friendlyByteBuf));
        buffer.m_130055_(this.hephaestusForgeItem);
        buffer.m_130055_(this.result);
        this.essences.serializeToNetwork(buffer);
        buffer.m_130085_(this.outerTexture);
        buffer.m_130085_(this.innerTexture);
        buffer.m_130130_(this.time);
    }

    public static Ritual fromNetwork(FriendlyByteBuf buffer) {
        ResourceLocation name = buffer.m_130281_();
        Map inputs = buffer.m_236847_(FriendlyByteBuf::m_130242_, Ingredient::m_43940_);
        ItemStack hephaestusForgeItem = buffer.m_130267_();
        ItemStack result = buffer.m_130267_();
        RitualEssences essences = RitualEssences.fromNetwork(buffer);
        ResourceLocation outerTexture = buffer.m_130281_();
        ResourceLocation innerTexture = buffer.m_130281_();
        int time = buffer.m_130242_();
        return new Ritual(name, inputs, hephaestusForgeItem, result, essences, outerTexture, innerTexture, time);
    }

    public static enum PedestalType {
        DARKSTONE_PEDESTAL((Block)ModBlocks.DARKSTONE_PEDESTAL.get()),
        ARCANE_DARKSTONE_PEDESTAL((Block)ModBlocks.ARCANE_DARKSTONE_PEDESTAL.get());

        private final Block block;

        private PedestalType(Block block) {
            this.block = block;
        }

        public Block getBlock() {
            return this.block;
        }
    }
}

