/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge.ritual;

import com.stal111.forbidden_arcanus.common.block.entity.forge.HephaestusForgeBlockEntity;
import com.stal111.forbidden_arcanus.common.block.entity.forge.HephaestusForgeLevel;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.valhelsia.valhelsia_core.common.util.NeedsStoring;

public class EssenceManager
implements NeedsStoring {
    private final HephaestusForgeBlockEntity blockEntity;
    private int aureal = 0;
    private int corruption = 0;
    private int souls = 0;
    private int blood = 0;
    private int experience = 0;
    private final Map<LivingEntity, Float> cachedHealth = new HashMap<LivingEntity, Float>();

    public EssenceManager(HephaestusForgeBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    public HephaestusForgeBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public HephaestusForgeLevel getLevel() {
        return this.getBlockEntity().getForgeLevel();
    }

    public int getAureal() {
        return this.aureal;
    }

    public void setAureal(int aureal) {
        this.aureal = aureal;
    }

    public void increaseAureal(int aureal) {
        if (this.getAureal() + aureal >= this.getLevel().getMaxAureal()) {
            this.setAureal(this.getLevel().getMaxAureal());
            return;
        }
        this.setAureal(this.getAureal() + aureal);
    }

    public void decreaseAureal(int aureal) {
        this.setAureal(Math.max(this.getAureal() - aureal, 0));
    }

    public int getCorruption() {
        return this.corruption;
    }

    public void setCorruption(int corruption) {
        this.corruption = corruption;
    }

    public void increaseCorruption(int corruption) {
        if (this.getCorruption() + corruption >= this.getLevel().getMaxCorruption()) {
            this.setCorruption(this.getLevel().getMaxCorruption());
            return;
        }
        this.setCorruption(this.getCorruption() + corruption);
    }

    public void decreaseCorruption(int corruption) {
        this.setCorruption(Math.max(this.getCorruption() - corruption, 0));
    }

    public int getSouls() {
        return this.souls;
    }

    public void setSouls(int souls) {
        this.souls = souls;
    }

    public void increaseSouls(int souls) {
        if (this.getSouls() + souls >= this.getLevel().getMaxSouls()) {
            this.setSouls(this.getLevel().getMaxSouls());
            return;
        }
        this.setSouls(this.getSouls() + souls);
    }

    public void decreaseSouls(int souls) {
        this.setSouls(Math.max(this.getSouls() - souls, 0));
    }

    public int getBlood() {
        return this.blood;
    }

    public void setBlood(int blood) {
        this.blood = blood;
    }

    public void increaseBlood(int blood) {
        if (this.getBlood() + blood >= this.getLevel().getMaxBlood()) {
            this.setBlood(this.getLevel().getMaxBlood());
            return;
        }
        this.setBlood(this.getBlood() + blood);
    }

    public void decreaseBlood(int blood) {
        this.setBlood(Math.max(this.getBlood() - blood, 0));
    }

    public int getExperience() {
        return this.experience;
    }

    public void setExperience(int experience) {
        this.experience = experience;
    }

    public void increaseExperience(int experience) {
        if (this.getExperience() + experience >= this.getLevel().getMaxExperience()) {
            this.setExperience(this.getLevel().getMaxExperience());
            return;
        }
        this.setExperience(this.getExperience() + experience);
    }

    public void decreaseExperience(int experience) {
        this.setExperience(Math.max(this.getExperience() - experience, 0));
    }

    public CompoundTag save(CompoundTag tag) {
        tag.m_128405_("Aureal", this.getAureal());
        tag.m_128405_("Corruption", this.getCorruption());
        tag.m_128405_("Souls", this.getSouls());
        tag.m_128405_("Blood", this.getBlood());
        tag.m_128405_("Experience", this.getExperience());
        return tag;
    }

    public void load(CompoundTag tag) {
        this.setAureal(tag.m_128451_("Aureal"));
        this.setCorruption(tag.m_128451_("Corruption"));
        this.setSouls(tag.m_128451_("Souls"));
        this.setBlood(tag.m_128451_("Blood"));
        this.setExperience(tag.m_128451_("Experience"));
    }

    public void tick() {
        for (LivingEntity entity : this.blockEntity.getEntities()) {
            float healthDifference;
            if (!this.cachedHealth.containsKey(entity) || !((healthDifference = this.cachedHealth.get(entity).floatValue() - entity.m_21223_()) > 0.0f)) continue;
            this.increaseBlood((int)healthDifference * 20);
        }
        this.cachedHealth.clear();
        for (LivingEntity entity : this.blockEntity.getEntities()) {
            this.cachedHealth.put(entity, Float.valueOf(entity.m_21223_()));
        }
    }
}

