/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity;

import com.stal111.forbidden_arcanus.common.network.NetworkHandler;
import com.stal111.forbidden_arcanus.common.network.clientbound.UpdatePedestalPacket;
import com.stal111.forbidden_arcanus.core.init.ModBlockEntities;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class PedestalBlockEntity
extends BlockEntity {
    private static final int DEFAULT_ITEM_HEIGHT = 120;
    private ItemStack stack = ItemStack.f_41583_;
    private final float hoverStart = (float)(Math.random() * Math.PI * 2.0);
    private int ticksExisted;
    private int itemHeight = 120;

    public PedestalBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.PEDESTAL.get(), pos, state);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, PedestalBlockEntity blockEntity) {
        ++blockEntity.ticksExisted;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public void setStackAndSync(ItemStack stack, Level level, BlockPos pos) {
        this.stack = stack;
        if (!level.m_5776_()) {
            NetworkHandler.sentToTrackingChunk(level.m_46745_(pos), new UpdatePedestalPacket(pos, stack, this.itemHeight));
        }
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean hasStack() {
        return !this.stack.m_41619_();
    }

    public void clearStack(Level level, BlockPos pos) {
        this.setItemHeight(120);
        this.setStackAndSync(ItemStack.f_41583_, level, pos);
    }

    public float getItemHover(float partialTicks) {
        return ((float)this.ticksExisted + partialTicks) / 20.0f + this.hoverStart;
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public void setItemHeight(int itemHeight) {
        this.itemHeight = itemHeight;
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("Stack")) {
            this.stack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Stack"));
            this.itemHeight = compound.m_128451_("ItemHeight");
        }
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        if (this.stack != ItemStack.f_41583_) {
            compound.m_128365_("Stack", (Tag)this.stack.m_41739_(new CompoundTag()));
            compound.m_128405_("ItemHeight", this.itemHeight);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82363_(0.0, 1.0, 0.0);
    }
}

