/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.augment;

import com.blakebr0.cucumber.helper.BlockHelper;
import com.blakebr0.cucumber.helper.ColorHelper;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class MiningAOEAugment
extends Augment {
    private final int range;

    public MiningAOEAugment(ResourceLocation id, int tier, int range) {
        super(id, tier, EnumSet.of(AugmentType.PICKAXE, AugmentType.AXE, AugmentType.SHOVEL), MiningAOEAugment.getColor(14024694, tier), MiningAOEAugment.getColor(965309, tier));
        this.range = range;
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        Level level = player.m_20193_();
        BlockHitResult trace = BlockHelper.rayTraceBlocks((Level)level, (Player)player);
        int side = trace.m_82434_().ordinal();
        return MiningAOEAugment.harvest(stack, this.range, level, pos, side, player);
    }

    private static boolean harvest(ItemStack stack, int radius, Level level, BlockPos pos, int side, Player player) {
        if (level.m_5776_()) {
            return true;
        }
        if (player.m_6144_()) {
            radius = 0;
        }
        int xRange = radius;
        int yRange = radius;
        int zRange = 0;
        if (side == 0 || side == 1) {
            zRange = radius;
            yRange = 0;
        }
        if (side == 4 || side == 5) {
            xRange = 0;
            zRange = radius;
        }
        BlockState state = level.m_8055_(pos);
        float hardness = state.m_60800_((BlockGetter)level, pos);
        BlockHelper.harvestBlock((ItemStack)stack, (Level)level, (ServerPlayer)((ServerPlayer)player), (BlockPos)pos);
        if (radius > 0 && hardness >= 0.2f && MiningAOEAugment.canHarvestBlock(stack, state)) {
            BlockPos.m_121990_((BlockPos)pos.m_7918_(-xRange, -yRange, -zRange), (BlockPos)pos.m_7918_(xRange, yRange, zRange)).forEach(aoePos -> {
                BlockState aoeState;
                if (aoePos != pos && MiningAOEAugment.canHarvestBlock(stack, aoeState = level.m_8055_(aoePos)) && level.m_7702_(aoePos) == null && aoeState.m_60800_((BlockGetter)level, aoePos) <= hardness + 5.0f) {
                    BlockHelper.harvestAOEBlock((ItemStack)stack, (Level)level, (ServerPlayer)((ServerPlayer)player), (BlockPos)aoePos.m_7949_());
                }
            });
        }
        return true;
    }

    private static boolean canHarvestBlock(ItemStack stack, BlockState state) {
        return stack.m_41735_(state) || !state.m_60834_() && stack.m_41691_(state) > 1.0f;
    }

    private static int getColor(int color, int tier) {
        return ColorHelper.saturate((int)color, (float)Math.min((float)tier / 5.0f, 1.0f));
    }
}

