/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.api.tool.ITeslaEntity;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.network.MessageBlockEntitySync;
import blusunrize.immersiveengineering.common.register.IEPotions;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.network.PacketDistributor;

public class TeslaCoilBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEClientTickableBE,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IScrewdriverInteraction,
IModelOffsetProvider {
    public MutableEnergyStorage energyStorage = new MutableEnergyStorage(48000);
    private final MultiblockCapability<IEnergyStorage> energyCap = MultiblockCapability.make(this, be -> be.energyCap, TeslaCoilBlockEntity::master, this.registerEnergyInput(this.energyStorage));
    public boolean redstoneControlInverted = false;
    public boolean lowPower = false;
    public final List<LightningAnimation> effectMap = new ArrayList<LightningAnimation>();
    private static final IElectricEquipment.ElectricSource TC_FIELD = new IElectricEquipment.ElectricSource(-1.0f);
    AABB renderBB;

    public TeslaCoilBlockEntity(BlockEntityType<TeslaCoilBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tickClient() {
        this.effectMap.removeIf(LightningAnimation::tick);
    }

    @Override
    public void tickServer() {
        int timeKey = this.m_58899_().m_123341_() ^ this.m_58899_().m_123343_();
        int energyDrain = (Integer)IEServerConfig.MACHINES.teslacoil_consumption.get();
        if (this.lowPower) {
            energyDrain /= 2;
        }
        if (this.f_58857_.m_46467_() % 32L == (long)(timeKey & 0x1F) && this.canRun(energyDrain)) {
            this.energyStorage.extractEnergy(energyDrain, false);
            double radius = 6.0;
            if (this.lowPower) {
                radius /= 2.0;
            }
            AABB aabbSmall = new AABB((double)this.m_58899_().m_123341_() + 0.5 - radius, (double)this.m_58899_().m_123342_() + 0.5 - radius, (double)this.m_58899_().m_123343_() + 0.5 - radius, (double)this.m_58899_().m_123341_() + 0.5 + radius, (double)this.m_58899_().m_123342_() + 0.5 + radius, (double)this.m_58899_().m_123343_() + 0.5 + radius);
            AABB aabb = aabbSmall.m_82400_(radius / 2.0);
            List targetsAll = this.f_58857_.m_45976_(Entity.class, aabb);
            List targets = targetsAll.stream().filter(e -> e instanceof LivingEntity && aabbSmall.m_82381_(e.m_20191_())).collect(Collectors.toList());
            LivingEntity target = null;
            if (!targets.isEmpty()) {
                IEDamageSources.ElectricDamageSource dmgsrc = IEDamageSources.causeTeslaDamage(((Double)IEServerConfig.MACHINES.teslacoil_damage.get()).floatValue(), this.lowPower);
                int randomTarget = ApiUtils.RANDOM.nextInt(targets.size());
                target = (LivingEntity)targets.get(randomTarget);
                if (target != null && !this.f_58857_.f_46443_) {
                    energyDrain = (Integer)IEServerConfig.MACHINES.teslacoil_consumption_active.get();
                    if (this.lowPower) {
                        energyDrain /= 2;
                    }
                    if (this.energyStorage.extractEnergy(energyDrain, true) == energyDrain) {
                        this.energyStorage.extractEnergy(energyDrain, false);
                        target.m_7292_(new MobEffectInstance((MobEffect)IEPotions.STUNNED.get(), 128));
                        if (dmgsrc.apply((Entity)target)) {
                            int prevFire = target.m_20094_();
                            target.m_7311_(1);
                            target.m_7311_(prevFire);
                        }
                        this.sendRenderPacket((Entity)target);
                    }
                }
            }
            for (Entity e2 : targetsAll) {
                if (e2 == target) continue;
                if (e2 instanceof ITeslaEntity) {
                    ((ITeslaEntity)e2).onHit(this, this.lowPower);
                    continue;
                }
                if (!(e2 instanceof LivingEntity)) continue;
                IElectricEquipment.applyToEntity((LivingEntity)e2, null, TC_FIELD);
            }
            if (targets.isEmpty() && this.f_58857_.m_46467_() % 128L == (long)(timeKey & 0x7F)) {
                BlockState state;
                VoxelShape shape;
                double tV = (ApiUtils.RANDOM.nextDouble() - 0.5) * 8.0;
                double tH = (ApiUtils.RANDOM.nextDouble() - 0.5) * 8.0;
                if (this.lowPower) {
                    tV /= 2.0;
                    tH /= 2.0;
                }
                BlockPos targetBlock = this.m_58899_().m_7637_(this.getFacing().m_122434_() == Direction.Axis.X ? 0.0 : (tH += tH < 0.0 ? -2.0 : 2.0), this.getFacing().m_122434_() == Direction.Axis.Y ? 0.0 : (tV += tV < 0.0 ? -2.0 : 2.0), this.getFacing().m_122434_() == Direction.Axis.Y ? tV : (this.getFacing().m_122434_() == Direction.Axis.X ? tH : 0.0));
                double tL = 0.0;
                boolean targetFound = false;
                if (!this.f_58857_.m_46859_(targetBlock) && !(shape = (state = this.f_58857_.m_8055_(targetBlock)).m_60808_((BlockGetter)this.f_58857_, targetBlock)).m_83281_()) {
                    AABB blockBounds = shape.m_83215_();
                    tL = this.getFacing() == Direction.UP ? (double)(targetBlock.m_123342_() - this.m_58899_().m_123342_()) + blockBounds.f_82292_ : (this.getFacing() == Direction.DOWN ? (double)(targetBlock.m_123342_() - this.m_58899_().m_123342_()) + blockBounds.f_82289_ : (this.getFacing() == Direction.NORTH ? (double)(targetBlock.m_123343_() - this.m_58899_().m_123343_()) + blockBounds.f_82290_ : (this.getFacing() == Direction.SOUTH ? (double)(targetBlock.m_123343_() - this.m_58899_().m_123343_()) + blockBounds.f_82293_ : (this.getFacing() == Direction.WEST ? (double)(targetBlock.m_123341_() - this.m_58899_().m_123341_()) + blockBounds.f_82288_ : (double)(targetBlock.m_123341_() - this.m_58899_().m_123341_()) + blockBounds.f_82291_))));
                    targetFound = true;
                }
                if (!targetFound) {
                    boolean positiveFirst = ApiUtils.RANDOM.nextBoolean();
                    for (int i = 0; i < 2; ++i) {
                        for (int ll = 0; ll <= 6; ++ll) {
                            Direction tempF;
                            BlockState state2;
                            VoxelShape shape2;
                            BlockPos targetBlock2 = targetBlock.m_5484_(positiveFirst ? this.getFacing() : this.getFacing().m_122424_(), ll);
                            if (this.f_58857_.m_46859_(targetBlock2) || (shape2 = (state2 = this.f_58857_.m_8055_(targetBlock2)).m_60808_((BlockGetter)this.f_58857_, targetBlock2)).m_83281_()) continue;
                            AABB blockBounds = shape2.m_83215_();
                            tL = this.getFacing().m_122434_() == Direction.Axis.Y ? (double)(targetBlock2.m_123342_() - this.m_58899_().m_123342_()) : (this.getFacing().m_122434_() == Direction.Axis.Z ? (double)(targetBlock2.m_123343_() - this.m_58899_().m_123343_()) : (double)(targetBlock2.m_123343_() - this.m_58899_().m_123343_()));
                            Direction direction = tempF = positiveFirst ? this.getFacing() : this.getFacing().m_122424_();
                            tL = tempF == Direction.UP ? (tL += blockBounds.f_82292_) : (tempF == Direction.DOWN ? (tL += blockBounds.f_82289_) : (tempF == Direction.NORTH ? (tL += blockBounds.f_82290_) : (tempF == Direction.SOUTH ? (tL += blockBounds.f_82293_) : (tempF == Direction.WEST ? (tL += blockBounds.f_82288_) : (tL += blockBounds.f_82291_)))));
                            targetFound = true;
                            break;
                        }
                        if (targetFound) break;
                        positiveFirst = !positiveFirst;
                    }
                }
                if (targetFound) {
                    this.sendFreePacket(tL, tH, tV);
                }
            }
            this.m_6596_();
        }
    }

    protected void sendRenderPacket(Entity target) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("targetEntity", target.m_19879_());
        ImmersiveEngineering.packetHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new MessageBlockEntitySync(this, tag));
    }

    protected void sendFreePacket(double tL, double tH, double tV) {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("tL", tL);
        tag.m_128347_("tV", tV);
        tag.m_128347_("tH", tH);
        ImmersiveEngineering.packetHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new MessageBlockEntitySync(this, tag));
    }

    @Override
    public void receiveMessageFromServer(CompoundTag message) {
        if (message.m_128425_("targetEntity", 3)) {
            Entity target = this.f_58857_.m_6815_(message.m_128451_("targetEntity"));
            if (target instanceof LivingEntity) {
                double dx = target.m_20185_() - (double)this.m_58899_().m_123341_();
                double dy = target.m_20186_() - (double)this.m_58899_().m_123342_();
                double dz = target.m_20189_() - (double)this.m_58899_().m_123343_();
                Direction f = this.getFacing().m_122434_() == Direction.Axis.Y ? (Math.abs(dz) > Math.abs(dx) ? (dz < 0.0 ? Direction.NORTH : Direction.SOUTH) : (dx < 0.0 ? Direction.WEST : Direction.EAST)) : (this.getFacing().m_122434_() == Direction.Axis.Z ? (Math.abs(dy) > Math.abs(dx) ? (dy < 0.0 ? Direction.DOWN : Direction.UP) : (dx < 0.0 ? Direction.WEST : Direction.EAST)) : (Math.abs(dy) > Math.abs(dz) ? (dy < 0.0 ? Direction.DOWN : Direction.UP) : (dz < 0.0 ? Direction.NORTH : Direction.SOUTH)));
                double verticalOffset = 1.0 + ApiUtils.RANDOM.nextDouble() * 0.25;
                Vec3 coilPos = Vec3.m_82512_((Vec3i)this.m_58899_());
                coilPos = coilPos.m_82520_((double)this.getFacing().m_122429_() * verticalOffset, (double)this.getFacing().m_122430_() * verticalOffset, (double)this.getFacing().m_122431_() * verticalOffset);
                if (f != null) {
                    coilPos = coilPos.m_82520_((double)f.m_122429_() * 0.375, (double)f.m_122430_() * 0.375, (double)f.m_122431_() * 0.375);
                    f = DirectionUtils.rotateAround(f, this.getFacing().m_122434_());
                    double dShift = (ApiUtils.RANDOM.nextDouble() - 0.5) * 0.75;
                    coilPos = coilPos.m_82520_((double)f.m_122429_() * dShift, (double)f.m_122430_() * dShift, (double)f.m_122431_() * dShift);
                }
                this.addAnimation(new LightningAnimation(coilPos, (LivingEntity)target));
                this.f_58857_.m_7785_(coilPos.f_82479_, coilPos.f_82480_, coilPos.f_82481_, (SoundEvent)IESounds.tesla.get(), SoundSource.BLOCKS, 2.5f, 0.5f + ApiUtils.RANDOM.nextFloat(), true);
            }
        } else if (message.m_128425_("tL", 6)) {
            this.initFreeStreamer(message.m_128459_("tL"), message.m_128459_("tV"), message.m_128459_("tH"));
        }
    }

    public void initFreeStreamer(double tL, double tV, double tH) {
        double ty;
        double tx = this.getFacing().m_122434_() == Direction.Axis.X ? tL : tH;
        double d = ty = this.getFacing().m_122434_() == Direction.Axis.Y ? tL : tV;
        double tz = this.getFacing().m_122434_() == Direction.Axis.Y ? tV : (this.getFacing().m_122434_() == Direction.Axis.X ? tH : tL);
        Direction f = null;
        f = this.getFacing().m_122434_() == Direction.Axis.Y ? (Math.abs(tz) > Math.abs(tx) ? (tz < 0.0 ? Direction.NORTH : Direction.SOUTH) : (tx < 0.0 ? Direction.WEST : Direction.EAST)) : (this.getFacing().m_122434_() == Direction.Axis.Z ? (Math.abs(ty) > Math.abs(tx) ? (ty < 0.0 ? Direction.DOWN : Direction.UP) : (tx < 0.0 ? Direction.WEST : Direction.EAST)) : (Math.abs(ty) > Math.abs(tz) ? (ty < 0.0 ? Direction.DOWN : Direction.UP) : (tz < 0.0 ? Direction.NORTH : Direction.SOUTH)));
        double verticalOffset = 1.0 + ApiUtils.RANDOM.nextDouble() * 0.25;
        Vec3 coilPos = Vec3.m_82512_((Vec3i)this.m_58899_());
        coilPos = coilPos.m_82520_((double)this.getFacing().m_122429_() * verticalOffset, (double)this.getFacing().m_122430_() * verticalOffset, (double)this.getFacing().m_122431_() * verticalOffset);
        coilPos = coilPos.m_82520_((double)f.m_122429_() * 0.375, (double)f.m_122430_() * 0.375, (double)f.m_122431_() * 0.375);
        f = DirectionUtils.rotateAround(f, this.getFacing().m_122434_());
        double dShift = (ApiUtils.RANDOM.nextDouble() - 0.5) * 0.75;
        coilPos = coilPos.m_82520_((double)f.m_122429_() * dShift, (double)f.m_122430_() * dShift, (double)f.m_122431_() * dShift);
        this.addAnimation(new LightningAnimation(coilPos, Vec3.m_82528_((Vec3i)this.m_58899_()).m_82520_(tx, ty, tz)));
        this.f_58857_.m_7785_((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (SoundEvent)IESounds.tesla.get(), SoundSource.BLOCKS, 2.5f, 0.5f + ApiUtils.RANDOM.nextFloat(), true);
    }

    private void addAnimation(LightningAnimation ani) {
        Minecraft.m_91087_().m_18689_(() -> this.effectMap.add(ani));
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        this.redstoneControlInverted = nbt.m_128471_("redstoneInverted");
        this.lowPower = nbt.m_128471_("lowPower");
        EnergyHelper.deserializeFrom(this.energyStorage, nbt);
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        nbt.m_128379_("redstoneInverted", this.redstoneControlInverted);
        nbt.m_128379_("lowPower", this.lowPower);
        EnergyHelper.serializeTo(this.energyStorage, nbt);
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        if (!this.isDummy()) {
            return Shapes.m_83144_();
        }
        switch (this.getFacing()) {
            case DOWN: {
                return Shapes.m_83048_((double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)1.0, (double)0.875);
            }
            case UP: {
                return Shapes.m_83048_((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.875, (double)0.875);
            }
            case NORTH: {
                return Shapes.m_83048_((double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)0.875, (double)1.0);
            }
            case SOUTH: {
                return Shapes.m_83048_((double)0.125, (double)0.125, (double)0.0, (double)0.875, (double)0.875, (double)0.875);
            }
            case WEST: {
                return Shapes.m_83048_((double)0.125, (double)0.125, (double)0.125, (double)1.0, (double)0.875, (double)0.875);
            }
            case EAST: {
                return Shapes.m_83048_((double)0.0, (double)0.125, (double)0.125, (double)0.875, (double)0.875, (double)0.875);
            }
        }
        return Shapes.m_83144_();
    }

    public AABB getRenderBoundingBox() {
        if (this.renderBB == null) {
            this.renderBB = new AABB(this.m_58899_().m_7918_(-8, -8, -8), this.m_58899_().m_7918_(8, 8, 8));
        }
        return this.renderBB;
    }

    @Override
    public InteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (this.isDummy()) {
            BlockEntity te = this.f_58857_.m_7702_(this.m_58899_().m_5484_(this.getFacing(), -1));
            if (te instanceof TeslaCoilBlockEntity) {
                return ((TeslaCoilBlockEntity)te).screwdriverUseSide(side, player, hand, hitVec);
            }
            return InteractionResult.PASS;
        }
        if (!this.f_58857_.f_46443_) {
            if (player.m_6144_()) {
                int energyDrain = (Integer)IEServerConfig.MACHINES.teslacoil_consumption.get();
                if (this.lowPower) {
                    energyDrain /= 2;
                }
                if (this.canRun(energyDrain)) {
                    player.m_6469_(IEDamageSources.causeTeslaPrimaryDamage(), Float.MAX_VALUE);
                } else {
                    this.lowPower = !this.lowPower;
                    player.m_5661_((Component)Component.m_237115_((String)("chat.immersiveengineering.info.tesla." + (this.lowPower ? "lowPower" : "highPower"))), true);
                    this.m_6596_();
                }
            } else {
                this.redstoneControlInverted = !this.redstoneControlInverted;
                player.m_5661_((Component)Component.m_237115_((String)("chat.immersiveengineering.info.rsControl." + (this.redstoneControlInverted ? "invertedOn" : "invertedOff"))), true);
                this.m_6596_();
                this.markContainingBlockForUpdate(null);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.SIDE_CLICKED;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    @Nullable
    public TeslaCoilBlockEntity master() {
        TeslaCoilBlockEntity tc;
        if (!this.isDummy()) {
            return this;
        }
        BlockPos masterPos = this.m_58899_().m_7495_();
        BlockEntity te = Utils.getExistingTileEntity(this.f_58857_, masterPos);
        return te instanceof TeslaCoilBlockEntity ? (tc = (TeslaCoilBlockEntity)te) : null;
    }

    @Override
    public void placeDummies(BlockPlaceContext ctx, BlockState state) {
        this.f_58857_.m_46597_(this.f_58858_.m_121945_(this.getFacing()), (BlockState)state.m_61124_((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true)));
        ((TeslaCoilBlockEntity)this.f_58857_.m_7702_(this.f_58858_.m_121945_(this.getFacing()))).setFacing(this.getFacing());
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        boolean dummy = this.isDummy();
        for (int i = 0; i <= 1; ++i) {
            if (!(this.f_58857_.m_7702_(this.m_58899_().m_5484_(this.getFacing(), dummy ? -1 : 0).m_5484_(this.getFacing(), i)) instanceof TeslaCoilBlockEntity)) continue;
            this.f_58857_.m_7471_(this.m_58899_().m_5484_(this.getFacing(), dummy ? -1 : 0).m_5484_(this.getFacing(), i), false);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!(cap != ForgeCapabilities.ENERGY || side != null && this.isDummy())) {
            return this.energyCap.getAndCast();
        }
        return super.getCapability(cap, side);
    }

    public boolean canRun(int energyDrain) {
        return this.isRSPowered() ^ this.redstoneControlInverted && this.energyStorage.getEnergyStored() >= energyDrain;
    }

    @Override
    public BlockPos getModelOffset(BlockState state, @Nullable Vec3i size) {
        if (this.isDummy()) {
            return new BlockPos(0, 0, -1);
        }
        return BlockPos.f_121853_;
    }

    public static class LightningAnimation {
        public Vec3 startPos;
        public LivingEntity targetEntity;
        public Vec3 targetPos;
        private int lifeTimer = 20;
        private final int ANIMATION_MAX = 4;
        private int animationTimer = 4;
        public List<Vec3> subPoints = new ArrayList<Vec3>();
        private Vec3 prevTarget;

        public LightningAnimation(Vec3 startPos, LivingEntity targetEntity) {
            this.startPos = startPos;
            this.targetEntity = targetEntity;
        }

        public LightningAnimation(Vec3 startPos, Vec3 targetPos) {
            this.startPos = startPos;
            this.targetPos = targetPos;
        }

        public boolean shoudlRecalculateLightning() {
            Vec3 end;
            if (this.subPoints.isEmpty() || this.animationTimer == 0) {
                return true;
            }
            boolean b = false;
            Vec3 vec3 = end = this.targetEntity != null ? this.targetEntity.m_20182_() : this.targetPos;
            if (this.prevTarget != null) {
                b = this.prevTarget.m_82554_(end) > 1.0;
            }
            this.prevTarget = end;
            return b;
        }

        public void createLightning(RandomSource rand) {
            this.subPoints.clear();
            Vec3 end = this.targetEntity != null ? this.targetEntity.m_20182_() : this.targetPos;
            Vec3 dist = end.m_82546_(this.startPos);
            double points = 12.0;
            int i = 0;
            while ((double)i < points) {
                Vec3 sub = this.startPos.m_82520_(dist.f_82479_ / points * (double)i, dist.f_82480_ / points * (double)i, dist.f_82481_ / points * (double)i);
                double fixPointDist = ((double)i - points / 2.0) / (points / 2.0);
                double mod = 1.0 - 0.75 * Math.abs(fixPointDist);
                double offX = (rand.m_188500_() - 0.5) * mod;
                double offY = (rand.m_188500_() - 0.5) * mod;
                double offZ = (rand.m_188500_() - 0.5) * mod;
                if (fixPointDist < 0.0) {
                    offY += 0.75 * mod * (0.75 + fixPointDist);
                    offX = sub.f_82479_ - this.startPos.f_82479_ < 0.0 ? -Math.abs(offX) : Math.abs(offX);
                    offZ = sub.f_82481_ - this.startPos.f_82481_ < 0.0 ? -Math.abs(offZ) : Math.abs(offZ);
                } else {
                    offY = Math.min(end.f_82480_ + 1.0 * (1.0 - fixPointDist) * -Math.signum(dist.f_82480_), offY);
                    offX = Math.abs(offX) * (end.f_82479_ - sub.f_82479_);
                    offZ = Math.abs(offZ) * (end.f_82481_ - sub.f_82481_);
                }
                this.subPoints.add(sub.m_82520_(offX, offY, offZ));
                ++i;
            }
            this.animationTimer = 4 + ApiUtils.RANDOM.nextInt(5) - 2;
        }

        public boolean tick() {
            --this.animationTimer;
            --this.lifeTimer;
            return this.lifeTimer <= 0;
        }
    }
}

