/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IIEBlock;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;

public class BlockItemIE
extends BlockItem {
    private int burnTime;

    public BlockItemIE(Block b, Item.Properties props) {
        super(b, props);
    }

    public BlockItemIE(Block b) {
        this(b, new Item.Properties().m_41491_(ImmersiveEngineering.ITEM_GROUP));
    }

    public String m_5671_(ItemStack stack) {
        return this.m_40614_().m_7705_();
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag advanced) {
        FluidStack fs;
        IIEBlock ieBlock;
        Block block = this.m_40614_();
        if (block instanceof IIEBlock && (ieBlock = (IIEBlock)block).hasFlavour()) {
            String flavourKey = "desc.immersiveengineering.flavour." + ieBlock.getNameForFlavour();
            tooltip.add((Component)TextUtils.applyFormat((Component)Component.m_237115_((String)flavourKey), ChatFormatting.GRAY));
        }
        super.m_7373_(stack, world, tooltip, advanced);
        if (ItemNBTHelper.hasKey(stack, "energy")) {
            tooltip.add((Component)TextUtils.applyFormat((Component)Component.m_237110_((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{ItemNBTHelper.getInt(stack, "energy")}), ChatFormatting.GRAY));
        }
        if (ItemNBTHelper.hasKey(stack, "tank") && (fs = FluidStack.loadFluidStackFromNBT((CompoundTag)ItemNBTHelper.getTagCompound(stack, "tank"))) != null) {
            tooltip.add((Component)TextUtils.applyFormat((Component)Component.m_237110_((String)"desc.immersiveengineering.info.fluidStored", (Object[])new Object[]{fs.getDisplayName(), fs.getAmount()}), ChatFormatting.GRAY));
        }
    }

    public BlockItemIE setBurnTime(int burnTime) {
        this.burnTime = burnTime;
        return this;
    }

    public int getBurnTime(ItemStack itemStack, RecipeType<?> type) {
        return this.burnTime;
    }

    protected boolean m_7429_(BlockPlaceContext context, BlockState newState) {
        Block b = newState.m_60734_();
        if (b instanceof IEBaseBlock) {
            IEBaseBlock ieBlock = (IEBaseBlock)b;
            if (!ieBlock.canIEBlockBePlaced(newState, context)) {
                return false;
            }
            boolean ret = super.m_7429_(context, newState);
            if (ret) {
                ieBlock.onIEBlockPlacedBy(context, newState);
            }
            return ret;
        }
        return super.m_7429_(context, newState);
    }

    protected boolean m_7274_(BlockPos pos, Level worldIn, @Nullable Player player, ItemStack stack, BlockState state) {
        if (!state.m_61138_((Property)IEProperties.MULTIBLOCKSLAVE)) {
            return super.m_7274_(pos, worldIn, player, stack, state);
        }
        return false;
    }

    @Nonnull
    public Optional<TooltipComponent> m_142422_(@Nonnull ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41784_()).m_128441_("Items")) {
            ListTag list = tag.m_128437_("Items", 10);
            NonNullList items = NonNullList.m_122779_();
            list.forEach(e -> {
                ItemStack s = ItemStack.m_41712_((CompoundTag)((CompoundTag)e));
                if (!s.m_41619_()) {
                    items.add((Object)s);
                }
            });
            return Optional.of(new BundleTooltip(items, 0));
        }
        return super.m_142422_(stack);
    }

    public boolean m_142095_() {
        IEBaseBlock ieBlock;
        Block block = this.m_40614_();
        return !(block instanceof IEBaseBlock) || (ieBlock = (IEBaseBlock)block).fitsIntoContainer();
    }

    public static class BlockItemIENoInventory
    extends BlockItemIE {
        public BlockItemIENoInventory(Block b) {
            super(b);
        }

        @Nullable
        public CompoundTag getShareTag(ItemStack stack) {
            CompoundTag ret = super.getShareTag(stack);
            if (ret != null) {
                ret = ret.m_6426_();
                ret.m_128473_("Items");
            }
            return ret;
        }
    }
}

