/*
 * Decompiled with CFR 0.152.
 */
package com.prunoideae.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.prunoideae.recipe.BlockRecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeArguments;
import dev.latvian.mods.kubejs.util.ListJS;
import java.util.ArrayList;
import java.util.List;

public class OrechidRecipeJS
extends BlockRecipeJS {
    private int weight = 100;
    private final List<String> biomes = new ArrayList<String>();
    private int biomeBonus = 100;

    @Override
    public void create(RecipeArguments args) {
        super.create(args);
        if (args.size() > 2) {
            this.weight = (int)((Double)args.get(2)).doubleValue();
        }
        if (args.size() > 3) {
            this.biomes.addAll(ListJS.orSelf((Object)args.get(3)).stream().map(String::valueOf).toList());
        }
        if (args.size() > 4) {
            this.biomeBonus = (int)((Double)args.get(4)).doubleValue();
        }
    }

    @Override
    public void deserialize() {
        super.deserialize();
        this.weight = this.json.get("weight").getAsInt();
        if (this.json.has("biomes")) {
            for (JsonElement biome : this.json.get("biomes").getAsJsonArray()) {
                this.biomes.add(biome.getAsString());
            }
        }
        if (this.json.has("biome_bonus")) {
            this.biomeBonus = this.json.get("biome_bonus").getAsInt();
        }
    }

    @Override
    public void serialize() {
        super.serialize();
        this.json.addProperty("weight", (Number)this.weight);
        if (!this.biomes.isEmpty()) {
            JsonArray biomesJS = new JsonArray();
            for (String biome : this.biomes) {
                biomesJS.add(biome);
            }
            this.json.add("biomes", (JsonElement)biomesJS);
            this.json.addProperty("biome_bonus", (Number)this.biomeBonus);
        }
    }
}

