/*
 * Decompiled with CFR 0.152.
 */
package tfar.overpoweredarmorbar.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import tfar.overpoweredarmorbar.Configs;
import tfar.overpoweredarmorbar.overlay.ArmorBar;
import tfar.overpoweredarmorbar.overlay.ArmorIcon;
import tfar.overpoweredarmorbar.overlay.ArmorIconColor;

public class OverlayEventHandler
implements IGuiOverlay {
    private static final int UNKNOWN_ARMOR_VALUE = -1;
    private int previousArmorValue = -1;
    private static final int ARMOR_ICON_SIZE = 9;
    private static final int ARMOR_SECOND_HALF_ICON_SIZE = 4;
    private static final Minecraft mc = Minecraft.m_91087_();
    private ArmorIcon[] armorIcons;

    public static void drawTexturedModalRect(PoseStack stack, int x, int y, int textureX, int textureY, int width, int height) {
        Minecraft.m_91087_().f_91065_.m_93228_(stack, x, y, textureX, textureY, width, height);
    }

    public void render(ForgeGui gui, PoseStack poseStack, float partialTick, int width, int height) {
        if (!gui.getMinecraft().f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
            gui.setupOverlayRenderState(true, false);
            this.renderArmorBar(gui, poseStack, width, height);
        }
    }

    private int calculateArmorValue() {
        int currentArmorValue = OverlayEventHandler.mc.f_91074_.m_21230_();
        return currentArmorValue;
    }

    public void renderArmorBar(ForgeGui gui, PoseStack stack, int screenWidth, int screenHeight) {
        int currentArmorValue = this.calculateArmorValue();
        int xStart = screenWidth / 2 - 91;
        int yPosition = screenHeight - gui.leftHeight;
        if (currentArmorValue != this.previousArmorValue) {
            this.armorIcons = ArmorBar.calculateArmorIcons(currentArmorValue);
            this.previousArmorValue = currentArmorValue;
        }
        int armorIconCounter = 0;
        for (ArmorIcon icon : this.armorIcons) {
            int xPosition = xStart + armorIconCounter * 8;
            switch (icon.armorIconType) {
                case NONE: {
                    ArmorIconColor color = icon.primaryArmorIconColor;
                    OverlayEventHandler.color4f(color.Red, color.Green, color.Blue, color.Alpha);
                    if (currentArmorValue > 20) {
                        OverlayEventHandler.drawTexturedModalRect(stack, xPosition, yPosition, 34, 9, 9, 9);
                        break;
                    }
                    if (!((Boolean)Configs.ClientConfig.showEmptyArmorIcons.get()).booleanValue() || !((Boolean)Configs.ClientConfig.alwaysShowArmorBar.get()).booleanValue() && currentArmorValue <= 0) break;
                    OverlayEventHandler.drawTexturedModalRect(stack, xPosition, yPosition, 16, 9, 9, 9);
                    break;
                }
                case HALF: {
                    ArmorIconColor firstHalfColor = icon.primaryArmorIconColor;
                    ArmorIconColor secondHalfColor = icon.secondaryArmorIconColor;
                    OverlayEventHandler.color4f(firstHalfColor.Red, firstHalfColor.Green, firstHalfColor.Blue, firstHalfColor.Alpha);
                    OverlayEventHandler.drawTexturedModalRect(stack, xPosition, yPosition, 25, 9, 5, 9);
                    OverlayEventHandler.color4f(secondHalfColor.Red, secondHalfColor.Green, secondHalfColor.Blue, secondHalfColor.Alpha);
                    if (currentArmorValue > 20) {
                        OverlayEventHandler.drawTexturedModalRect(stack, xPosition + 5, yPosition, 39, 9, 4, 9);
                        break;
                    }
                    OverlayEventHandler.drawTexturedModalRect(stack, xPosition + 5, yPosition, 30, 9, 4, 9);
                    break;
                }
                case FULL: {
                    ArmorIconColor fullColor = icon.primaryArmorIconColor;
                    OverlayEventHandler.color4f(fullColor.Red, fullColor.Green, fullColor.Blue, fullColor.Alpha);
                    OverlayEventHandler.drawTexturedModalRect(stack, xPosition, yPosition, 34, 9, 9, 9);
                    break;
                }
            }
            ++armorIconCounter;
        }
        OverlayEventHandler.color4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private static void color4f(float r, float g, float b, float a) {
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
    }

    public static void renderOverlay(RenderGuiOverlayEvent.Pre e) {
        if (e.getOverlay().id().equals((Object)VanillaGuiOverlay.ARMOR_LEVEL.id())) {
            e.setCanceled(true);
        }
    }
}

