/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen.widgets;

import com.direwolf20.buildinggadgets.client.screen.widgets.DireButton;
import com.direwolf20.buildinggadgets.client.screen.widgets.GuiTextFieldBase;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class GuiIncrementer
extends AbstractWidget {
    public static final int WIDTH = 64;
    private int x;
    private int y;
    private int min;
    private int max;
    private int value;
    private IIncrementerChanged onChange;
    private DireButton minusButton;
    private GuiTextFieldBase field;
    private DireButton plusButton;

    public GuiIncrementer(int x, int y, int min, int max, @Nullable IIncrementerChanged onChange) {
        super(x, y, 64, 20, (Component)Component.m_237119_());
        this.x = x;
        this.y = y;
        this.min = min;
        this.max = max;
        this.value = 0;
        this.onChange = onChange;
        this.minusButton = new DireButton(this.x, this.y - 1, 12, 17, (Component)Component.m_237113_((String)"-"), button -> this.updateValue(true));
        this.field = new GuiTextFieldBase(Minecraft.m_91087_().f_91062_, x + 13, y, 40).setDefaultInt(this.value).restrictToNumeric();
        this.plusButton = new DireButton(this.x + 40 + 14, this.y - 1, 12, 17, (Component)Component.m_237113_((String)"+"), button -> this.updateValue(false));
        this.field.m_94144_(String.valueOf(this.value));
    }

    public GuiIncrementer(int x, int y) {
        this(x, y, Integer.MIN_VALUE, Integer.MAX_VALUE, null);
    }

    public int getValue() {
        return this.value;
    }

    private void updateValue(boolean isMinus) {
        int modifier = 1;
        if (Screen.m_96638_()) {
            modifier *= 10;
        }
        int value = isMinus ? this.value - modifier : this.value + modifier;
        this.setValue(value);
    }

    public void setValue(int value) {
        if (value == this.value) {
            return;
        }
        this.value = Mth.m_14045_((int)value, (int)this.min, (int)this.max);
        this.field.m_94144_(String.valueOf(this.value));
        if (this.onChange != null) {
            this.onChange.onChange(value);
        }
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float partialTick) {
        this.plusButton.m_6305_(matrices, mouseX, mouseY, partialTick);
        this.minusButton.m_6305_(matrices, mouseX, mouseY, partialTick);
        this.field.m_6305_(matrices, mouseX, mouseY, partialTick);
    }

    public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        this.field.m_6375_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        this.plusButton.m_6375_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        this.minusButton.m_6375_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        return false;
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (!this.field.m_93696_()) {
            return false;
        }
        this.field.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
        return true;
    }

    public boolean m_5534_(char p_charTyped_1_, int p_charTyped_2_) {
        if (!this.field.m_93696_()) {
            return false;
        }
        this.field.m_5534_(p_charTyped_1_, p_charTyped_2_);
        if (this.field.m_94155_().length() > 1 && this.field.m_94155_().charAt(0) == '0') {
            this.field.m_94144_(String.valueOf(this.field.getInt()));
        }
        if (this.field.getInt() > this.max) {
            this.field.m_94144_(String.valueOf(this.max));
        }
        return true;
    }

    protected void m_7207_(boolean isFocused) {
        this.field.m_5755_(isFocused);
        super.m_7207_(isFocused);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }

    public static interface IIncrementerChanged {
        public void onChange(int var1);
    }
}

