/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen;

import com.direwolf20.buildinggadgets.client.screen.MaterialListGUI;
import com.direwolf20.buildinggadgets.client.screen.widgets.EntryList;
import com.direwolf20.buildinggadgets.common.tainted.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.tainted.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.util.lang.ITranslationProvider;
import com.direwolf20.buildinggadgets.common.util.lang.MaterialListTranslation;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

class ScrollingMaterialList
extends EntryList<Entry> {
    private static final int UPDATE_MILLIS = 1000;
    static final int TOP = 16;
    static final int BOTTOM = 32;
    private static final int SLOT_SIZE = 18;
    private static final int MARGIN = 2;
    private static final int ENTRY_HEIGHT;
    private static final int LINE_SIDE_MARGIN = 8;
    private MaterialListGUI gui;
    private SortingModes sortingMode;
    private long lastUpdate;
    private Iterator<ImmutableMultiset<IUniqueObject<?>>> multisetIterator;

    public ScrollingMaterialList(MaterialListGUI gui) {
        super(gui.getWindowLeftX(), gui.getWindowTopY() + 16, gui.getWindowWidth(), gui.getWindowHeight() - 16 - 32, ENTRY_HEIGHT);
        this.gui = gui;
        this.setSortingMode(SortingModes.NAME);
        this.updateEntries();
    }

    private void updateEntries() {
        LocalPlayer player;
        this.lastUpdate = System.currentTimeMillis();
        this.m_93516_();
        if (this.multisetIterator == null || !this.multisetIterator.hasNext()) {
            MaterialList list = this.gui.getHeader().getRequiredItems();
            UnmodifiableIterator unmodifiableIterator = this.multisetIterator = list != null ? list.iterator() : Iterators.singletonIterator((Object)ImmutableMultiset.of());
        }
        if ((player = Minecraft.m_91087_().f_91074_) == null) {
            return;
        }
        IItemIndex index = InventoryHelper.index(this.gui.getTemplateItem(), (Player)player);
        MatchResult result = index.tryMatch((Multiset)this.multisetIterator.next());
        for (Multiset.Entry entry : result.getChosenOption().entrySet()) {
            IUniqueObject item = (IUniqueObject)entry.getElement();
            this.m_7085_((AbstractSelectionList.Entry)new Entry(this, item, entry.getCount(), result.getFoundItems().count(entry.getElement())));
        }
        this.sort();
    }

    protected int m_5756_() {
        return this.getRight() - 2 - 6;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 69) {
            assert (Minecraft.m_91087_().f_91074_ != null);
            Minecraft.m_91087_().f_91074_.m_6915_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float partialTicks) {
        if (this.lastUpdate + 1000L < System.currentTimeMillis()) {
            this.updateEntries();
        }
        super.m_6305_(matrices, mouseX, mouseY, partialTicks);
    }

    public void reset() {
        this.multisetIterator = null;
    }

    public SortingModes getSortingMode() {
        return this.sortingMode;
    }

    public void setSortingMode(SortingModes sortingMode) {
        this.sortingMode = sortingMode;
        this.sort();
    }

    private void sort() {
        this.m_6702_().sort(this.sortingMode.getComparator());
    }

    static {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        ENTRY_HEIGHT = Math.max(22, 9 * 2 + 6);
    }

    static enum SortingModes {
        NAME(Comparator.comparing(Entry::getItemName), MaterialListTranslation.BUTTON_SORTING_NAMEAZ),
        NAME_REVERSED(NAME.getComparator().reversed(), MaterialListTranslation.BUTTON_SORTING_NAMEZA),
        REQUIRED(Comparator.comparingInt(Entry::getRequired), MaterialListTranslation.BUTTON_SORTING_REQUIREDACSE),
        REQUIRED_REVERSED(REQUIRED.getComparator().reversed(), MaterialListTranslation.BUTTON_SORTING_MISSINGDESC),
        MISSING(Comparator.comparingInt(Entry::getMissing), MaterialListTranslation.BUTTON_SORTING_MISSINGACSE),
        MISSING_REVERSED(MISSING.getComparator().reversed(), MaterialListTranslation.BUTTON_SORTING_MISSINGDESC);

        private final Comparator<Entry> comparator;
        private final ITranslationProvider translationProvider;
        public static final SortingModes[] VALUES;

        private SortingModes(Comparator<Entry> comparator, ITranslationProvider provider) {
            this.comparator = comparator;
            this.translationProvider = provider;
        }

        public Comparator<Entry> getComparator() {
            return this.comparator;
        }

        public String getLocalizedName() {
            return this.translationProvider.format(new Object[0]);
        }

        public ITranslationProvider getTranslationProvider() {
            return this.translationProvider;
        }

        public SortingModes next() {
            int nextIndex = this.ordinal() + 1;
            return VALUES[nextIndex >= VALUES.length ? 0 : nextIndex];
        }

        static {
            VALUES = SortingModes.values();
        }
    }

    static class Entry
    extends ObjectSelectionList.Entry<Entry> {
        private ScrollingMaterialList parent;
        private int required;
        private int available;
        private ItemStack stack;
        private String itemName;
        private String amount;
        private int widthItemName;
        private int widthAmount;

        public Entry(ScrollingMaterialList parent, IUniqueObject<?> item, int required, int available) {
            this.parent = parent;
            this.required = required;
            this.available = Mth.m_14045_((int)available, (int)0, (int)required);
            this.stack = item.createStack();
            this.itemName = this.stack.m_41786_().getString();
            this.amount = this.available + "/" + required;
            this.widthItemName = Minecraft.m_91087_().f_91062_.m_92895_(this.itemName);
            this.widthAmount = Minecraft.m_91087_().f_91062_.m_92895_(this.amount);
        }

        public void m_6311_(PoseStack matrices, int index, int topY, int leftX, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float particleTicks) {
            int right = leftX + entryWidth - 4;
            int bottom = topY + entryHeight;
            int slotX = leftX + 2;
            int slotY = topY + 2;
            this.drawIcon(matrices, this.stack, slotX, slotY);
            this.drawTextOverlay(matrices, right, topY, bottom, slotX);
            this.drawHoveringText(this.stack, slotX, slotY, mouseX, mouseY);
        }

        private void drawTextOverlay(PoseStack matrices, int right, int top, int bottom, int slotX) {
            int itemNameX = slotX + 18 + 2;
            MaterialListGUI.renderTextVerticalCenter(matrices, this.itemName, itemNameX, top, bottom, Color.WHITE.getRGB());
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            MaterialListGUI.renderTextHorizontalRight(matrices, this.amount, right, MaterialListGUI.getYForAlignedCenter(top, bottom, 9), this.getTextColor());
            this.drawGuidingLine(right, top, bottom, itemNameX, this.widthItemName, this.widthAmount);
        }

        private void drawGuidingLine(int right, int top, int bottom, int itemNameX, int widthItemName, int widthAmount) {
            if (!this.isSelected()) {
                int lineXStart = itemNameX + widthItemName + 8;
                int lineXEnd = right - widthAmount - 8;
                int lineY = MaterialListGUI.getYForAlignedCenter(top, bottom - 1, 1);
                RenderSystem.m_69478_();
                RenderSystem.m_69472_();
                RenderSystem.m_69405_((int)770, (int)771);
                RenderSystem.m_157429_((float)255.0f, (float)255.0f, (float)255.0f, (float)34.0f);
                RenderSystem.m_69493_();
            }
        }

        private void drawHoveringText(ItemStack item, int slotX, int slotY, int mouseX, int mouseY) {
            if (MaterialListGUI.isPointInBox(mouseX, mouseY, slotX, slotY, 18, 18)) {
                this.parent.gui.setTaskHoveringText(mouseX, mouseY, this.parent.gui.m_96555_(item));
            }
        }

        private void drawIcon(PoseStack matrices, ItemStack item, int slotX, int slotY) {
            Lighting.m_84930_();
            Minecraft.m_91087_().m_91291_().m_115203_(item, slotX, slotY);
            Lighting.m_84931_();
        }

        private boolean hasEnoughItems() {
            return this.required == this.available;
        }

        private int getTextColor() {
            return this.hasEnoughItems() ? Color.GREEN.getRGB() : Color.RED.getRGB();
        }

        public int getRequired() {
            return this.required;
        }

        public int getAvailable() {
            return this.available;
        }

        public int getMissing() {
            return this.required - this.available;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public String getItemName() {
            return this.itemName;
        }

        public String getFormattedRequired() {
            int maxSize = this.stack.m_41741_();
            int stacks = this.required / maxSize;
            int leftover = this.required % maxSize;
            if (stacks == 0) {
                return String.valueOf(leftover);
            }
            return stacks + "\u00d7" + maxSize + "+" + leftover;
        }

        public boolean m_6375_(double x, double y, int button) {
            return false;
        }

        public boolean isSelected() {
            return this.parent.m_93511_() == this;
        }

        public Component m_142172_() {
            return null;
        }
    }
}

