/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class BookFrameOverlay {
    public static final Codec<BookFrameOverlay> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.f_135803_.fieldOf("texture").forGetter(overlay -> overlay.texture), (App)Codec.SHORT.fieldOf("texture_width").forGetter(overlay -> (short)overlay.textureWidth), (App)Codec.SHORT.fieldOf("texture_height").forGetter(overlay -> (short)overlay.textureHeight), (App)Codec.SHORT.fieldOf("frame_width").forGetter(overlay -> (short)overlay.frameWidth), (App)Codec.SHORT.fieldOf("frame_height").forGetter(overlay -> (short)overlay.frameHeight), (App)Codec.SHORT.fieldOf("frame_x_offset").forGetter(overlay -> (short)overlay.frameXOffset), (App)Codec.SHORT.fieldOf("frame_y_offset").forGetter(overlay -> (short)overlay.frameYOffset)).apply((Applicative)builder, BookFrameOverlay::new));
    private final int textureHeight;
    private final int textureWidth;
    private final int frameWidth;
    private final int frameHeight;
    private final int frameXOffset;
    private final int frameYOffset;
    private final ResourceLocation texture;

    public BookFrameOverlay(ResourceLocation texture, int textureWidth, int textureHeight, int frameWidth, int frameHeight, int frameXOffset, int frameYOffset) {
        this.texture = texture;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.frameWidth = frameWidth;
        this.frameHeight = frameHeight;
        this.frameXOffset = frameXOffset;
        this.frameYOffset = frameYOffset;
    }

    public static BookFrameOverlay fromJson(JsonObject json) {
        return (BookFrameOverlay)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).get().orThrow();
    }

    public static BookFrameOverlay fromNetwork(FriendlyByteBuf buffer) {
        return (BookFrameOverlay)buffer.m_130057_(CODEC);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130059_(CODEC, (Object)this);
    }

    public int getFrameU() {
        return this.textureWidth / 2 - this.frameWidth / 2;
    }

    public int getFrameV() {
        return this.textureHeight / 2 - this.frameHeight / 2;
    }

    public int getFrameX(int startX) {
        return startX - this.frameWidth / 2 + this.frameXOffset;
    }

    public int getFrameY(int startY) {
        return startY - this.frameHeight / 2 + this.frameYOffset;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public int getTextureHeight() {
        return this.textureHeight;
    }

    public int getTextureWidth() {
        return this.textureWidth;
    }

    public int getFrameWidth() {
        return this.frameWidth;
    }

    public int getFrameHeight() {
        return this.frameHeight;
    }

    public int getFrameXOffset() {
        return this.frameXOffset;
    }

    public int getFrameYOffset() {
        return this.frameYOffset;
    }
}

