/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;

public enum TeamRank implements StringRepresentable
{
    ENEMY("enemy", -100),
    NONE("none", 0),
    ALLY("ally", 50, Icons.FRIENDS),
    INVITED("invited", 75),
    MEMBER("member", 100, Icons.ACCEPT_GRAY),
    OFFICER("officer", 500, Icons.SHIELD),
    OWNER("owner", 1000, Icons.DIAMOND);

    public static final TeamRank[] VALUES;
    public static final NameMap<TeamRank> NAME_MAP;
    private final String name;
    private final int power;
    private Icon icon;

    private TeamRank(String name, int power, Icon icon) {
        this.name = name;
        this.power = power;
        this.icon = icon;
    }

    private TeamRank(String name, int power) {
        this(name, power, null);
    }

    public String m_7912_() {
        return this.name;
    }

    public int getPower() {
        return this.power;
    }

    public boolean is(TeamRank rank) {
        if (rank.power > 0) {
            return this.power >= rank.power;
        }
        if (rank.power < 0) {
            return this.power <= rank.power;
        }
        return true;
    }

    public boolean isEnemy() {
        return this.is(ENEMY);
    }

    public boolean isNone() {
        return this.is(NONE);
    }

    public boolean isAlly() {
        return this.is(ALLY);
    }

    public boolean isInvited() {
        return this.is(INVITED);
    }

    public boolean isMember() {
        return this.is(MEMBER);
    }

    public boolean isOfficer() {
        return this.is(OFFICER);
    }

    public boolean isOwner() {
        return this.is(OWNER);
    }

    public Optional<Icon> getIcon() {
        return Optional.ofNullable(this.icon);
    }

    public Component getDisplayName() {
        return Component.m_237115_((String)("ftbteams.ranks." + this.name));
    }

    static {
        VALUES = TeamRank.values();
        NAME_MAP = NameMap.of((Object)((Object)NONE), (Object[])TeamRank.values()).create();
    }
}

