/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.electric_motor;

import com.mrh0.createaddition.CreateAddition;
import com.mrh0.createaddition.blocks.electric_motor.ElectricMotorBlock;
import com.mrh0.createaddition.blocks.tesla_coil.TeslaCoilBlock;
import com.mrh0.createaddition.compat.computercraft.ElectricMotorPeripheral;
import com.mrh0.createaddition.compat.computercraft.Peripherals;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.GeneratingKineticTileEntity;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ElectricMotorTileEntity
extends GeneratingKineticTileEntity {
    protected ScrollValueBehaviour generatedSpeed;
    protected final InternalEnergyStorage energy = new InternalEnergyStorage(CAPACITY, MAX_IN, MAX_OUT);
    private LazyOptional<IEnergyStorage> lazyEnergy = LazyOptional.of(() -> this.energy);
    private LazyOptional<ElectricMotorPeripheral> lazyPeripheral = null;
    private boolean cc_update_rpm = false;
    private int cc_new_rpm = 32;
    public static final Integer RPM_RANGE = (Integer)Config.ELECTRIC_MOTOR_RPM_RANGE.get();
    public static final Integer DEFAULT_SPEED = 32;
    public static final Integer MAX_IN = (Integer)Config.ELECTRIC_MOTOR_MAX_INPUT.get();
    public static final Integer MIN_CONSUMPTION = (Integer)Config.ELECTRIC_MOTOR_MINIMUM_CONSUMPTION.get();
    public static final Integer MAX_OUT = 0;
    public static final Integer CAPACITY = (Integer)Config.ELECTRIC_MOTOR_CAPACITY.get();
    public static final Integer STRESS = (Integer)Config.BASELINE_STRESS.get();
    private boolean active = false;
    int cc_antiSpam = 0;
    boolean first = true;

    public ElectricMotorTileEntity(BlockEntityType<? extends ElectricMotorTileEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        if (CreateAddition.CC_ACTIVE) {
            this.lazyPeripheral = LazyOptional.of(() -> Peripherals.createElectricMotorPeripheral(this));
        }
        this.setLazyTickRate(20);
    }

    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        CenteredSideValueBoxTransform slot = new CenteredSideValueBoxTransform((motor, side) -> motor.m_61143_((Property)ElectricMotorBlock.FACING) == side.m_122424_());
        this.generatedSpeed = new ScrollValueBehaviour((Component)Lang.translateDirect((String)"generic.speed", (Object[])new Object[0]), (SmartTileEntity)this, (ValueBoxTransform)slot);
        this.generatedSpeed.between(-RPM_RANGE.intValue(), RPM_RANGE.intValue());
        this.generatedSpeed.value = DEFAULT_SPEED;
        this.generatedSpeed.scrollableValue = DEFAULT_SPEED;
        this.generatedSpeed.withUnit(i -> Lang.translateDirect((String)"generic.unit.rpm", (Object[])new Object[0]));
        this.generatedSpeed.withCallback(i -> this.updateGeneratedRotation((int)i));
        this.generatedSpeed.withStepFunction(ElectricMotorTileEntity::step);
        behaviours.add((TileEntityBehaviour)this.generatedSpeed);
    }

    public static int step(ScrollValueBehaviour.StepContext context) {
        int current = context.currentValue;
        int step = 1;
        if (!context.shift) {
            int magnitude = Math.abs(current) - (context.forward == current > 0 ? 0 : 1);
            if (magnitude >= 4) {
                step *= 4;
            }
            if (magnitude >= 32) {
                step *= 4;
            }
            if (magnitude >= 128) {
                step *= 4;
            }
        }
        return step;
    }

    public float calculateAddedStressCapacity() {
        float capacity;
        this.lastCapacityProvided = capacity = (float)STRESS.intValue() / 256.0f;
        return capacity;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"createaddition.tooltip.energy.consumption").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237113_((String)(" " + Util.format(ElectricMotorTileEntity.getEnergyConsumptionRate(this.generatedSpeed.getValue())) + "fe/t ")).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Lang.translateDirect((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_GRAY)));
        return true;
    }

    public void updateGeneratedRotation(int i) {
        super.updateGeneratedRotation();
        this.cc_new_rpm = i;
    }

    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    public float getGeneratedSpeed() {
        if (!CABlocks.ELECTRIC_MOTOR.has(this.m_58900_())) {
            return 0.0f;
        }
        return ElectricMotorTileEntity.convertToDirection((float)(this.active ? (float)this.generatedSpeed.getValue() : 0.0f), (Direction)((Direction)this.m_58900_().m_61143_((Property)ElectricMotorBlock.FACING)));
    }

    protected Block getStressConfigKey() {
        return (Block)AllBlocks.WATER_WHEEL.get();
    }

    public InternalEnergyStorage getEnergyStorage() {
        return this.energy;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.lazyEnergy.cast();
        }
        if (CreateAddition.CC_ACTIVE && Peripherals.isPeripheral(cap)) {
            return this.lazyPeripheral.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean isEnergyInput(Direction side) {
        return true;
    }

    public boolean isEnergyOutput(Direction side) {
        return false;
    }

    public void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.energy.read(compound);
        this.active = compound.m_128471_("active");
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.energy.write(compound);
        compound.m_128379_("active", this.active);
    }

    public void lazyTick() {
        super.lazyTick();
        this.cc_antiSpam = 5;
    }

    public static int getEnergyConsumptionRate(int rpm) {
        return Math.abs(rpm) > 0 ? (int)Math.max((double)((Integer)Config.FE_RPM.get()).intValue() * ((double)Math.abs(rpm) / 256.0), (double)MIN_CONSUMPTION.intValue()) : 0;
    }

    public void remove() {
        this.lazyEnergy.invalidate();
        if (this.lazyPeripheral != null) {
            this.lazyPeripheral.invalidate();
        }
    }

    public void tick() {
        super.tick();
        if (this.first) {
            this.updateGeneratedRotation();
            this.first = false;
        }
        if (this.cc_update_rpm && this.cc_antiSpam > 0) {
            this.generatedSpeed.setValue(this.cc_new_rpm);
            this.cc_update_rpm = false;
            --this.cc_antiSpam;
            this.updateGeneratedRotation();
        }
        if (this.f_58857_.m_5776_()) {
            return;
        }
        int con = ElectricMotorTileEntity.getEnergyConsumptionRate(this.generatedSpeed.getValue());
        if (!this.active) {
            if (this.energy.getEnergyStored() > con * 2 && !((Boolean)this.m_58900_().m_61143_((Property)ElectricMotorBlock.POWERED)).booleanValue()) {
                this.active = true;
                this.updateGeneratedRotation();
            }
        } else {
            int ext = this.energy.internalConsumeEnergy(con);
            if (ext < con || ((Boolean)this.m_58900_().m_61143_((Property)ElectricMotorBlock.POWERED)).booleanValue()) {
                this.active = false;
                this.updateGeneratedRotation();
            }
        }
    }

    public int getDurationAngle(int deg, float initialProgress, float speed) {
        speed = Math.abs(speed);
        deg = Math.abs(deg);
        if (speed < 0.1f) {
            return 0;
        }
        double degreesPerTick = speed * 360.0f / 60.0f / 20.0f;
        return (int)((double)((1.0f - initialProgress) * (float)deg) / degreesPerTick + 1.0);
    }

    public int getDurationDistance(int dis, float initialProgress, float speed) {
        speed = Math.abs(speed);
        dis = Math.abs(dis);
        if (speed < 0.1f) {
            return 0;
        }
        double metersPerTick = speed / 512.0f;
        return (int)((double)((1.0f - initialProgress) * (float)dis) / metersPerTick);
    }

    public boolean setRPM(int rpm) {
        this.cc_new_rpm = rpm = Math.max(Math.min(rpm, RPM_RANGE), -RPM_RANGE.intValue());
        this.cc_update_rpm = true;
        return this.cc_antiSpam > 0;
    }

    public int getRPM() {
        return this.cc_new_rpm;
    }

    public int getGeneratedStress() {
        return (int)this.calculateAddedStressCapacity();
    }

    public int getEnergyConsumption() {
        return ElectricMotorTileEntity.getEnergyConsumptionRate(this.generatedSpeed.getValue());
    }

    public boolean isPoweredState() {
        return (Boolean)this.m_58900_().m_61143_((Property)TeslaCoilBlock.POWERED);
    }
}

