/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.screen;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.tesseract.RedstoneState;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.packets.PacketScreenCycleRedstoneState;
import com.supermartijn642.tesseract.screen.CycleButton;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;

public class RedstoneButton
extends CycleButton {
    public RedstoneState state;
    private BlockPos pos;

    public RedstoneButton(int x, int y) {
        super(x, y, 60);
    }

    public void update(TesseractBlockEntity tile) {
        this.state = tile.getRedstoneState();
        this.pos = tile.m_58899_();
    }

    @Override
    protected int getCycleIndex() {
        return this.state == RedstoneState.DISABLED ? 0 : (this.state == RedstoneState.HIGH ? 1 : 2);
    }

    public void onPress() {
        super.onPress();
        if (this.pos != null) {
            Tesseract.CHANNEL.sendToServer((BasePacket)new PacketScreenCycleRedstoneState(this.pos));
        }
    }

    public Component getNarrationMessage() {
        return TextComponents.translation((String)"gui.tesseract.redstone.speech", (Object[])new Object[]{this.state.translate()}).get();
    }

    protected void getTooltips(Consumer<Component> tooltips) {
        tooltips.accept((Component)TextComponents.translation((String)"gui.tesseract.redstone.speech", (Object[])new Object[]{this.state.translate()}).get());
    }
}

