/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.manager;

import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import com.supermartijn642.tesseract.manager.TesseractReference;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TesseractTracker {
    public static MinecraftServer minecraftServer;
    public static final TesseractTracker SERVER;
    private final HashMap<String, HashMap<BlockPos, TesseractReference>> tesseracts = new HashMap();
    private final Set<TesseractReference> toBeRemoved = new HashSet<TesseractReference>();

    public static TesseractTracker getInstance(Level world) {
        return world.f_46443_ ? null : SERVER;
    }

    public TesseractReference add(TesseractBlockEntity self) {
        String dimension = self.m_58904_().m_46472_().m_135782_().toString();
        this.tesseracts.putIfAbsent(dimension, new HashMap());
        return this.tesseracts.get(dimension).computeIfAbsent(self.m_58899_(), key -> new TesseractReference(self));
    }

    @Deprecated
    public TesseractReference tryAdd(String dimension, BlockPos pos) {
        if (minecraftServer == null) {
            return null;
        }
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(dimension));
        ServerLevel level = TesseractChannelManager.minecraftServer.m_129880_(key);
        BlockEntity entity = level.m_7702_(pos);
        return entity instanceof TesseractBlockEntity ? this.add((TesseractBlockEntity)entity) : null;
    }

    public void remove(Level level, BlockPos pos) {
        String dimension = level.m_46472_().m_135782_().toString();
        this.remove(dimension, pos);
    }

    public void remove(String dimension, BlockPos pos) {
        this.tesseracts.putIfAbsent(dimension, new HashMap());
        TesseractReference reference = this.tesseracts.get(dimension).get(pos);
        if (reference != null) {
            this.toBeRemoved.add(reference);
        }
    }

    private void removeAndUpdate(TesseractReference reference) {
        reference.delete();
        this.tesseracts.putIfAbsent(reference.getDimension(), new HashMap());
        this.tesseracts.get(reference.getDimension()).remove(reference.getPos());
    }

    public TesseractReference get(Level level, BlockPos pos) {
        String dimension = level.m_46472_().m_135782_().toString();
        return (TesseractReference)this.tesseracts.putIfAbsent(dimension, new HashMap()).get(pos);
    }

    public CompoundTag writeKey(TesseractReference reference) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("dimension", reference.getDimension());
        tag.m_128405_("posx", reference.getPos().m_123341_());
        tag.m_128405_("posy", reference.getPos().m_123342_());
        tag.m_128405_("posz", reference.getPos().m_123343_());
        return tag;
    }

    public TesseractReference fromKey(CompoundTag key) {
        String dimension = key.m_128461_("dimension");
        BlockPos pos = new BlockPos(key.m_128451_("posx"), key.m_128451_("posy"), key.m_128451_("posz"));
        return this.tesseracts.containsKey(dimension) ? this.tesseracts.get(dimension).get(pos) : null;
    }

    @SubscribeEvent
    public static void onSave(LevelEvent.Save e) {
        if (e.getLevel().m_5776_() || !(e.getLevel() instanceof Level) || ((Level)e.getLevel()).m_46472_() != Level.f_46428_) {
            return;
        }
        File directory = new File(((ServerLevel)e.getLevel()).m_7654_().m_129843_(LevelResource.f_78182_).toFile(), "tesseract/tracking");
        int index = 0;
        for (Map.Entry<String, HashMap<BlockPos, TesseractReference>> dimensionEntry : TesseractTracker.SERVER.tesseracts.entrySet()) {
            for (Map.Entry<BlockPos, TesseractReference> entry : dimensionEntry.getValue().entrySet()) {
                File file = new File(directory, "tesseract" + index++ + ".nbt");
                try {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                    NbtIo.m_128955_((CompoundTag)entry.getValue().write(), (File)file);
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLoad(LevelEvent.Load e) {
        if (e.getLevel().m_5776_() || !(e.getLevel() instanceof Level) || ((Level)e.getLevel()).m_46472_() != Level.f_46428_) {
            return;
        }
        minecraftServer = ((ServerLevel)e.getLevel()).m_7654_();
        TesseractTracker.SERVER.tesseracts.clear();
        File directory = new File(((ServerLevel)e.getLevel()).m_7654_().m_129843_(LevelResource.f_78182_).toFile(), "tesseract/tracking");
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : directory.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".nbt")) continue;
                try {
                    CompoundTag tag = NbtIo.m_128953_((File)file);
                    TesseractReference location = new TesseractReference(tag);
                    TesseractTracker.SERVER.tesseracts.putIfAbsent(location.getDimension(), new HashMap());
                    TesseractTracker.SERVER.tesseracts.get(location.getDimension()).put(location.getPos(), location);
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.LevelTickEvent e) {
        if (e.level.f_46443_ || e.phase != TickEvent.Phase.END || e.level.m_46472_() != Level.f_46428_) {
            return;
        }
        TesseractTracker.SERVER.toBeRemoved.forEach(SERVER::removeAndUpdate);
        TesseractTracker.SERVER.toBeRemoved.clear();
    }

    static {
        SERVER = new TesseractTracker();
    }
}

