/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.manager;

import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.manager.Channel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.entity.player.Player;

public class ChannelList {
    private int channelId = 0;
    public final EnumChannelType type;
    private final ArrayList<Channel> channels = new ArrayList();
    private final ArrayList<Channel> publicChannels = new ArrayList();
    private final HashMap<Integer, Channel> channelsById = new HashMap();
    private final HashMap<UUID, List<Channel>> channelsByCreator = new HashMap();
    private final List<Integer> removedIds = new ArrayList<Integer>();

    public ChannelList(EnumChannelType type) {
        this.type = type;
    }

    public Channel add(UUID creator, boolean isPrivate, String name) {
        Channel channel = new Channel(this.channelId++, this.type, creator, isPrivate, name);
        this.add(channel);
        return channel;
    }

    void add(Channel channel) {
        this.channels.add(channel);
        if (!channel.isPrivate) {
            this.publicChannels.add(channel);
        }
        this.channelsById.put(channel.id, channel);
        this.channelsByCreator.putIfAbsent(channel.creator, new ArrayList());
        this.channelsByCreator.get(channel.creator).add(channel);
    }

    public void remove(int id) {
        this.remove(this.getById(id));
    }

    public void remove(Channel channel) {
        if (channel == null) {
            return;
        }
        this.channels.remove(channel);
        this.publicChannels.remove(channel);
        this.channelsById.remove(channel.id);
        this.channelsByCreator.get(channel.creator).remove(channel);
        channel.delete();
        this.removedIds.add(channel.id);
    }

    public List<Channel> sortForPlayer(Player player) {
        UUID uuid = player.m_20148_();
        this.channels.removeIf(channel -> channel.isPrivate && !channel.creator.equals(uuid));
        this.channels.sort((a, b) -> {
            boolean bUuid;
            boolean aUuid = a.creator.equals(uuid);
            if (aUuid ^ (bUuid = b.creator.equals(uuid))) {
                return aUuid ? -1 : 1;
            }
            return a.name.compareTo(b.name);
        });
        return this.channels;
    }

    public Channel getById(int id) {
        return this.channelsById.get(id);
    }

    public List<Channel> getChannels() {
        return Collections.unmodifiableList(this.channels);
    }

    public List<Channel> getChannelsCreatedBy(UUID creator) {
        return this.channelsByCreator.getOrDefault(creator, Collections.emptyList());
    }

    public void write(File folder) {
        File file;
        for (Channel channel : this.channels) {
            file = new File(folder, "channel" + channel.id + ".nbt");
            try {
                NbtIo.m_128955_((CompoundTag)channel.write(), (File)file);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Iterator<Object> iterator = this.removedIds.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            file = new File(folder, "channel" + id + ".nbt");
            try {
                file.delete();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.removedIds.clear();
    }

    public void read(File folder) {
        this.channelId = 0;
        if (!folder.exists()) {
            return;
        }
        File[] files = folder.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        for (File file : files) {
            String name = file.getName();
            if (!name.startsWith("channel") || !name.endsWith(".nbt")) continue;
            try {
                int id = Integer.parseInt(name.substring("channel".length(), name.length() - ".nbt".length()));
                CompoundTag compound = NbtIo.m_128953_((File)file);
                if (compound == null) continue;
                Channel channel = new Channel(id, this.type, compound);
                if (channel.id >= this.channelId) {
                    this.channelId = channel.id + 1;
                }
                this.add(channel);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void clear() {
        this.channels.clear();
        this.publicChannels.clear();
        this.channelsById.clear();
        this.channelsByCreator.clear();
    }
}

