/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.manager;

import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.capabilities.CombinedEnergyStorage;
import com.supermartijn642.tesseract.capabilities.CombinedFluidHandler;
import com.supermartijn642.tesseract.capabilities.CombinedItemHandler;
import com.supermartijn642.tesseract.manager.TesseractReference;
import com.supermartijn642.tesseract.manager.TesseractTracker;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class Channel {
    public final int id;
    public final EnumChannelType type;
    public UUID creator;
    public boolean isPrivate = false;
    public String name;
    public final Set<TesseractReference> tesseracts = new LinkedHashSet<TesseractReference>();
    public final Set<TesseractReference> sendingTesseracts = new LinkedHashSet<TesseractReference>();
    public final Set<TesseractReference> receivingTesseracts = new LinkedHashSet<TesseractReference>();

    public Channel(int id, EnumChannelType type, UUID creator, boolean isPrivate, String name) {
        this.id = id;
        this.type = type;
        this.creator = creator;
        this.isPrivate = isPrivate;
        this.name = name;
    }

    public Channel(int id, EnumChannelType type, CompoundTag compound) {
        this.id = id;
        this.type = type;
        this.read(compound);
    }

    public String getName() {
        return this.name;
    }

    public void addTesseract(TesseractReference tesseract) {
        if (!this.tesseracts.contains(tesseract)) {
            this.tesseracts.add(tesseract);
            if (tesseract.canSend(this.type)) {
                this.sendingTesseracts.add(tesseract);
            }
            if (tesseract.canReceive(this.type)) {
                this.receivingTesseracts.add(tesseract);
            }
            if (tesseract.getChannelId(this.type) != this.id) {
                tesseract.getTesseract().setChannel(this.type, this.id);
            }
        }
    }

    public void removeTesseract(TesseractReference tesseract) {
        this.tesseracts.remove(tesseract);
        this.sendingTesseracts.remove(tesseract);
        this.receivingTesseracts.remove(tesseract);
    }

    public void updateTesseract(TesseractReference tesseract) {
        if (tesseract.canSend(this.type)) {
            this.sendingTesseracts.add(tesseract);
        } else {
            this.sendingTesseracts.remove(tesseract);
        }
        if (tesseract.canReceive(this.type)) {
            this.receivingTesseracts.add(tesseract);
        } else {
            this.receivingTesseracts.remove(tesseract);
        }
    }

    public CompoundTag write() {
        CompoundTag compound = new CompoundTag();
        compound.m_128362_("creator", this.creator);
        compound.m_128379_("private", this.isPrivate);
        compound.m_128359_("name", this.name);
        CompoundTag tesseractCompound = new CompoundTag();
        Iterator<TesseractReference> iterator = this.tesseracts.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            tesseractCompound.m_128365_("tesseract" + i, (Tag)TesseractTracker.SERVER.writeKey(iterator.next()));
            ++i;
        }
        compound.m_128365_("references", (Tag)tesseractCompound);
        return compound;
    }

    public void read(CompoundTag compound) {
        this.creator = compound.m_128342_("creator");
        this.isPrivate = compound.m_128471_("private");
        this.name = compound.m_128461_("name");
        this.tesseracts.clear();
        this.sendingTesseracts.clear();
        this.receivingTesseracts.clear();
        CompoundTag tesseractCompound = compound.m_128469_("references");
        for (String key : tesseractCompound.m_128431_()) {
            TesseractReference reference = TesseractTracker.SERVER.fromKey(tesseractCompound.m_128469_(key));
            if (reference == null) continue;
            this.addTesseract(reference);
        }
        if (compound.m_128441_("tesseracts")) {
            tesseractCompound = compound.m_128469_("tesseracts");
            for (String key : tesseractCompound.m_128431_()) {
                BlockPos pos;
                CompoundTag compound2 = tesseractCompound.m_128469_(key);
                String dimension = compound2.m_128461_("dim");
                TesseractReference reference = TesseractTracker.SERVER.tryAdd(dimension, pos = new BlockPos(compound2.m_128451_("posx"), compound2.m_128451_("posy"), compound2.m_128451_("posz")));
                if (reference == null) continue;
                this.addTesseract(reference);
            }
        }
    }

    public CompoundTag writeClientChannel() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("id", this.id);
        tag.m_128405_("type", this.type.getIndex());
        tag.m_128362_("creator", this.creator);
        tag.m_128379_("private", this.isPrivate);
        tag.m_128359_("name", this.name);
        return tag;
    }

    public static Channel readClientChannel(CompoundTag tag) {
        int id = tag.m_128451_("id");
        EnumChannelType type = EnumChannelType.byIndex(tag.m_128451_("type"));
        UUID creator = tag.m_128342_("creator");
        boolean isPrivate = tag.m_128471_("private");
        String name = tag.m_128461_("name");
        return new Channel(id, type, creator, isPrivate, name);
    }

    public CombinedItemHandler getItemHandler(TesseractBlockEntity self) {
        return new CombinedItemHandler(this, self);
    }

    public CombinedFluidHandler getFluidHandler(TesseractBlockEntity self) {
        return new CombinedFluidHandler(this, self);
    }

    public CombinedEnergyStorage getEnergyStorage(TesseractBlockEntity self) {
        return new CombinedEnergyStorage(this, self);
    }

    public int hashCode() {
        return this.id + 31 * this.type.hashCode();
    }

    public void delete() {
        for (TesseractReference location : this.tesseracts) {
            if (!location.isValid()) continue;
            location.getTesseract().setChannel(this.type, -1);
        }
    }
}

