/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.capabilities;

import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractReference;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class CombinedEnergyStorage
implements IEnergyStorage {
    private final Channel channel;
    private final TesseractBlockEntity requester;

    public CombinedEnergyStorage(Channel channel, TesseractBlockEntity requester) {
        this.channel = channel;
        this.requester = requester;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (this.pushRecurrentCall()) {
            return 0;
        }
        if (!this.requester.canSend(EnumChannelType.ENERGY) || maxReceive <= 0) {
            return 0;
        }
        int amount = maxReceive;
        block0: for (TesseractReference location : this.channel.receivingTesseracts) {
            TesseractBlockEntity tile;
            if (!location.isValid() || !location.canReceive(EnumChannelType.ENERGY) || (tile = location.getTesseract()) == this.requester) continue;
            for (IEnergyStorage storage : tile.getSurroundingCapabilities(CapabilityEnergy.ENERGY)) {
                if (!storage.canReceive()) continue;
                int amount2 = storage.receiveEnergy(amount, simulate);
                if (amount2 > 0) {
                    amount -= amount2;
                }
                if (amount > 0) continue;
                break block0;
            }
        }
        this.popRecurrentCall();
        return maxReceive - amount;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (this.pushRecurrentCall()) {
            return 0;
        }
        if (!this.requester.canReceive(EnumChannelType.ENERGY) || maxExtract <= 0) {
            return 0;
        }
        int amount = maxExtract;
        block0: for (TesseractReference location : this.channel.sendingTesseracts) {
            TesseractBlockEntity tile;
            if (!location.isValid() || !location.canSend(EnumChannelType.ENERGY) || (tile = location.getTesseract()) == this.requester) continue;
            for (IEnergyStorage storage : tile.getSurroundingCapabilities(CapabilityEnergy.ENERGY)) {
                if (!storage.canExtract()) continue;
                int amount2 = storage.extractEnergy(amount, simulate);
                if (amount2 > 0) {
                    amount -= amount2;
                }
                if (amount > 0) continue;
                break block0;
            }
        }
        this.popRecurrentCall();
        return maxExtract - amount;
    }

    public int getEnergyStored() {
        if (this.pushRecurrentCall()) {
            return 0;
        }
        int amount = 0;
        for (TesseractReference location : this.channel.tesseracts) {
            TesseractBlockEntity tile;
            if (!location.isValid() || (tile = location.getTesseract()) == this.requester) continue;
            for (IEnergyStorage storage : tile.getSurroundingCapabilities(CapabilityEnergy.ENERGY)) {
                amount += storage.getEnergyStored();
            }
        }
        this.popRecurrentCall();
        return amount;
    }

    public int getMaxEnergyStored() {
        if (this.pushRecurrentCall()) {
            return 0;
        }
        int amount = 0;
        for (TesseractReference location : this.channel.tesseracts) {
            TesseractBlockEntity tile;
            if (!location.isValid() || (tile = location.getTesseract()) == this.requester) continue;
            for (IEnergyStorage storage : tile.getSurroundingCapabilities(CapabilityEnergy.ENERGY)) {
                amount += storage.getMaxEnergyStored();
            }
        }
        this.popRecurrentCall();
        return amount;
    }

    public boolean canExtract() {
        return this.requester.canReceive(EnumChannelType.ENERGY);
    }

    public boolean canReceive() {
        return this.requester.canSend(EnumChannelType.ENERGY);
    }

    private boolean pushRecurrentCall() {
        if (this.requester.recurrentCalls >= 1) {
            return true;
        }
        ++this.requester.recurrentCalls;
        return false;
    }

    private void popRecurrentCall() {
        --this.requester.recurrentCalls;
    }
}

