/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.handler.advancement.QuarkAdvancementHandler;
import vazkii.quark.base.handler.advancement.QuarkGenericTrigger;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class PoisonPotatoUsageModule
extends QuarkModule {
    private static final String TAG_POISONED = "quark:poison_potato_applied";
    @Config
    public static double chance = 0.1;
    @Config
    public static boolean poisonEffect = true;
    public static QuarkGenericTrigger poisonBabyTrigger;

    @Override
    public void register() {
        poisonBabyTrigger = QuarkAdvancementHandler.registerGenericTrigger("poison_baby");
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getItemStack().m_41720_() == Items.f_42675_ && this.canPoison(event.getTarget())) {
            LivingEntity entity = (LivingEntity)event.getTarget();
            if (!event.getLevel().f_46443_) {
                Vec3 pos = entity.m_20182_();
                if (event.getEntity().m_7500_() || entity.f_19853_.f_46441_.m_188500_() < chance) {
                    entity.m_5496_(SoundEvents.f_11912_, 0.5f, 0.25f);
                    entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.2, 0.8, 0.0);
                    this.poisonEntity((Entity)entity);
                    Player player = event.getEntity();
                    if (player instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)player;
                        poisonBabyTrigger.trigger(sp);
                    }
                    if (poisonEffect) {
                        entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 80));
                    }
                } else {
                    entity.m_5496_(SoundEvents.f_11912_, 0.5f, 0.5f + entity.f_19853_.f_46441_.m_188501_() / 2.0f);
                    entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.1, 0.0);
                }
                if (!event.getEntity().m_150110_().f_35937_) {
                    event.getItemStack().m_41774_(1);
                }
            } else {
                event.getEntity().m_6674_(event.getHand());
            }
        }
    }

    private boolean canPoison(Entity entity) {
        AgeableMob ageable;
        return !this.isEntityPoisoned(entity) && (entity instanceof AgeableMob && (ageable = (AgeableMob)entity).m_6162_() || entity instanceof Tadpole);
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Animal) {
            Animal animal = (Animal)livingEntity;
            if (animal.m_6162_() && this.isEntityPoisoned((Entity)animal)) {
                animal.m_146762_(-24000);
            }
        } else {
            Tadpole tadpole;
            livingEntity = event.getEntity();
            if (livingEntity instanceof Tadpole && this.isEntityPoisoned((Entity)(tadpole = (Tadpole)livingEntity))) {
                tadpole.m_218710_(0);
            }
        }
    }

    private boolean isEntityPoisoned(Entity e) {
        return e.getPersistentData().m_128471_(TAG_POISONED);
    }

    private void poisonEntity(Entity e) {
        e.getPersistentData().m_128379_(TAG_POISONED, true);
    }
}

