/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.event.level.NoteBlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class MoreNoteBlockSoundsModule
extends QuarkModule {
    @Config
    public static boolean enableSkullSounds = true;
    @Config
    public static boolean enableAmethystSound = true;

    @SubscribeEvent
    public void noteBlockPlayed(NoteBlockEvent.Play event) {
        BlockPos pos;
        LevelAccessor world = event.getLevel();
        if (world.m_8055_(pos = event.getPos()).m_60734_() != Blocks.f_50065_) {
            return;
        }
        if (enableSkullSounds) {
            Direction dir;
            SoundEvent sound = null;
            Direction[] directionArray = MiscUtil.HORIZONTALS;
            int n = directionArray.length;
            for (int i = 0; i < n && (sound = this.getSoundEvent(world, pos, dir = directionArray[i])) == null; ++i) {
            }
            if (sound != null) {
                event.setCanceled(true);
                float pitch = (float)Math.pow(2.0, (double)(event.getVanillaNoteId() - 12) / 12.0);
                world.m_5594_(null, pos.m_7494_(), sound, SoundSource.BLOCKS, 1.0f, pitch);
                return;
            }
        }
        if (enableAmethystSound && event.getInstrument() == NoteBlockInstrument.HARP && world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            if (world.m_8055_(pos.m_7495_()).m_60767_() == Material.f_164531_) {
                event.setCanceled(true);
                int note = (Integer)event.getState().m_61143_((Property)NoteBlock.f_55013_);
                float pitch = (float)Math.pow(2.0, (double)(note - 12) / 12.0);
                world.m_5594_(null, pos, SoundEvents.f_144243_, SoundSource.RECORDS, 0.5f, pitch);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, (double)note / 24.0);
            }
        }
    }

    public SoundEvent getSoundEvent(LevelAccessor world, BlockPos pos, Direction direction) {
        BlockState state = world.m_8055_(pos.m_121945_(direction));
        Block block = state.m_60734_();
        if (block instanceof WallSkullBlock && state.m_61143_((Property)WallSkullBlock.f_58097_) == direction) {
            if (block == Blocks.f_50311_) {
                return SoundEvents.f_12423_;
            }
            if (block == Blocks.f_50313_) {
                return SoundEvents.f_12559_;
            }
            if (block == Blocks.f_50315_) {
                return SoundEvents.f_12598_;
            }
            if (block == Blocks.f_50319_) {
                return SoundEvents.f_11837_;
            }
            if (block == Blocks.f_50321_) {
                return SoundEvents.f_11890_;
            }
        }
        return null;
    }
}

