/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.DoubleDoorMessage;
import vazkii.quark.integration.claim.IClaimIntegration;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true, subscribeOn={Dist.CLIENT}, antiOverlap={"utilitix"})
public class DoubleDoorOpeningModule
extends QuarkModule {
    @Config
    public static boolean enableDoors = true;
    @Config
    public static boolean enableFenceGates = true;
    public static TagKey<Block> nonDoubleDoorTag;
    private static boolean handling;

    @Override
    public void setup() {
        nonDoubleDoorTag = BlockTags.create((ResourceLocation)new ResourceLocation("quark", "non_double_door"));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (!event.getLevel().f_46443_ || player.m_20163_() || event.isCanceled() || event.getResult() == Event.Result.DENY || event.getUseBlock() == Event.Result.DENY || handling) {
            return;
        }
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        if (!IClaimIntegration.INSTANCE.canInteract(player, pos)) {
            return;
        }
        handling = true;
        boolean opened = DoubleDoorOpeningModule.openBlock(world, player, pos);
        handling = false;
        if (opened) {
            QuarkNetwork.sendToServer(new DoubleDoorMessage(pos));
        }
    }

    public static boolean openBlock(Level world, Player player, BlockPos pos) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(DoubleDoorOpeningModule.class) || world == null) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        if (state.m_204336_(nonDoubleDoorTag)) {
            return false;
        }
        if (enableDoors && state.m_60734_() instanceof DoorBlock) {
            return DoubleDoorOpeningModule.openDoor(pos, world, player, state);
        }
        if (enableFenceGates && state.m_60734_() instanceof FenceGateBlock) {
            return DoubleDoorOpeningModule.openFenceGate(pos, world, player, state);
        }
        return false;
    }

    private static boolean openDoor(BlockPos pos, Level level, Player player, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        boolean isOpen = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_);
        DoorHingeSide isMirrored = (DoorHingeSide)state.m_61143_((Property)DoorBlock.f_52728_);
        BlockPos mirrorPos = pos.m_121945_(isMirrored == DoorHingeSide.RIGHT ? direction.m_122428_() : direction.m_122427_());
        BlockPos doorPos = state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER ? mirrorPos : mirrorPos.m_7495_();
        return DoubleDoorOpeningModule.tryOpen(level, player, state, doorPos, direction, isOpen, (Predicate<BlockState>)((Predicate)test -> test.m_61143_((Property)DoorBlock.f_52728_) != isMirrored));
    }

    private static boolean openFenceGate(BlockPos pos, Level level, Player player, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)FenceGateBlock.f_54117_);
        boolean isOpen = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_);
        if (DoubleDoorOpeningModule.tryOpen(level, player, state, pos.m_7495_(), direction, isOpen, (Predicate<BlockState>)Predicates.alwaysTrue())) {
            return true;
        }
        return DoubleDoorOpeningModule.tryOpen(level, player, state, pos.m_7494_(), direction, isOpen, (Predicate<BlockState>)Predicates.alwaysTrue());
    }

    private static boolean tryOpen(Level level, Player player, BlockState state, BlockPos otherPos, Direction direction, boolean isOpen, Predicate<BlockState> pred) {
        PlayerInteractEvent.RightClickBlock event;
        boolean eventRes;
        BlockHitResult res;
        BlockState other = level.m_8055_(otherPos);
        if (state.m_60767_() != Material.f_76279_ && other.m_60734_() == state.m_60734_() && other.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == direction && (Boolean)other.m_61143_((Property)BlockStateProperties.f_61446_) == isOpen && pred.apply((Object)other) && (res = new BlockHitResult(new Vec3((double)otherPos.m_123341_() + 0.5, (double)otherPos.m_123342_() + 0.5, (double)otherPos.m_123343_() + 0.5), direction, otherPos, false)).m_6662_() == HitResult.Type.BLOCK && !(eventRes = MinecraftForge.EVENT_BUS.post((Event)(event = new PlayerInteractEvent.RightClickBlock(player, InteractionHand.MAIN_HAND, otherPos, res))))) {
            InteractionResult interaction = other.m_60664_(level, player, InteractionHand.MAIN_HAND, res);
            return interaction != InteractionResult.PASS;
        }
        return false;
    }

    static {
        handling = false;
    }
}

