/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.module;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MerchantContainer;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.api.IRuneColorProvider;
import vazkii.quark.api.QuarkCapabilities;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.handler.advancement.QuarkAdvancementHandler;
import vazkii.quark.base.handler.advancement.QuarkGenericTrigger;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.content.tools.item.AncientTomeItem;
import vazkii.quark.content.tools.loot.EnchantTome;
import vazkii.quark.content.world.module.MonsterBoxModule;

@LoadModule(category=ModuleCategory.TOOLS, hasSubscriptions=true)
public class AncientTomesModule
extends QuarkModule {
    private static final Object mutex = new Object();
    @Config(description="Format is lootTable,weight. i.e. \"minecraft:chests/stronghold_library,30\"")
    public static List<String> lootTables = Lists.newArrayList((Object[])new String[]{AncientTomesModule.loot(BuiltInLootTables.f_78761_, 30), AncientTomesModule.loot(BuiltInLootTables.f_78742_, 20), AncientTomesModule.loot(BuiltInLootTables.f_78697_, 25), AncientTomesModule.loot(BuiltInLootTables.f_78689_, 15), AncientTomesModule.loot(BuiltInLootTables.f_78760_, 0), AncientTomesModule.loot(BuiltInLootTables.f_78691_, 0), AncientTomesModule.loot(BuiltInLootTables.f_78690_, 0), AncientTomesModule.loot(BuiltInLootTables.f_230876_, 4), AncientTomesModule.loot(MonsterBoxModule.MONSTER_BOX_LOOT_TABLE, 5)});
    private static final Object2IntMap<ResourceLocation> lootTableWeights = new Object2IntArrayMap();
    @Config
    public static int itemQuality = 2;
    @Config
    public static int normalUpgradeCost = 10;
    @Config
    public static int limitBreakUpgradeCost = 30;
    public static LootItemFunctionType tomeEnchantType;
    @Config(name="Valid Enchantments")
    public static List<String> enchantNames;
    @Config
    public static boolean overleveledBooksGlowRainbow;
    @Config(description="When enabled, Efficiency VI Diamond and Netherite pickaxes can instamine Deepslate when under Haste 2", flag="deepslate_tweak")
    public static boolean deepslateTweak;
    @Config
    public static boolean deepslateTweakNeedsHaste2;
    @Config(description="Master Librarians will offer to exchange Ancient Tomes, provided you give them a max-level Enchanted Book of the Tome's enchantment too.")
    public static boolean librariansExchangeAncientTomes;
    @Config(description="Applying a tome will also randomly curse your item")
    public static boolean curseGear;
    @Config(description="Allows combining tomes with normal books")
    public static boolean combineWithBooks;
    public static Item ancient_tome;
    public static final List<Enchantment> validEnchants;
    private static boolean initialized;
    public static QuarkGenericTrigger overlevelTrigger;
    public static QuarkGenericTrigger instamineDeepslateTrigger;
    private static final ResourceLocation OVERLEVEL_COLOR_HANDLER;
    private final List<Enchantment> curses = new ArrayList<Enchantment>();

    private static String loot(ResourceLocation lootLoc, int defaultWeight) {
        return lootLoc.toString() + "," + defaultWeight;
    }

    @Override
    public void register() {
        ancient_tome = new AncientTomeItem(this);
        tomeEnchantType = new LootItemFunctionType((Serializer)new EnchantTome.Serializer());
        Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)new ResourceLocation("quark", "tome_enchant"), (Object)tomeEnchantType);
        overlevelTrigger = QuarkAdvancementHandler.registerGenericTrigger("overlevel");
        instamineDeepslateTrigger = QuarkAdvancementHandler.registerGenericTrigger("instamine_deepslate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onTradesLoaded(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.f_35594_ && librariansExchangeAncientTomes) {
            Object object = mutex;
            synchronized (object) {
                Int2ObjectMap trades = event.getTrades();
                ((List)trades.get(5)).add(new ExchangeAncientTomesTrade());
            }
        }
    }

    @Override
    public void configChanged() {
        lootTableWeights.clear();
        for (String table : lootTables) {
            int weight;
            String[] split = table.split(",");
            if (split.length != 2) continue;
            ResourceLocation loc = new ResourceLocation(split[0]);
            try {
                weight = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (weight <= 0) continue;
            lootTableWeights.put((Object)loc, weight);
        }
        if (initialized) {
            this.setupEnchantList();
        }
    }

    @Override
    public void setup() {
        this.setupEnchantList();
        this.setupCursesList();
        initialized = true;
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation res = event.getName();
        int weight = lootTableWeights.getOrDefault((Object)res, 0);
        if (weight > 0) {
            LootPoolEntryContainer entry = LootItem.m_79579_((ItemLike)ancient_tome).m_79707_(weight).m_79711_(itemQuality).m_79078_(() -> new EnchantTome(new LootItemCondition[0])).m_7512_();
            MiscUtil.addToLootTable(event.getTable(), entry);
        }
    }

    public static boolean isInitialized() {
        return initialized;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        String name = event.getName();
        if (!left.m_41619_() && !right.m_41619_()) {
            if (right.m_150930_(ancient_tome)) {
                if (!combineWithBooks && left.m_150930_(Items.f_42690_)) {
                    return;
                }
                Enchantment ench = AncientTomesModule.getTomeEnchantment(right);
                Map enchants = EnchantmentHelper.m_44831_((ItemStack)left);
                if (ench != null && enchants.containsKey(ench) && (Integer)enchants.get(ench) <= ench.m_6586_()) {
                    int cost;
                    int lvl = (Integer)enchants.get(ench) + 1;
                    enchants.put(ench, lvl);
                    ItemStack out = left.m_41777_();
                    EnchantmentHelper.m_44865_((Map)enchants, (ItemStack)out);
                    int n = cost = lvl > ench.m_6586_() ? limitBreakUpgradeCost : normalUpgradeCost;
                    if (!(name == null || name.isEmpty() || out.m_41788_() && out.m_41786_().getString().equals(name))) {
                        out.m_41714_((Component)Component.m_237113_((String)name));
                        ++cost;
                    }
                    event.setOutput(out);
                    event.setCost(cost);
                }
            } else if (combineWithBooks && right.m_150930_(Items.f_42690_)) {
                Map enchants = EnchantmentHelper.m_44831_((ItemStack)right);
                Map currentEnchants = EnchantmentHelper.m_44831_((ItemStack)left);
                boolean hasOverLevel = false;
                boolean hasMatching = false;
                for (Map.Entry entry : enchants.entrySet()) {
                    Enchantment enchantment = (Enchantment)entry.getKey();
                    if (enchantment == null) continue;
                    int level = (Integer)entry.getValue();
                    if (level > enchantment.m_6586_()) {
                        hasOverLevel = true;
                        if (!enchantment.m_6081_(left) && !left.m_150930_(Items.f_42690_)) continue;
                        hasMatching = true;
                        Iterator iterator = currentEnchants.keySet().iterator();
                        while (iterator.hasNext()) {
                            Enchantment comparingEnchantment = (Enchantment)iterator.next();
                            if (comparingEnchantment == enchantment || comparingEnchantment.m_44695_(enchantment)) continue;
                            iterator.remove();
                        }
                        currentEnchants.put(enchantment, level);
                        continue;
                    }
                    if (!enchantment.m_6081_(left)) continue;
                    boolean compatible = true;
                    for (Enchantment comparingEnchantment : currentEnchants.keySet()) {
                        if (comparingEnchantment == enchantment || comparingEnchantment == null || comparingEnchantment.m_44695_(enchantment)) continue;
                        compatible = false;
                        break;
                    }
                    if (!compatible) continue;
                    currentEnchants.put(enchantment, level);
                }
                if (hasOverLevel && hasMatching) {
                    ItemStack out = left.m_41777_();
                    EnchantmentHelper.m_44865_((Map)currentEnchants, (ItemStack)out);
                    int cost = normalUpgradeCost;
                    if (!(name == null || name.isEmpty() || out.m_41788_() && out.m_41786_().getString().equals(name))) {
                        out.m_41714_((Component)Component.m_237113_((String)name));
                        ++cost;
                    }
                    event.setOutput(out);
                    event.setCost(cost);
                }
            }
        }
    }

    @SubscribeEvent
    public void onAnvilUse(AnvilRepairEvent event) {
        Player player;
        ItemStack output = event.getOutput();
        ItemStack right = event.getRight();
        if (curseGear && (right.m_150930_(ancient_tome) || event.getLeft().m_150930_(ancient_tome))) {
            event.getOutput().m_41663_(this.curses.get(event.getEntity().f_19853_.f_46441_.m_188503_(this.curses.size())), 1);
        }
        if (AncientTomesModule.isOverlevel(output) && (right.m_41720_() == Items.f_42690_ || right.m_41720_() == ancient_tome) && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            overlevelTrigger.trigger(sp);
        }
    }

    @SubscribeEvent
    public void onGetSpeed(PlayerEvent.BreakSpeed event) {
        if (deepslateTweak) {
            Player player = event.getEntity();
            ItemStack stack = player.m_21205_();
            BlockState state = event.getState();
            if (state.m_60713_(Blocks.f_152550_) && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44984_, (ItemStack)stack) >= 6 && event.getOriginalSpeed() >= 45.0f && (!deepslateTweakNeedsHaste2 || this.playerHasHaste2(player))) {
                event.setNewSpeed(100.0f);
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    instamineDeepslateTrigger.trigger(sp);
                }
            }
        }
    }

    private boolean playerHasHaste2(Player player) {
        MobEffectInstance inst = player.m_21124_(MobEffects.f_19598_);
        return inst != null && inst.m_19564_() > 0;
    }

    private static boolean isOverlevel(ItemStack stack) {
        Map enchants = EnchantmentHelper.m_44831_((ItemStack)stack);
        for (Map.Entry entry : enchants.entrySet()) {
            int level;
            Enchantment enchantment = (Enchantment)entry.getKey();
            if (enchantment == null || (level = ((Integer)entry.getValue()).intValue()) <= enchantment.m_6586_()) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void attachRuneCapability(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).m_41720_() == Items.f_42690_) {
            IRuneColorProvider provider = new IRuneColorProvider(){

                @Override
                public int getRuneColor(ItemStack stack) {
                    if (overleveledBooksGlowRainbow && AncientTomesModule.isOverlevel(stack)) {
                        return 16;
                    }
                    return -1;
                }
            };
            final LazyOptional holder = LazyOptional.of(() -> provider);
            event.addCapability(OVERLEVEL_COLOR_HANDLER, new ICapabilityProvider(){

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return QuarkCapabilities.RUNE_COLOR.orEmpty(cap, holder);
                }
            });
        }
    }

    public static Rarity shiftRarity(ItemStack itemStack, Rarity returnValue) {
        return ModuleLoader.INSTANCE.isModuleEnabled(AncientTomesModule.class) && overleveledBooksGlowRainbow && itemStack.m_41720_() == Items.f_42690_ && AncientTomesModule.isOverlevel(itemStack) ? Rarity.EPIC : returnValue;
    }

    private static List<String> generateDefaultEnchantmentList() {
        Enchantment[] enchants = new Enchantment[]{Enchantments.f_44967_, Enchantments.f_44972_, Enchantments.f_44977_, Enchantments.f_44978_, Enchantments.f_44979_, Enchantments.f_44980_, Enchantments.f_44981_, Enchantments.f_44982_, Enchantments.f_44983_, Enchantments.f_44984_, Enchantments.f_44986_, Enchantments.f_44987_, Enchantments.f_44988_, Enchantments.f_44989_, Enchantments.f_44953_, Enchantments.f_44954_, Enchantments.f_44955_, Enchantments.f_44957_, Enchantments.f_44956_, Enchantments.f_44961_};
        ArrayList<String> strings = new ArrayList<String>();
        for (Enchantment e : enchants) {
            ResourceLocation regname = Registry.f_122825_.m_7981_((Object)e);
            if (e == null || regname == null) continue;
            strings.add(regname.toString());
        }
        return strings;
    }

    private void setupEnchantList() {
        MiscUtil.initializeEnchantmentList(enchantNames, validEnchants);
        validEnchants.removeIf(ench -> ench.m_6586_() == 1);
    }

    public void setupCursesList() {
        for (Enchantment e : Registry.f_122825_) {
            if (!e.m_6589_()) continue;
            this.curses.add(e);
        }
    }

    public static Enchantment getTomeEnchantment(ItemStack stack) {
        if (stack.m_41720_() != ancient_tome) {
            return null;
        }
        ListTag list = EnchantedBookItem.m_41163_((ItemStack)stack);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag nbt = list.m_128728_(i);
            Enchantment enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.m_135820_((String)nbt.m_128461_("id")));
            if (enchant == null) continue;
            return enchant;
        }
        return null;
    }

    private static boolean isAncientTomeOffer(MerchantOffer offer) {
        return offer.m_45358_().m_150930_(ancient_tome) && offer.m_45364_().m_150930_(Items.f_42690_) && offer.m_45368_().m_150930_(ancient_tome);
    }

    public static void moveVillagerItems(MerchantMenu menu, MerchantContainer container, MerchantOffer offer) {
        if (AncientTomesModule.isAncientTomeOffer(offer) && container.m_8020_(0).m_41619_() && container.m_8020_(1).m_41619_()) {
            ItemStack costA = offer.m_45358_();
            AncientTomesModule.moveFromInventoryToPaymentSlot(menu, container, offer, 0, costA);
            ItemStack costB = offer.m_45364_();
            AncientTomesModule.moveFromInventoryToPaymentSlot(menu, container, offer, 1, costB);
        }
    }

    private static void moveFromInventoryToPaymentSlot(MerchantMenu menu, MerchantContainer container, MerchantOffer offer, int tradeSlot, ItemStack targetStack) {
        menu.m_40060_(tradeSlot, targetStack);
        if (container.m_8020_(tradeSlot).m_41619_() && !targetStack.m_41619_()) {
            for (int slot = 3; slot < 39; ++slot) {
                ItemStack inSlot = ((Slot)menu.f_38839_.get(slot)).m_7993_();
                ItemStack currentStack = container.m_8020_(tradeSlot);
                if (ItemStack.m_150942_((ItemStack)inSlot, (ItemStack)offer.m_45368_()) || inSlot.m_41619_() || !(currentStack.m_41619_() ? offer.m_45365_(inSlot, targetStack) : ItemStack.m_150942_((ItemStack)targetStack, (ItemStack)inSlot))) continue;
                int currentCount = currentStack.m_41619_() ? 0 : currentStack.m_41613_();
                int amountToTake = Math.min(targetStack.m_41741_() - currentCount, inSlot.m_41613_());
                ItemStack newStack = inSlot.m_41777_();
                int newCount = currentCount + amountToTake;
                inSlot.m_41774_(amountToTake);
                newStack.m_41764_(newCount);
                container.m_6836_(tradeSlot, newStack);
                if (newCount >= targetStack.m_41741_()) break;
            }
        }
    }

    public static boolean matchWildcardEnchantedBook(MerchantOffer offer, ItemStack comparing, ItemStack reference) {
        Map referenceEnchants;
        if (AncientTomesModule.isAncientTomeOffer(offer) && comparing.m_150930_(Items.f_42690_) && reference.m_150930_(Items.f_42690_) && (referenceEnchants = EnchantmentHelper.m_44831_((ItemStack)reference)).size() == 1) {
            Enchantment enchantment = (Enchantment)referenceEnchants.keySet().iterator().next();
            int level = (Integer)referenceEnchants.get(enchantment);
            Map comparingEnchants = EnchantmentHelper.m_44831_((ItemStack)comparing);
            for (Map.Entry entry : comparingEnchants.entrySet()) {
                if (entry.getKey() != enchantment || (Integer)entry.getValue() < level) continue;
                return true;
            }
        }
        return false;
    }

    static {
        enchantNames = AncientTomesModule.generateDefaultEnchantmentList();
        overleveledBooksGlowRainbow = true;
        deepslateTweak = true;
        deepslateTweakNeedsHaste2 = true;
        librariansExchangeAncientTomes = true;
        curseGear = false;
        combineWithBooks = true;
        validEnchants = new ArrayList<Enchantment>();
        initialized = false;
        OVERLEVEL_COLOR_HANDLER = new ResourceLocation("quark", "overlevel_rune");
    }

    private class ExchangeAncientTomesTrade
    implements VillagerTrades.ItemListing {
        private ExchangeAncientTomesTrade() {
        }

        @Nullable
        public MerchantOffer m_213663_(@Nonnull Entity trader, @Nonnull RandomSource random) {
            if (validEnchants.isEmpty() || !AncientTomesModule.this.enabled) {
                return null;
            }
            Enchantment target = validEnchants.get(random.m_188503_(validEnchants.size()));
            ItemStack anyTome = new ItemStack((ItemLike)ancient_tome);
            ItemStack enchantedBook = EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(target, target.m_6586_()));
            ItemStack outputTome = AncientTomeItem.getEnchantedItemStack(target);
            return new MerchantOffer(anyTome, enchantedBook, outputTome, 3, 3, 0.2f);
        }
    }
}

